/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.types;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.model.types.InvalidValueException;

public class NormalPlayTime {
    private static final Pattern pattern = Pattern.compile("^(\\d+):(\\d{1,2}):(\\d{1,2})(\\.(\\d{1,3}))?|(\\d+)(\\.(\\d{1,3}))?$", 2);
    private long milliseconds;

    /*
     * WARNING - void declaration
     */
    public NormalPlayTime(long milliseconds) {
        void var1_1;
        if (milliseconds < 0L) {
            throw new InvalidValueException("Invalid parameter milliseconds: " + milliseconds);
        }
        this.milliseconds = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NormalPlayTime(long hours, long minutes, long seconds, long milliseconds) {
        void var3_2;
        void var1_1;
        if (hours < 0L) {
            throw new InvalidValueException("Invalid parameter hours: " + hours);
        }
        if (minutes < 0L || minutes > 59L) {
            throw new InvalidValueException("Invalid parameter minutes: " + hours);
        }
        if (seconds < 0L || seconds > 59L) {
            throw new InvalidValueException("Invalid parameter seconds: " + hours);
        }
        if (milliseconds < 0L || milliseconds > 999L) {
            throw new InvalidValueException("Invalid parameter milliseconds: " + milliseconds);
        }
        this.milliseconds = (var1_1 * 60L * 60L + var3_2 * 60L + seconds) * 1000L + milliseconds;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    /*
     * WARNING - void declaration
     */
    public void setMilliseconds(long milliseconds) {
        void var1_1;
        if (milliseconds < 0L) {
            throw new InvalidValueException("Invalid parameter milliseconds: " + milliseconds);
        }
        this.milliseconds = var1_1;
    }

    public String getString() {
        return this.getString(Format.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public String getString(Format format) {
        void var2_2;
        void var1_1;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(this.milliseconds);
        long ms = this.milliseconds % 1000L;
        switch (var1_1.ordinal()) {
            case 1: {
                seconds = TimeUnit.MILLISECONDS.toSeconds(this.milliseconds) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(this.milliseconds));
                long hours = TimeUnit.MILLISECONDS.toHours(this.milliseconds);
                long minutes = TimeUnit.MILLISECONDS.toMinutes(this.milliseconds) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(this.milliseconds));
                return String.format(Locale.ROOT, "%d:%02d:%02d.%03d", hours, minutes, seconds, ms);
            }
        }
        return String.format(Locale.ROOT, "%d.%03d", (long)var2_2, ms);
    }

    /*
     * WARNING - void declaration
     */
    public static NormalPlayTime valueOf(String s) {
        String string;
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            try {
                void var2_3;
                void var1_1;
                if (matcher.group(1) != null) {
                    int msMultiplier = (int)Math.pow(10.0, 3 - matcher.group(5).length());
                    return new NormalPlayTime(Long.parseLong(matcher.group(1)), Long.parseLong(matcher.group(2)), Long.parseLong(matcher.group(3)), Long.parseLong(matcher.group(5)) * (long)msMultiplier);
                }
                int msMultiplier = (int)Math.pow(10.0, 3 - matcher.group(8).length());
                return new NormalPlayTime(Long.parseLong(matcher.group(6)) * 1000L + Long.parseLong(var1_1.group(8)) * (long)var2_3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new InvalidValueException("Can't parse NormalPlayTime: " + string);
    }

    public static enum Format {
        SECONDS,
        TIME;

    }
}

