/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.types;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.support.model.dlna.types.CodedDataBuffer;

public class BufferInfoType {
    private static final Pattern pattern = Pattern.compile("^dejitter=(\\d{1,10})(;CDB=(\\d{1,10});BTM=(0|1|2))?(;TD=(\\d{1,10}))?(;BFR=(0|1))?$", 2);
    private Long dejitterSize;
    private CodedDataBuffer cdb;
    private Long targetDuration;
    private Boolean fullnessReports;

    /*
     * WARNING - void declaration
     */
    public BufferInfoType(Long dejitterSize) {
        void var1_1;
        this.dejitterSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BufferInfoType(Long dejitterSize, CodedDataBuffer cdb, Long targetDuration, Boolean fullnessReports) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.dejitterSize = var1_1;
        this.cdb = var2_2;
        this.targetDuration = var3_3;
        this.fullnessReports = fullnessReports;
    }

    /*
     * WARNING - void declaration
     */
    public static BufferInfoType valueOf(String s) {
        String string;
        Matcher matcher = pattern.matcher(s);
        if (matcher.matches()) {
            try {
                void var3_3;
                void var2_2;
                Long dejitterSize = Long.parseLong(matcher.group(1));
                CodedDataBuffer cdb = null;
                Long targetDuration = null;
                Boolean fullnessReports = null;
                if (matcher.group(2) != null) {
                    cdb = new CodedDataBuffer(Long.parseLong(matcher.group(3)), CodedDataBuffer.TransferMechanism.values()[Integer.parseInt(matcher.group(4))]);
                }
                if (matcher.group(5) != null) {
                    targetDuration = Long.parseLong(matcher.group(6));
                }
                if (matcher.group(7) != null) {
                    void var1_1;
                    fullnessReports = var1_1.group(8).equals("1");
                }
                return new BufferInfoType((Long)var2_2, (CodedDataBuffer)var3_3, targetDuration, fullnessReports);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new InvalidValueException("Can't parse BufferInfoType: " + string);
    }

    /*
     * WARNING - void declaration
     */
    public String getString() {
        void var1_1;
        String s = "dejitter=" + this.dejitterSize.toString();
        if (this.cdb != null) {
            s = s + ";CDB=" + this.cdb.getSize().toString() + ";BTM=" + this.cdb.getTranfer().ordinal();
        }
        if (this.targetDuration != null) {
            s = s + ";TD=" + this.targetDuration;
        }
        if (this.fullnessReports != null) {
            s = s + ";BFR=" + (this.fullnessReports != false ? "1" : "0");
        }
        return var1_1;
    }

    public Long getDejitterSize() {
        return this.dejitterSize;
    }

    public CodedDataBuffer getCdb() {
        return this.cdb;
    }

    public Long getTargetDuration() {
        return this.targetDuration;
    }

    public Boolean isFullnessReports() {
        return this.fullnessReports;
    }
}

