/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.message;

import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.support.model.dlna.message.header.DLNAHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLNAHeaders
extends UpnpHeaders {
    private final Logger logger = LoggerFactory.getLogger((String)DLNAHeaders.class.getName());
    protected Map<DLNAHeader.Type, List<UpnpHeader<?>>> parsedDLNAHeaders;

    public DLNAHeaders() {
    }

    /*
     * WARNING - void declaration
     */
    public DLNAHeaders(Map<String, List<String>> headers) {
        super((Map)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DLNAHeaders(ByteArrayInputStream inputStream) {
        super((ByteArrayInputStream)var1_1);
        void var1_1;
    }

    protected void parseHeaders() {
        if (this.parsedHeaders == null) {
            super.parseHeaders();
        }
        this.parsedDLNAHeaders = new LinkedHashMap();
        this.logger.debug("Parsing all HTTP headers for known UPnP headers: {}", (Object)this.size());
        for (Map.Entry entry : this.entrySet()) {
            Iterator iterator;
            if (entry.getKey() == null) continue;
            DLNAHeader.Type type = DLNAHeader.Type.getByHttpName((String)entry.getKey());
            if (type == null) {
                this.logger.debug("Ignoring non-UPNP HTTP header: {}", entry.getKey());
                continue;
            }
            for (String value : (List)iterator.getValue()) {
                DLNAHeader<?> upnpHeader = DLNAHeader.newInstance(type, value);
                if (upnpHeader == null || upnpHeader.getValue() == null) {
                    this.logger.debug("Ignoring known but non-parsable header (value violates the UDA specification?) '{}': {}", (Object)type.getHttpName(), (Object)value);
                    continue;
                }
                this.addParsedValue(type, upnpHeader);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addParsedValue(DLNAHeader.Type type, UpnpHeader<?> value) {
        void var2_2;
        List list;
        this.logger.debug("Adding parsed header: {}", value);
        list = this.parsedDLNAHeaders.computeIfAbsent((DLNAHeader.Type)((Object)list), k -> new LinkedList());
        list.add(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> put(String key, List<String> values) {
        void var2_2;
        void var1_1;
        this.parsedDLNAHeaders = null;
        return super.put((String)var1_1, (List)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void add(String key, String value) {
        void var2_2;
        void var1_1;
        this.parsedDLNAHeaders = null;
        super.add((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public List<String> remove(Object key) {
        void var1_1;
        this.parsedDLNAHeaders = null;
        return super.remove((Object)var1_1);
    }

    public void clear() {
        this.parsedDLNAHeaders = null;
        super.clear();
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(DLNAHeader.Type type) {
        void var1_1;
        if (this.parsedDLNAHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedDLNAHeaders.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public List<UpnpHeader<?>> get(DLNAHeader.Type type) {
        void var1_1;
        if (this.parsedDLNAHeaders == null) {
            this.parseHeaders();
        }
        return this.parsedDLNAHeaders.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void add(DLNAHeader.Type type, UpnpHeader<?> value) {
        super.add(type.getHttpName(), value.getString());
        if (this.parsedDLNAHeaders != null) {
            void var2_2;
            void var1_1;
            this.addParsedValue((DLNAHeader.Type)var1_1, (UpnpHeader<?>)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void remove(DLNAHeader.Type type) {
        super.remove((Object)type.getHttpName());
        if (this.parsedDLNAHeaders != null) {
            void var1_1;
            this.parsedDLNAHeaders.remove(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public UpnpHeader<?>[] getAsArray(DLNAHeader.Type type) {
        if (this.parsedDLNAHeaders == null) {
            this.parseHeaders();
        }
        if (this.parsedDLNAHeaders.get((Object)type) != null) {
            void var1_1;
            return this.parsedDLNAHeaders.get((Object)type).toArray(new UpnpHeader[this.parsedDLNAHeaders.get(var1_1).size()]);
        }
        return new UpnpHeader[0];
    }

    /*
     * WARNING - void declaration
     */
    public UpnpHeader<?> getFirstHeader(DLNAHeader.Type type) {
        if (this.getAsArray(type).length > 0) {
            void var1_1;
            return this.getAsArray((DLNAHeader.Type)var1_1)[0];
        }
        return null;
    }

    public <H extends UpnpHeader<?>> H getFirstHeader(DLNAHeader.Type type, Class<H> subtype) {
        UpnpHeader<?>[] upnpHeaderArray;
        UpnpHeader<?>[] upnpHeaderArray2 = this.getAsArray((DLNAHeader.Type)upnpHeaderArray);
        upnpHeaderArray = upnpHeaderArray2;
        upnpHeaderArray = upnpHeaderArray2;
        int n = upnpHeaderArray2.length;
        for (int i = 0; i < n; ++i) {
            UpnpHeader<?> header = upnpHeaderArray[i];
            if (!subtype.isAssignableFrom(header.getClass())) continue;
            return (H)header;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void log() {
        if (this.logger.isTraceEnabled()) {
            super.log();
            if (this.parsedDLNAHeaders != null && !this.parsedDLNAHeaders.isEmpty()) {
                this.logger.trace("########################## PARSED DLNA HEADERS ##########################");
                for (Map.Entry<DLNAHeader.Type, List<UpnpHeader<?>>> entry : this.parsedDLNAHeaders.entrySet()) {
                    Iterator iterator;
                    this.logger.trace("=== TYPE: {}", (Object)entry.getKey());
                    for (UpnpHeader upnpHeader : (List)iterator.getValue()) {
                        void var3_3;
                        this.logger.trace("HEADER: {}", (Object)var3_3);
                    }
                }
            }
            this.logger.trace("####################################################################");
        }
    }
}

