/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna;

import java.util.EnumMap;
import java.util.Map;
import org.jupnp.support.model.Protocol;
import org.jupnp.support.model.ProtocolInfo;
import org.jupnp.support.model.dlna.DLNAAttribute;
import org.jupnp.support.model.dlna.DLNAProfileAttribute;
import org.jupnp.support.model.dlna.DLNAProfiles;
import org.jupnp.util.MimeType;

public class DLNAProtocolInfo
extends ProtocolInfo {
    protected final Map<DLNAAttribute.Type, DLNAAttribute<?>> attributes = new EnumMap(DLNAAttribute.Type.class);

    /*
     * WARNING - void declaration
     */
    public DLNAProtocolInfo(String s) {
        super((String)var1_1);
        void var1_1;
        this.parseAdditionalInfo();
    }

    /*
     * WARNING - void declaration
     */
    public DLNAProtocolInfo(MimeType contentFormatMimeType) {
        super((MimeType)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DLNAProtocolInfo(DLNAProfiles profile) {
        super(MimeType.valueOf((String)profile.getContentFormat()));
        void var1_1;
        this.attributes.put(DLNAAttribute.Type.DLNA_ORG_PN, new DLNAProfileAttribute((DLNAProfiles)var1_1));
        this.additionalInfo = this.getAttributesString();
    }

    /*
     * WARNING - void declaration
     */
    public DLNAProtocolInfo(DLNAProfiles profile, Map<DLNAAttribute.Type, DLNAAttribute<?>> attributes) {
        super(MimeType.valueOf((String)profile.getContentFormat()));
        void var1_1;
        void var2_2;
        this.attributes.putAll((Map<DLNAAttribute.Type, DLNAAttribute<?>>)var2_2);
        this.attributes.put(DLNAAttribute.Type.DLNA_ORG_PN, new DLNAProfileAttribute((DLNAProfiles)var1_1));
        this.additionalInfo = this.getAttributesString();
    }

    /*
     * WARNING - void declaration
     */
    public DLNAProtocolInfo(Protocol protocol, String network, String contentFormat, String additionalInfo) {
        super((Protocol)var1_1, (String)var2_2, (String)var3_3, additionalInfo);
        void var3_3;
        void var2_2;
        void var1_1;
        this.parseAdditionalInfo();
    }

    /*
     * WARNING - void declaration
     */
    public DLNAProtocolInfo(Protocol protocol, String network, String contentFormat, Map<DLNAAttribute.Type, DLNAAttribute<?>> attributes) {
        super((Protocol)var1_1, (String)var2_2, (String)var3_3, "");
        void var3_3;
        void var2_2;
        void var1_1;
        this.attributes.putAll(attributes);
        this.additionalInfo = this.getAttributesString();
    }

    /*
     * WARNING - void declaration
     */
    public DLNAProtocolInfo(ProtocolInfo template) {
        this(template.getProtocol(), template.getNetwork(), template.getContentFormat(), var1_1.getAdditionalInfo());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(DLNAAttribute.Type type) {
        void var1_1;
        return this.attributes.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public DLNAAttribute<?> getAttribute(DLNAAttribute.Type type) {
        void var1_1;
        return this.attributes.get(var1_1);
    }

    public Map<DLNAAttribute.Type, DLNAAttribute<?>> getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - void declaration
     */
    protected String getAttributesString() {
        void var1_1;
        StringBuilder sb = new StringBuilder();
        for (DLNAAttribute.Type type : DLNAAttribute.Type.values()) {
            String value = this.attributes.containsKey((Object)type) ? this.attributes.get((Object)type).getString() : null;
            if (value == null || value.isEmpty()) continue;
            StringBuilder stringBuilder = sb;
            stringBuilder.append(stringBuilder.length() == 0 ? "" : ";");
            sb.append(type.getAttributeName());
            sb.append("=");
            sb.append(value);
        }
        return var1_1.toString();
    }

    protected void parseAdditionalInfo() {
        if (this.additionalInfo != null) {
            String[] stringArray = this.additionalInfo.split(";");
            String[] stringArray2 = stringArray;
            stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                DLNAAttribute.Type type;
                String string = stringArray2[i];
                String[] attNameValue = string.split("=");
                if (attNameValue.length != 2 || (type = DLNAAttribute.Type.valueOfAttributeName(attNameValue[0])) == null) continue;
                DLNAAttribute<?> dlnaAttrinute = DLNAAttribute.newInstance(type, attNameValue[1], this.getContentFormat());
                this.attributes.put(type, dlnaAttrinute);
            }
        }
    }
}

