/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna;

import java.util.EnumSet;
import java.util.Locale;
import org.jupnp.support.model.dlna.DLNAAttribute;
import org.jupnp.support.model.dlna.DLNAOperations;
import org.jupnp.support.model.dlna.InvalidDLNAProtocolAttributeException;

public class DLNAOperationsAttribute
extends DLNAAttribute<EnumSet<DLNAOperations>> {
    public DLNAOperationsAttribute() {
        this.setValue(EnumSet.of(DLNAOperations.NONE));
    }

    /*
     * WARNING - void declaration
     */
    public DLNAOperationsAttribute(DLNAOperations ... op) {
        if (op != null && op.length > 0) {
            void var2_2;
            DLNAOperations first = op[0];
            if (op.length > 1) {
                void var1_1;
                System.arraycopy(op, 1, op, 0, op.length - 1);
                this.setValue(EnumSet.of(first, var1_1));
                return;
            }
            this.setValue(EnumSet.of(var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setString(String s, String cf) {
        void var2_2;
        EnumSet<DLNAOperations> value = EnumSet.noneOf(DLNAOperations.class);
        try {
            int parseInt = Integer.parseInt(s, 16);
            for (DLNAOperations op : DLNAOperations.values()) {
                int code = op.getCode() & parseInt;
                if (op == DLNAOperations.NONE || op.getCode() != code) continue;
                value.add(op);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if (value.isEmpty()) {
            void var1_1;
            throw new InvalidDLNAProtocolAttributeException("Can't parse DLNA operations integer from: " + (String)var1_1);
        }
        this.setValue(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getString() {
        void var1_1;
        int code = DLNAOperations.NONE.getCode();
        for (DLNAOperations op : (EnumSet)this.getValue()) {
            void var3_3;
            code |= var3_3.getCode();
        }
        return String.format(Locale.ROOT, "%02x", (int)var1_1);
    }
}

