/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna;

import java.util.EnumSet;
import java.util.Locale;
import org.jupnp.support.model.dlna.DLNAAttribute;
import org.jupnp.support.model.dlna.DLNAFlags;
import org.jupnp.support.model.dlna.InvalidDLNAProtocolAttributeException;

public class DLNAFlagsAttribute
extends DLNAAttribute<EnumSet<DLNAFlags>> {
    public DLNAFlagsAttribute() {
        this.setValue(EnumSet.noneOf(DLNAFlags.class));
    }

    /*
     * WARNING - void declaration
     */
    public DLNAFlagsAttribute(DLNAFlags ... flags) {
        if (flags != null && flags.length > 0) {
            void var2_2;
            DLNAFlags first = flags[0];
            if (flags.length > 1) {
                void var1_1;
                System.arraycopy(flags, 1, flags, 0, flags.length - 1);
                this.setValue(EnumSet.of(first, var1_1));
                return;
            }
            this.setValue(EnumSet.of(var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setString(String s, String cf) {
        void var2_2;
        EnumSet<DLNAFlags> value = EnumSet.noneOf(DLNAFlags.class);
        try {
            int parseInt = Integer.parseInt(s.substring(0, s.length() - 24), 16);
            for (DLNAFlags op : DLNAFlags.values()) {
                int code = op.getCode() & parseInt;
                if (op.getCode() != code) continue;
                value.add(op);
            }
        }
        catch (Exception exception) {}
        if (value.isEmpty()) {
            void var1_1;
            throw new InvalidDLNAProtocolAttributeException("Can't parse DLNA flags integer from: " + (String)var1_1);
        }
        this.setValue(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getString() {
        void var1_1;
        int code = 0;
        for (DLNAFlags op : (EnumSet)this.getValue()) {
            void var3_3;
            code |= var3_3.getCode();
        }
        return String.format(Locale.ROOT, "%08x%024x", (int)var1_1, 0);
    }
}

