/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import java.util.HashMap;
import java.util.Map;
import org.jupnp.model.ModelUtil;

public enum StorageMedium {
    UNKNOWN,
    DV,
    MINI_DV("MINI-DV"),
    VHS,
    W_VHS("W-VHS"),
    S_VHS("S-VHS"),
    D_VHS("D-VHS"),
    VHSC,
    VIDEO8,
    HI8,
    CD_ROM("CD-ROM"),
    CD_DA("CD-DA"),
    CD_R("CD-R"),
    CD_RW("CD-RW"),
    VIDEO_CD("VIDEO-CD"),
    SACD,
    MD_AUDIO("M-AUDIO"),
    MD_PICTURE("MD-PICTURE"),
    DVD_ROM("DVD-ROM"),
    DVD_VIDEO("DVD-VIDEO"),
    DVD_R("DVD-R"),
    DVD_PLUS_RW("DVD+RW"),
    DVD_MINUS_RW("DVD-RW"),
    DVD_RAM("DVD-RAM"),
    DVD_AUDIO("DVD-AUDIO"),
    DAT,
    LD,
    HDD,
    MICRO_MV("MICRO_MV"),
    NETWORK,
    NONE,
    NOT_IMPLEMENTED,
    VENDOR_SPECIFIC;

    private static final Map<String, StorageMedium> byProtocolString;
    private final String protocolString;

    private StorageMedium() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    private StorageMedium(String protocolString) {
        void var3_3;
        this.protocolString = protocolString == null ? this.name() : var3_3;
    }

    public final String toString() {
        return this.protocolString;
    }

    /*
     * WARNING - void declaration
     */
    public static StorageMedium valueOrExceptionOf(String s) {
        String string;
        StorageMedium sm = byProtocolString.get(s);
        if (sm != null) {
            void var1_1;
            return var1_1;
        }
        throw new IllegalArgumentException("Invalid storage medium string: " + string);
    }

    public static StorageMedium valueOrVendorSpecificOf(String s) {
        Object sm = byProtocolString.get(s);
        if (sm != null) {
            Object object;
            return object;
        }
        return VENDOR_SPECIFIC;
    }

    /*
     * WARNING - void declaration
     */
    public static StorageMedium[] valueOfCommaSeparatedList(String s) {
        void var1_1;
        String[] strings = ModelUtil.fromCommaSeparatedList((String)s);
        if (strings == null) {
            return new StorageMedium[0];
        }
        StorageMedium[] result = new StorageMedium[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            result[i] = StorageMedium.valueOrVendorSpecificOf(strings[i]);
        }
        return var1_1;
    }

    static {
        byProtocolString = new HashMap<String, StorageMedium>(){
            private static final long serialVersionUID = 1635734229355713298L;
            {
                for (StorageMedium e : StorageMedium.values()) {
                    this.put(e.protocolString, e);
                }
            }
        };
    }
}

