/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.jupnp.support.model.DIDLAttribute;
import org.jupnp.support.model.DescMeta;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.PersonWithRole;
import org.jupnp.support.model.Res;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.WriteStatus;
import org.w3c.dom.Element;

public abstract class DIDLObject {
    protected String id;
    protected String parentID;
    protected String title;
    protected String creator;
    protected boolean restricted = true;
    protected WriteStatus writeStatus;
    protected Class clazz;
    protected List<Res> resources = new ArrayList<Res>();
    protected List<Property<?>> properties = new ArrayList();
    protected List<DescMeta<?>> descMetadata = new ArrayList();

    protected DIDLObject() {
    }

    /*
     * WARNING - void declaration
     */
    protected DIDLObject(DIDLObject other) {
        this(other.getId(), other.getParentID(), other.getTitle(), other.getCreator(), other.isRestricted(), other.getWriteStatus(), other.getClazz(), other.getResources(), other.getProperties(), var1_1.getDescMetadata());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected DIDLObject(String id, String parentID, String title, String creator, boolean restricted, WriteStatus writeStatus, Class clazz, List<Res> resources, List<Property<?>> properties, List<DescMeta<?>> descMetadata) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.id = var1_1;
        this.parentID = var2_2;
        this.title = var3_3;
        this.creator = creator;
        this.restricted = restricted;
        this.writeStatus = writeStatus;
        this.clazz = clazz;
        this.resources = resources;
        this.properties = properties;
        this.descMetadata = descMetadata;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject setId(String id) {
        void var1_1;
        this.id = var1_1;
        return this;
    }

    public String getParentID() {
        return this.parentID;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject setParentID(String parentID) {
        void var1_1;
        this.parentID = var1_1;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject setTitle(String title) {
        void var1_1;
        this.title = var1_1;
        return this;
    }

    public String getCreator() {
        return this.creator;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject setCreator(String creator) {
        void var1_1;
        this.creator = var1_1;
        return this;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject setRestricted(boolean restricted) {
        void var1_1;
        this.restricted = var1_1;
        return this;
    }

    public WriteStatus getWriteStatus() {
        return this.writeStatus;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject setWriteStatus(WriteStatus writeStatus) {
        void var1_1;
        this.writeStatus = var1_1;
        return this;
    }

    public Res getFirstResource() {
        if (!this.getResources().isEmpty()) {
            return this.getResources().get(0);
        }
        return null;
    }

    public List<Res> getResources() {
        return this.resources;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject setResources(List<Res> resources) {
        void var1_1;
        this.resources = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject addResource(Res resource) {
        void var1_1;
        this.getResources().add((Res)var1_1);
        return this;
    }

    public Class getClazz() {
        return this.clazz;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject setClazz(Class clazz) {
        void var1_1;
        this.clazz = var1_1;
        return this;
    }

    public List<Property<?>> getProperties() {
        return this.properties;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject setProperties(List<Property<?>> properties) {
        void var1_1;
        this.properties = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject addProperty(Property property) {
        void var1_1;
        if (property == null) {
            return this;
        }
        this.getProperties().add((Property<?>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject replaceFirstProperty(Property<?> property) {
        void var1_1;
        if (property == null) {
            return this;
        }
        this.getProperties().removeIf(p -> {
            Property property2;
            return p.getClass().isAssignableFrom(property2.getClass());
        });
        this.addProperty((Property)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject replaceProperties(java.lang.Class<? extends Property<?>> propertyClass, Property<?>[] properties) {
        void var2_2;
        void var1_1;
        if (properties.length == 0) {
            return this;
        }
        this.removeProperties((java.lang.Class<? extends Property<?>>)var1_1);
        return this.addProperties((Property<?>[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject addProperties(Property<?>[] properties) {
        void var1_1;
        if (properties == null) {
            return this;
        }
        for (void property : var1_1) {
            this.addProperty((Property)property);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject removeProperties(java.lang.Class<? extends Property<?>> propertyClass) {
        void var1_1;
        this.getProperties().removeIf(((java.lang.Class)var1_1)::isInstance);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasProperty(java.lang.Class<? extends Property<?>> propertyClass) {
        for (Property<?> property : this.getProperties()) {
            void var3_3;
            if (!propertyClass.isInstance(var3_3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public <V> Property<V> getFirstProperty(java.lang.Class<? extends Property<V>> propertyClass) {
        for (Property<?> property : this.getProperties()) {
            void var3_3;
            if (!propertyClass.isInstance(property)) continue;
            return var3_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public <V> Property<V> getLastProperty(java.lang.Class<? extends Property<V>> propertyClass) {
        void var2_2;
        Property<?> found = null;
        for (Property<?> property : this.getProperties()) {
            if (!propertyClass.isInstance(property)) continue;
            found = property;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <V> Property<V>[] getProperties(java.lang.Class<? extends Property<V>> propertyClass) {
        void var2_2;
        ArrayList list = new ArrayList();
        for (Property<?> property : this.getProperties()) {
            if (!propertyClass.isInstance(property)) continue;
            list.add(property);
        }
        void v0 = var2_2;
        return v0.toArray(new Property[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public <V> Property<V>[] getPropertiesByNamespace(java.lang.Class<? extends Property.NAMESPACE> namespace) {
        void var2_2;
        ArrayList list = new ArrayList();
        for (Property<?> property : this.getProperties()) {
            if (!namespace.isInstance(property)) continue;
            list.add(property);
        }
        void v0 = var2_2;
        return v0.toArray(new Property[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public <V> V getFirstPropertyValue(java.lang.Class<? extends Property<V>> propertyClass) {
        void var1_1;
        Property<V> prop = this.getFirstProperty(propertyClass);
        if (prop == null) {
            return null;
        }
        return var1_1.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public <V> List<V> getPropertyValues(java.lang.Class<? extends Property<V>> propertyClass) {
        void var2_2;
        Property<V>[] propertyArray;
        ArrayList<V> list = new ArrayList<V>();
        for (Property<V> property : this.getProperties((java.lang.Class<? extends Property<V>>)propertyArray)) {
            list.add(property.getValue());
        }
        return var2_2;
    }

    public List<DescMeta<?>> getDescMetadata() {
        return this.descMetadata;
    }

    /*
     * WARNING - void declaration
     */
    public void setDescMetadata(List<DescMeta<?>> descMetadata) {
        void var1_1;
        this.descMetadata = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLObject addDescMetadata(DescMeta<?> descMetadata) {
        void var1_1;
        this.getDescMetadata().add((DescMeta<?>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DIDLObject that = (DIDLObject)o;
        return this.id.equals(var1_1.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static class Class {
        protected String value;
        protected String friendlyName;
        protected boolean includeDerived;

        public Class() {
        }

        /*
         * WARNING - void declaration
         */
        public Class(String value) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Class(String value, String friendlyName) {
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.friendlyName = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Class(String value, String friendlyName, boolean includeDerived) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.friendlyName = var2_2;
            this.includeDerived = var3_3;
        }

        public String getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(String value) {
            void var1_1;
            this.value = var1_1;
        }

        public String getFriendlyName() {
            return this.friendlyName;
        }

        /*
         * WARNING - void declaration
         */
        public void setFriendlyName(String friendlyName) {
            void var1_1;
            this.friendlyName = var1_1;
        }

        public boolean isIncludeDerived() {
            return this.includeDerived;
        }

        /*
         * WARNING - void declaration
         */
        public void setIncludeDerived(boolean includeDerived) {
            void var1_1;
            this.includeDerived = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(DIDLObject instance) {
            void var1_1;
            return this.getValue().equals(var1_1.getClazz().getValue());
        }
    }

    public static abstract class Property<V> {
        private V value;
        private final String descriptorName;
        private final List<Property<DIDLAttribute>> attributes = new ArrayList<Property<DIDLAttribute>>();

        protected Property() {
            this(null, null);
        }

        /*
         * WARNING - void declaration
         */
        protected Property(String descriptorName) {
            this(null, (String)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected Property(V value, String descriptorName) {
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.descriptorName = descriptorName == null ? this.getClass().getSimpleName().toLowerCase(Locale.ROOT).replace("didlobject$property$upnp$", "") : var2_2;
        }

        /*
         * WARNING - void declaration
         */
        protected Property(V value, String descriptorName, List<Property<DIDLAttribute>> attributes) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.value = var1_1;
            this.descriptorName = descriptorName == null ? this.getClass().getSimpleName().toLowerCase(Locale.ROOT).replace("didlobject$property$upnp$", "") : var2_2;
            this.attributes.addAll((Collection<Property<DIDLAttribute>>)var3_3);
        }

        public V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        public void setValue(V value) {
            void var1_1;
            this.value = var1_1;
        }

        public String getDescriptorName() {
            return this.descriptorName;
        }

        /*
         * WARNING - void declaration
         */
        public void setOnElement(Element element) {
            element.setTextContent(this.toString());
            for (Property<DIDLAttribute> attr : this.attributes) {
                void var3_3;
                element.setAttributeNS(attr.getValue().getNamespaceURI(), attr.getValue().getPrefix() + ":" + attr.getDescriptorName(), ((DIDLAttribute)var3_3.getValue()).getValue());
            }
        }

        /*
         * WARNING - void declaration
         */
        public void addAttribute(Property<DIDLAttribute> attr) {
            void var1_1;
            this.attributes.add((Property<DIDLAttribute>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void removeAttribute(Property<DIDLAttribute> attr) {
            void var1_1;
            this.attributes.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void removeAttribute(String descriptorName) {
            for (Property<DIDLAttribute> attr : this.attributes) {
                void var3_3;
                if (!attr.getDescriptorName().equals(descriptorName)) continue;
                this.removeAttribute((Property<DIDLAttribute>)var3_3);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public Property<DIDLAttribute> getAttribute(String descriptorName) {
            for (Property<DIDLAttribute> attr : this.attributes) {
                void var3_3;
                if (!attr.getDescriptorName().equals(descriptorName)) continue;
                return var3_3;
            }
            return null;
        }

        public String toString() {
            if (this.getValue() != null) {
                return this.getValue().toString();
            }
            return "";
        }

        public static abstract class DLNA {

            public static class PROFILE_ID
            extends Property<DIDLAttribute>
            implements NAMESPACE {
                public PROFILE_ID() {
                    this((DIDLAttribute)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public PROFILE_ID(DIDLAttribute value) {
                    super(var1_1, "profileID");
                    void var1_1;
                }
            }

            public static interface NAMESPACE
            extends org.jupnp.support.model.DIDLObject$Property$NAMESPACE {
                public static final String URI = "urn:schemas-dlna-org:metadata-1-0/";
            }
        }

        public static abstract class UPNP {

            public static class USER_ANNOTATION
            extends Property<String>
            implements NAMESPACE {
                public USER_ANNOTATION() {
                    this(null);
                }

                /*
                 * WARNING - void declaration
                 */
                public USER_ANNOTATION(String value) {
                    super(var1_1, "userAnnotation");
                    void var1_1;
                }
            }

            public static class ORIGINAL_TRACK_NUMBER
            extends Property<Integer>
            implements NAMESPACE {
                public ORIGINAL_TRACK_NUMBER() {
                    this((Integer)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public ORIGINAL_TRACK_NUMBER(Integer value) {
                    super(var1_1, "originalTrackNumber");
                    void var1_1;
                }
            }

            public static class DVD_REGION_CODE
            extends Property<Integer>
            implements NAMESPACE {
                public DVD_REGION_CODE() {
                    this((Integer)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public DVD_REGION_CODE(Integer value) {
                    super(var1_1, "DVDRegionCode");
                    void var1_1;
                }
            }

            public static class SCHEDULED_END_TIME
            extends Property<String>
            implements NAMESPACE {
                public SCHEDULED_END_TIME() {
                    this(null);
                }

                /*
                 * WARNING - void declaration
                 */
                public SCHEDULED_END_TIME(String value) {
                    super(var1_1, "scheduledEndTime");
                    void var1_1;
                }
            }

            public static class SCHEDULED_START_TIME
            extends Property<String>
            implements NAMESPACE {
                public SCHEDULED_START_TIME() {
                    this(null);
                }

                /*
                 * WARNING - void declaration
                 */
                public SCHEDULED_START_TIME(String value) {
                    super(var1_1, "scheduledStartTime");
                    void var1_1;
                }
            }

            public static class CHANNEL_NAME
            extends Property<String>
            implements NAMESPACE {
                public CHANNEL_NAME() {
                    this(null);
                }

                /*
                 * WARNING - void declaration
                 */
                public CHANNEL_NAME(String value) {
                    super(var1_1, "channelName");
                    void var1_1;
                }
            }

            public static class CHANNEL_NR
            extends Property<Integer>
            implements NAMESPACE {
                public CHANNEL_NR() {
                    this((Integer)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public CHANNEL_NR(Integer value) {
                    super(var1_1, "channelNr");
                    void var1_1;
                }
            }

            public static class RADIO_BAND
            extends Property<String>
            implements NAMESPACE {
                public RADIO_BAND() {
                    this(null);
                }

                /*
                 * WARNING - void declaration
                 */
                public RADIO_BAND(String value) {
                    super(var1_1, "radioBand");
                    void var1_1;
                }
            }

            public static class RADIO_STATION_ID
            extends Property<String>
            implements NAMESPACE {
                public RADIO_STATION_ID() {
                    this(null);
                }

                /*
                 * WARNING - void declaration
                 */
                public RADIO_STATION_ID(String value) {
                    super(var1_1, "radioStationID");
                    void var1_1;
                }
            }

            public static class RADIO_CALL_SIGN
            extends Property<String>
            implements NAMESPACE {
                public RADIO_CALL_SIGN() {
                    this(null);
                }

                /*
                 * WARNING - void declaration
                 */
                public RADIO_CALL_SIGN(String value) {
                    super(var1_1, "radioCallSign");
                    void var1_1;
                }
            }

            public static class ICON
            extends Property<URI>
            implements NAMESPACE {
                public ICON() {
                    this((URI)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public ICON(URI value) {
                    super(var1_1, "icon");
                    void var1_1;
                }
            }

            public static class LONG_DESCRIPTION
            extends Property<String>
            implements NAMESPACE {
                public LONG_DESCRIPTION() {
                    this(null);
                }

                /*
                 * WARNING - void declaration
                 */
                public LONG_DESCRIPTION(String value) {
                    super(var1_1, "longDescription");
                    void var1_1;
                }
            }

            public static class STORAGE_MEDIUM
            extends Property<StorageMedium>
            implements NAMESPACE {
                public STORAGE_MEDIUM() {
                    this((StorageMedium)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public STORAGE_MEDIUM(StorageMedium value) {
                    super(var1_1, "storageMedium");
                    void var1_1;
                }
            }

            public static class STORAGE_MAX_PARTITION
            extends Property<Long>
            implements NAMESPACE {
                public STORAGE_MAX_PARTITION() {
                    this((Long)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public STORAGE_MAX_PARTITION(Long value) {
                    super(var1_1, "storageMaxPartition");
                    void var1_1;
                }
            }

            public static class STORAGE_FREE
            extends Property<Long>
            implements NAMESPACE {
                public STORAGE_FREE() {
                    this((Long)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public STORAGE_FREE(Long value) {
                    super(var1_1, "storageFree");
                    void var1_1;
                }
            }

            public static class STORAGE_USED
            extends Property<Long>
            implements NAMESPACE {
                public STORAGE_USED() {
                    this((Long)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public STORAGE_USED(Long value) {
                    super(var1_1, "storageUsed");
                    void var1_1;
                }
            }

            public static class STORAGE_TOTAL
            extends Property<Long>
            implements NAMESPACE {
                public STORAGE_TOTAL() {
                    this((Long)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public STORAGE_TOTAL(Long value) {
                    super(var1_1, "storageTotal");
                    void var1_1;
                }
            }

            public static class LYRICS_URI
            extends Property<URI>
            implements NAMESPACE {
                public LYRICS_URI() {
                    this((URI)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public LYRICS_URI(URI value) {
                    super(var1_1, "lyricsURI");
                    void var1_1;
                }
            }

            public static class ARTIST_DISCO_URI
            extends Property<URI>
            implements NAMESPACE {
                public ARTIST_DISCO_URI() {
                    this((URI)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public ARTIST_DISCO_URI(URI value) {
                    super(var1_1, "artistDiscographyURI");
                    void var1_1;
                }
            }

            public static class ALBUM_ART_URI
            extends Property<URI>
            implements NAMESPACE {
                public ALBUM_ART_URI() {
                    this((URI)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public ALBUM_ART_URI(URI value) {
                    super(var1_1, "albumArtURI");
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public ALBUM_ART_URI(URI value, List<Property<DIDLAttribute>> attributes) {
                    super(var1_1, "albumArtURI", (List<Property<DIDLAttribute>>)var2_2);
                    void var2_2;
                    void var1_1;
                }
            }

            public static class TOC
            extends Property<String>
            implements NAMESPACE {
                public TOC() {
                }

                /*
                 * WARNING - void declaration
                 */
                public TOC(String value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class RATING
            extends Property<String>
            implements NAMESPACE {
                public RATING() {
                }

                /*
                 * WARNING - void declaration
                 */
                public RATING(String value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class REGION
            extends Property<String>
            implements NAMESPACE {
                public REGION() {
                }

                /*
                 * WARNING - void declaration
                 */
                public REGION(String value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class PLAYLIST
            extends Property<String>
            implements NAMESPACE {
                public PLAYLIST() {
                }

                /*
                 * WARNING - void declaration
                 */
                public PLAYLIST(String value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class ALBUM
            extends Property<String>
            implements NAMESPACE {
                public ALBUM() {
                }

                /*
                 * WARNING - void declaration
                 */
                public ALBUM(String value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class GENRE
            extends Property<String>
            implements NAMESPACE {
                public GENRE() {
                }

                /*
                 * WARNING - void declaration
                 */
                public GENRE(String value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class DIRECTOR
            extends Property<Person>
            implements NAMESPACE {
                public DIRECTOR() {
                }

                /*
                 * WARNING - void declaration
                 */
                public DIRECTOR(Person value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class PRODUCER
            extends Property<Person>
            implements NAMESPACE {
                public PRODUCER() {
                }

                /*
                 * WARNING - void declaration
                 */
                public PRODUCER(Person value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class AUTHOR
            extends PropertyPersonWithRole
            implements NAMESPACE {
                public AUTHOR() {
                }

                /*
                 * WARNING - void declaration
                 */
                public AUTHOR(PersonWithRole value) {
                    super((PersonWithRole)var1_1, (String)null);
                    void var1_1;
                }
            }

            public static class ACTOR
            extends PropertyPersonWithRole
            implements NAMESPACE {
                public ACTOR() {
                }

                /*
                 * WARNING - void declaration
                 */
                public ACTOR(PersonWithRole value) {
                    super((PersonWithRole)var1_1, (String)null);
                    void var1_1;
                }
            }

            public static class ARTIST
            extends PropertyPersonWithRole
            implements NAMESPACE {
                public ARTIST() {
                }

                /*
                 * WARNING - void declaration
                 */
                public ARTIST(PersonWithRole value) {
                    super((PersonWithRole)var1_1, (String)null);
                    void var1_1;
                }
            }

            public static interface NAMESPACE
            extends org.jupnp.support.model.DIDLObject$Property$NAMESPACE {
                public static final String URI = "urn:schemas-upnp-org:metadata-1-0/upnp/";
            }
        }

        public static abstract class SEC {

            public static class TYPE
            extends Property<DIDLAttribute>
            implements NAMESPACE {
                public TYPE() {
                    this((DIDLAttribute)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public TYPE(DIDLAttribute value) {
                    super(var1_1, "type");
                    void var1_1;
                }
            }

            public static class CAPTIONINFO
            extends Property<URI>
            implements NAMESPACE {
                public CAPTIONINFO() {
                    this((URI)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public CAPTIONINFO(URI value) {
                    super(var1_1, "CaptionInfo");
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public CAPTIONINFO(URI value, List<Property<DIDLAttribute>> attributes) {
                    super(var1_1, "CaptionInfo", (List<Property<DIDLAttribute>>)var2_2);
                    void var2_2;
                    void var1_1;
                }
            }

            public static class CAPTIONINFOEX
            extends Property<URI>
            implements NAMESPACE {
                public CAPTIONINFOEX() {
                    this((URI)null);
                }

                /*
                 * WARNING - void declaration
                 */
                public CAPTIONINFOEX(URI value) {
                    super(var1_1, "CaptionInfoEx");
                    void var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                public CAPTIONINFOEX(URI value, List<Property<DIDLAttribute>> attributes) {
                    super(var1_1, "CaptionInfoEx", (List<Property<DIDLAttribute>>)var2_2);
                    void var2_2;
                    void var1_1;
                }
            }

            public static interface NAMESPACE
            extends org.jupnp.support.model.DIDLObject$Property$NAMESPACE {
                public static final String URI = "http://www.sec.co.kr/";
            }
        }

        public static class DC {

            public static class RIGHTS
            extends Property<String>
            implements NAMESPACE {
                public RIGHTS() {
                }

                /*
                 * WARNING - void declaration
                 */
                public RIGHTS(String value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class RELATION
            extends Property<URI>
            implements NAMESPACE {
                public RELATION() {
                }

                /*
                 * WARNING - void declaration
                 */
                public RELATION(URI value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class LANGUAGE
            extends Property<String>
            implements NAMESPACE {
                public LANGUAGE() {
                }

                /*
                 * WARNING - void declaration
                 */
                public LANGUAGE(String value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class DATE
            extends Property<String>
            implements NAMESPACE {
                public DATE() {
                }

                /*
                 * WARNING - void declaration
                 */
                public DATE(String value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class CONTRIBUTOR
            extends Property<Person>
            implements NAMESPACE {
                public CONTRIBUTOR() {
                }

                /*
                 * WARNING - void declaration
                 */
                public CONTRIBUTOR(Person value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class PUBLISHER
            extends Property<Person>
            implements NAMESPACE {
                public PUBLISHER() {
                }

                /*
                 * WARNING - void declaration
                 */
                public PUBLISHER(Person value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static class DESCRIPTION
            extends Property<String>
            implements NAMESPACE {
                public DESCRIPTION() {
                }

                /*
                 * WARNING - void declaration
                 */
                public DESCRIPTION(String value) {
                    super(var1_1, null);
                    void var1_1;
                }
            }

            public static interface NAMESPACE
            extends org.jupnp.support.model.DIDLObject$Property$NAMESPACE {
                public static final String URI = "http://purl.org/dc/elements/1.1/";
            }
        }

        public static class PropertyPersonWithRole
        extends Property<PersonWithRole> {
            public PropertyPersonWithRole() {
            }

            /*
             * WARNING - void declaration
             */
            public PropertyPersonWithRole(String descriptorName) {
                super((String)var1_1);
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public PropertyPersonWithRole(PersonWithRole value, String descriptorName) {
                super(var1_1, (String)var2_2);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void setOnElement(Element element) {
                if (this.getValue() != null) {
                    void var1_1;
                    ((PersonWithRole)this.getValue()).setOnElement((Element)var1_1);
                }
            }
        }

        public static interface NAMESPACE {
        }
    }
}

