/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import java.util.Objects;
import org.jupnp.model.ServiceReference;
import org.jupnp.support.model.ProtocolInfo;

public class ConnectionInfo {
    protected final int connectionID;
    protected final int rcsID;
    protected final int avTransportID;
    protected final ProtocolInfo protocolInfo;
    protected final ServiceReference peerConnectionManager;
    protected final int peerConnectionID;
    protected final Direction direction;
    protected Status connectionStatus = Status.Unknown;

    public ConnectionInfo() {
        this(0, 0, 0, null, null, -1, Direction.Input, Status.Unknown);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionInfo(int connectionID, int rcsID, int avTransportID, ProtocolInfo protocolInfo, ServiceReference peerConnectionManager, int peerConnectionID, Direction direction, Status connectionStatus) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.connectionID = var1_1;
        this.rcsID = var2_2;
        this.avTransportID = var3_3;
        this.protocolInfo = protocolInfo;
        this.peerConnectionManager = peerConnectionManager;
        this.peerConnectionID = peerConnectionID;
        this.direction = direction;
        this.connectionStatus = connectionStatus;
    }

    public int getConnectionID() {
        return this.connectionID;
    }

    public int getRcsID() {
        return this.rcsID;
    }

    public int getAvTransportID() {
        return this.avTransportID;
    }

    public ProtocolInfo getProtocolInfo() {
        return this.protocolInfo;
    }

    public ServiceReference getPeerConnectionManager() {
        return this.peerConnectionManager;
    }

    public int getPeerConnectionID() {
        return this.peerConnectionID;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public synchronized Status getConnectionStatus() {
        return this.connectionStatus;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setConnectionStatus(Status connectionStatus) {
        void var1_1;
        this.connectionStatus = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionInfo that = (ConnectionInfo)o;
        if (this.avTransportID != that.avTransportID) {
            return false;
        }
        if (this.connectionID != that.connectionID) {
            return false;
        }
        if (this.peerConnectionID != that.peerConnectionID) {
            return false;
        }
        if (this.rcsID != that.rcsID) {
            return false;
        }
        if (this.connectionStatus != that.connectionStatus) {
            return false;
        }
        if (this.direction != that.direction) {
            return false;
        }
        if (!Objects.equals(this.peerConnectionManager, that.peerConnectionManager)) {
            return false;
        }
        return Objects.equals(this.protocolInfo, var1_1.protocolInfo);
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = this.connectionID;
        result = result * 31 + this.rcsID;
        result = result * 31 + this.avTransportID;
        result = result * 31 + (this.protocolInfo != null ? this.protocolInfo.hashCode() : 0);
        result = result * 31 + (this.peerConnectionManager != null ? this.peerConnectionManager.hashCode() : 0);
        result = result * 31 + this.peerConnectionID;
        result = result * 31 + this.direction.hashCode();
        var1_1 = var1_1 * 31 + this.connectionStatus.hashCode();
        return (int)var1_1;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") ID: " + this.getConnectionID() + ", Status: " + String.valueOf((Object)this.getConnectionStatus());
    }

    public static enum Direction {
        Output,
        Input;


        public final Direction getOpposite() {
            if (this.equals((Object)Output)) {
                return Input;
            }
            return Output;
        }
    }

    public static enum Status {
        OK,
        ContentFormatMismatch,
        InsufficientBandwidth,
        UnreliableChannel,
        Unknown;

    }
}

