/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model;

import org.jupnp.model.types.UnsignedIntegerFourBytes;

public class Connection {

    public static enum Error {
        ERROR_NONE,
        ERROR_COMMAND_ABORTED,
        ERROR_NOT_ENABLED_FOR_INTERNET,
        ERROR_USER_DISCONNECT,
        ERROR_ISP_DISCONNECT,
        ERROR_IDLE_DISCONNECT,
        ERROR_FORCED_DISCONNECT,
        ERROR_NO_CARRIER,
        ERROR_IP_CONFIGURATION,
        ERROR_UNKNOWN;

    }

    public static enum Status {
        Unconfigured,
        Connecting,
        Connected,
        PendingDisconnect,
        Disconnecting,
        Disconnected;

    }

    public static enum Type {
        Unconfigured,
        IP_Routed,
        IP_Bridged;

    }

    public static class StatusInfo {
        private Status status;
        private long uptimeSeconds;
        private Error lastError;

        /*
         * WARNING - void declaration
         */
        public StatusInfo(Status status, UnsignedIntegerFourBytes uptime, Error lastError) {
            this((Status)var1_1, var2_2.getValue(), (Error)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public StatusInfo(Status status, long uptimeSeconds, Error lastError) {
            void var2_2;
            void var1_1;
            this.status = var1_1;
            this.uptimeSeconds = var2_2;
            this.lastError = lastError;
        }

        public Status getStatus() {
            return this.status;
        }

        public long getUptimeSeconds() {
            return this.uptimeSeconds;
        }

        public UnsignedIntegerFourBytes getUptime() {
            return new UnsignedIntegerFourBytes(this.getUptimeSeconds());
        }

        public Error getLastError() {
            return this.lastError;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void var1_1;
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatusInfo that = (StatusInfo)o;
            if (this.uptimeSeconds != that.uptimeSeconds) {
                return false;
            }
            if (this.lastError != that.lastError) {
                return false;
            }
            return this.status == var1_1.status;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result = this.status.hashCode();
            result = result * 31 + (int)(this.uptimeSeconds ^ this.uptimeSeconds >>> 32);
            var1_1 = var1_1 * 31 + this.lastError.hashCode();
            return (int)var1_1;
        }

        public String toString() {
            return "(" + this.getClass().getSimpleName() + ") " + String.valueOf((Object)this.getStatus());
        }
    }
}

