/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.lastchange;

import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jupnp.model.XMLUtil;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.support.lastchange.Event;
import org.jupnp.support.lastchange.EventedValue;
import org.jupnp.support.lastchange.InstanceID;
import org.jupnp.support.shared.AbstractMap;
import org.jupnp.util.io.IO;
import org.jupnp.xml.DOMParser;
import org.jupnp.xml.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class LastChangeParser
extends SAXParser {
    private final Logger logger = LoggerFactory.getLogger(LastChangeParser.class);

    protected abstract String getNamespace();

    protected Set<Class<? extends EventedValue<?>>> getEventedVariables() {
        return Collections.emptySet();
    }

    protected EventedValue<?> createValue(String name, Map.Entry<String, String>[] attributes) throws Exception {
        for (Class<EventedValue<?>> evType : this.getEventedVariables()) {
            if (!evType.getSimpleName().equals(name)) continue;
            name = evType.getConstructor(Map.Entry[].class);
            return ((Constructor)name).newInstance(new Object[]{attributes});
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Event parseResource(String resource) throws Exception {
        Event event;
        block5: {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            try {
                event = this.parse(IO.readLines((InputStream)is));
                if (is == null) break block5;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return event;
    }

    /*
     * WARNING - void declaration
     */
    public Event parse(String xml) throws Exception {
        void var2_2;
        Iterator<InstanceID> iterator;
        if (xml == null || xml.isEmpty()) {
            throw new RuntimeException("Null or empty XML");
        }
        Event event = new Event();
        new RootHandler(this, event, this);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Parsing 'LastChange' event XML content");
            this.logger.debug("===================================== 'LastChange' BEGIN ============================================");
            this.logger.debug(xml);
            this.logger.debug("====================================== 'LastChange' END  ============================================");
        }
        this.parse(new InputSource(new StringReader((String)((Object)iterator))));
        this.logger.debug("Parsed event with instances IDs: {}", (Object)event.getInstanceIDs().size());
        if (this.logger.isTraceEnabled()) {
            for (InstanceID instanceID : event.getInstanceIDs()) {
                Iterator<EventedValue<?>> iterator2;
                this.logger.trace("InstanceID '{}' has values: {}", (Object)instanceID.getId(), (Object)instanceID.getValues().size());
                for (EventedValue<?> eventedValue : ((InstanceID)((Object)iterator2)).getValues()) {
                    this.logger.trace("{} => {}", (Object)eventedValue.getName(), eventedValue.getValue());
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String generate(Event event) throws Exception {
        void var1_1;
        return XMLUtil.documentToFragmentString((Document)this.buildDOM((Event)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected Document buildDOM(Event event) throws Exception {
        void var2_2;
        void var1_1;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document d = factory.newDocumentBuilder().newDocument();
        this.generateRoot((Event)var1_1, d);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void generateRoot(Event event, Document descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Element eventElement = descriptor.createElementNS(this.getNamespace(), CONSTANTS.Event.name());
        descriptor.appendChild(eventElement);
        this.generateInstanceIDs((Event)var1_1, (Document)var2_2, (Element)var3_3);
    }

    protected void generateInstanceIDs(Event event, Document descriptor, Element rootElement) {
        for (InstanceID instanceID : event.getInstanceIDs()) {
            if (instanceID.getId() == null) continue;
            Element instanceIDElement = XMLUtil.appendNewElement((Document)descriptor, (Element)rootElement, (String)CONSTANTS.InstanceID.name());
            instanceIDElement.setAttribute(CONSTANTS.val.name(), instanceID.getId().toString());
            for (EventedValue<?> eventedValue : instanceID.getValues()) {
                this.generateEventedValue(eventedValue, descriptor, instanceIDElement);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateEventedValue(EventedValue<?> eventedValue, Document descriptor, Element parentElement) {
        String name = eventedValue.getName();
        Map.Entry<String, String>[] attributes = eventedValue.getAttributes();
        if (attributes != null && attributes.length > 0) {
            void var1_1;
            void var3_3;
            Element evElement = XMLUtil.appendNewElement((Document)descriptor, (Element)var3_3, (String)name);
            for (void attr : var1_1) {
                evElement.setAttribute((String)attr.getKey(), DOMParser.escape((String)((String)attr.getValue())));
            }
        }
    }

    class RootHandler
    extends SAXParser.Handler<Event> {
        final /* synthetic */ LastChangeParser this$0;

        /*
         * WARNING - void declaration
         */
        RootHandler(LastChangeParser this$0, Event instance, SAXParser parser) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((Object)var2_2, (SAXParser)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        RootHandler(LastChangeParser this$0, Event instance) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((Object)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String valAttr;
            void var2_2;
            void var3_3;
            super.startElement(uri, localName, (String)var3_3, attributes);
            if (CONSTANTS.InstanceID.equals((String)var2_2) && (valAttr = attributes.getValue(CONSTANTS.val.name())) != null) {
                void var1_1;
                InstanceID instanceID = new InstanceID(new UnsignedIntegerFourBytes(valAttr));
                ((Event)this.getInstance()).getInstanceIDs().add(instanceID);
                new InstanceIDHandler(this.this$0, (InstanceID)var1_1, this);
            }
        }
    }

    public static enum CONSTANTS {
        Event,
        InstanceID,
        val;


        /*
         * WARNING - void declaration
         */
        public final boolean equals(String s) {
            void var1_1;
            return this.name().equals(var1_1);
        }
    }

    class InstanceIDHandler
    extends SAXParser.Handler<InstanceID> {
        final /* synthetic */ LastChangeParser this$0;

        /*
         * WARNING - void declaration
         */
        InstanceIDHandler(LastChangeParser this$0, InstanceID instance, SAXParser.Handler<?> parent) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((Object)var2_2, (SAXParser.Handler)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            Map.Entry[] attributeMap = new Map.Entry[attributes.getLength()];
            for (int i = 0; i < attributeMap.length; ++i) {
                attributeMap[i] = new AbstractMap.SimpleEntry<String, String>(attributes.getLocalName(i), attributes.getValue(i));
            }
            try {
                void var1_1;
                void var2_2;
                EventedValue<?> esv = this.this$0.createValue((String)var2_2, (Map.Entry<String, String>[])var1_1);
                if (esv != null) {
                    ((InstanceID)this.getInstance()).getValues().add(esv);
                }
                return;
            }
            catch (Exception e) {
                void var3_6;
                this.this$0.logger.warn("Error reading event XML, ignoring value", (Throwable)var3_6);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected boolean isLastElement(String uri, String localName, String qName) {
            void var2_2;
            return CONSTANTS.InstanceID.equals((String)var2_2);
        }
    }
}

