/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.igd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceType;
import org.jupnp.model.types.UDADeviceType;
import org.jupnp.model.types.UDAServiceType;
import org.jupnp.registry.DefaultRegistryListener;
import org.jupnp.registry.Registry;
import org.jupnp.support.igd.callback.PortMappingAdd;
import org.jupnp.support.igd.callback.PortMappingDelete;
import org.jupnp.support.model.PortMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortMappingListener
extends DefaultRegistryListener {
    private final Logger logger = LoggerFactory.getLogger(PortMappingListener.class);
    public static final DeviceType IGD_DEVICE_TYPE = new UDADeviceType("InternetGatewayDevice", 1);
    public static final DeviceType CONNECTION_DEVICE_TYPE = new UDADeviceType("WANConnectionDevice", 1);
    public static final ServiceType IP_SERVICE_TYPE = new UDAServiceType("WANIPConnection", 1);
    public static final ServiceType PPP_SERVICE_TYPE = new UDAServiceType("WANPPPConnection", 1);
    protected PortMapping[] portMappings;
    protected Map<Service<?, ?>, List<PortMapping>> activePortMappings = new HashMap();

    /*
     * WARNING - void declaration
     */
    public PortMappingListener(PortMapping portMapping) {
        this(new PortMapping[]{var1_1});
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PortMappingListener(PortMapping[] portMappings) {
        void var1_1;
        this.portMappings = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void deviceAdded(Registry registry, Device device) {
        void var3_3;
        void var2_2;
        Service<?, ?> connectionService = this.discoverConnectionService(device);
        if (connectionService == null) {
            return;
        }
        this.logger.debug("Activating port mappings on: {}", connectionService);
        final ArrayList activeForService = new ArrayList();
        PortMapping[] portMappingArray = this.portMappings;
        int n = this.portMappings.length;
        for (int i = 0; i < n; ++i) {
            PortMapping pm;
            final PortMapping portMapping = pm = portMappingArray[i];
            new PortMappingAdd(this, connectionService, registry.getUpnpService().getControlPoint(), portMapping){
                final /* synthetic */ PortMappingListener this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((Service<?, ?>)var2_2, (ControlPoint)var3_3, portMapping3);
                }

                public void success(ActionInvocation invocation) {
                    this.this$0.logger.debug("Port mapping added: {}", (Object)portMapping);
                    activeForService.add(portMapping);
                }

                /*
                 * WARNING - void declaration
                 */
                public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                    void var3_3;
                    this.this$0.handleFailureMessage("Failed to add port mapping: " + String.valueOf(portMapping));
                    this.this$0.handleFailureMessage("Reason: " + (String)var3_3);
                }
            }.run();
        }
        this.activePortMappings.put((Service<?, ?>)var2_2, (List<PortMapping>)var3_3);
    }

    public synchronized void deviceRemoved(Registry registry, Device device) {
        for (Service service : device.findServices()) {
            Iterator<Map.Entry<Service<?, ?>, List<PortMapping>>> it = this.activePortMappings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Service<?, ?>, List<PortMapping>> activeEntry = it.next();
                if (!activeEntry.getKey().equals((Object)service)) continue;
                if (!activeEntry.getValue().isEmpty()) {
                    this.handleFailureMessage("Device disappeared, couldn't delete port mappings: " + activeEntry.getValue().size());
                }
                it.remove();
            }
        }
    }

    public synchronized void beforeShutdown(Registry registry) {
        for (Map.Entry<Service<?, ?>, List<PortMapping>> activeEntry : this.activePortMappings.entrySet()) {
            final Iterator<PortMapping> it = activeEntry.getValue().iterator();
            while (it.hasNext()) {
                PortMapping pm = it.next();
                this.logger.debug("Trying to delete port mapping on IGD: {}", (Object)pm);
                final PortMapping portMapping = pm;
                new PortMappingDelete(this, activeEntry.getKey(), registry.getUpnpService().getControlPoint(), portMapping){
                    final /* synthetic */ PortMappingListener this$0;
                    {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        super((Service<?, ?>)var2_2, (ControlPoint)var3_3, portMapping3);
                    }

                    public void success(ActionInvocation invocation) {
                        this.this$0.logger.debug("Port mapping deleted: {}", (Object)portMapping);
                        it.remove();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                        void var3_3;
                        this.this$0.handleFailureMessage("Failed to delete port mapping: " + String.valueOf(portMapping));
                        this.this$0.handleFailureMessage("Reason: " + (String)var3_3);
                    }
                }.run();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Service<?, ?> discoverConnectionService(Device<?, ?, ?> device) {
        void var2_2;
        if (!device.getType().equals((Object)IGD_DEVICE_TYPE)) {
            return null;
        }
        Device[] connectionDevices = device.findDevices(CONNECTION_DEVICE_TYPE);
        if (connectionDevices.length == 0) {
            this.logger.debug("IGD doesn't support '{}': {}", (Object)CONNECTION_DEVICE_TYPE, device);
            return null;
        }
        Device connectionDevice = connectionDevices[0];
        this.logger.debug("Using first discovered WAN connection device: {}", (Object)connectionDevice);
        Service ipConnectionService = connectionDevice.findService(IP_SERVICE_TYPE);
        Service pppConnectionService = connectionDevice.findService(PPP_SERVICE_TYPE);
        if (ipConnectionService == null && pppConnectionService == null) {
            void var1_1;
            this.logger.debug("IGD doesn't support IP or PPP WAN connection service: {}", (Object)var1_1);
        }
        if (ipConnectionService != null) {
            void var3_3;
            return var3_3;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void handleFailureMessage(String s) {
        void var1_1;
        this.logger.warn((String)var1_1);
    }
}

