/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.contentdirectory.callback;

import org.jupnp.controlpoint.ActionCallback;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.support.contentdirectory.DIDLParser;
import org.jupnp.support.model.BrowseFlag;
import org.jupnp.support.model.BrowseResult;
import org.jupnp.support.model.DIDLContent;
import org.jupnp.support.model.SortCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Browse
extends ActionCallback {
    private static final int DEFAULT_MAX_RESULT = 999;
    public static final String CAPS_WILDCARD = "*";
    private final Logger logger = LoggerFactory.getLogger(Browse.class);

    /*
     * WARNING - void declaration
     */
    protected Browse(Service<?, ?> service, String containerId, BrowseFlag flag) {
        this((Service<?, ?>)var1_1, (String)var2_2, (BrowseFlag)var3_3, CAPS_WILDCARD, 0L, null, new SortCriterion[0]);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Browse(Service<?, ?> service, String objectID, BrowseFlag flag, String filter, long firstResult, Long maxResults, SortCriterion ... orderBy) {
        super(new ActionInvocation(var1_1.getAction("Browse")));
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.debug("Creating browse action for object ID: {}", (Object)objectID);
        this.getActionInvocation().setInput("ObjectID", (Object)var2_2);
        this.getActionInvocation().setInput("BrowseFlag", (Object)var3_3.toString());
        this.getActionInvocation().setInput("Filter", (Object)filter);
        this.getActionInvocation().setInput("StartingIndex", (Object)new UnsignedIntegerFourBytes(firstResult));
        this.getActionInvocation().setInput("RequestedCount", (Object)new UnsignedIntegerFourBytes(maxResults == null ? this.getDefaultMaxResults() : maxResults.longValue()));
        this.getActionInvocation().setInput("SortCriteria", (Object)SortCriterion.toString(orderBy));
    }

    public void run() {
        this.updateStatus(Status.LOADING);
        super.run();
    }

    /*
     * WARNING - void declaration
     */
    public void success(ActionInvocation invocation) {
        void var1_1;
        this.logger.debug("Successful browse action, reading output argument values");
        BrowseResult result = new BrowseResult(invocation.getOutput("Result").getValue().toString(), (UnsignedIntegerFourBytes)invocation.getOutput("NumberReturned").getValue(), (UnsignedIntegerFourBytes)invocation.getOutput("TotalMatches").getValue(), (UnsignedIntegerFourBytes)invocation.getOutput("UpdateID").getValue());
        boolean bl = this.receivedRaw(invocation, result);
        if (bl && result.getCountLong() > 0L && !result.getResult().isEmpty()) {
            try {
                void var2_2;
                DIDLParser dIDLParser = new DIDLParser();
                DIDLContent didl = dIDLParser.parse(result.getResult());
                this.received(invocation, (DIDLContent)var2_2);
                this.updateStatus(Status.OK);
                return;
            }
            catch (Exception e) {
                void var3_5;
                invocation.setFailure(new ActionException(ErrorCode.ACTION_FAILED, "Can't parse DIDL XML response: " + String.valueOf(e), (Throwable)var3_5));
                this.failure(invocation, null);
                return;
            }
        }
        this.received((ActionInvocation<?>)var1_1, new DIDLContent());
        this.updateStatus(Status.NO_CONTENT);
    }

    public long getDefaultMaxResults() {
        return 999L;
    }

    public boolean receivedRaw(ActionInvocation<?> actionInvocation, BrowseResult browseResult) {
        return true;
    }

    public abstract void received(ActionInvocation<?> var1, DIDLContent var2);

    public abstract void updateStatus(Status var1);

    public static enum Status {
        NO_CONTENT("No Content"),
        LOADING("Loading..."),
        OK("OK");

        private final String defaultMessage;

        /*
         * WARNING - void declaration
         */
        private Status(String defaultMessage) {
            void var3_3;
            this.defaultMessage = var3_3;
        }

        public final String getDefaultMessage() {
            return this.defaultMessage;
        }
    }
}

