/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.contentdirectory;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jupnp.model.XMLUtil;
import org.jupnp.model.types.Datatype;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.support.model.DIDLAttribute;
import org.jupnp.support.model.DIDLContent;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.DescMeta;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.PersonWithRole;
import org.jupnp.support.model.ProtocolInfo;
import org.jupnp.support.model.Res;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.WriteStatus;
import org.jupnp.support.model.container.Container;
import org.jupnp.support.model.item.Item;
import org.jupnp.util.io.IO;
import org.jupnp.xml.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DIDLParser
extends SAXParser {
    private final Logger logger = LoggerFactory.getLogger(DIDLParser.class);
    public static final String UNKNOWN_TITLE = "Unknown Title";

    /*
     * WARNING - void declaration
     */
    public DIDLContent parseResource(String resource) throws Exception {
        DIDLContent dIDLContent;
        block5: {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            try {
                dIDLContent = this.parse(IO.readLines((InputStream)is));
                if (is == null) break block5;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return dIDLContent;
    }

    /*
     * WARNING - void declaration
     */
    public DIDLContent parse(String xml) throws Exception {
        void var2_2;
        void var1_1;
        if (xml == null || xml.isEmpty()) {
            throw new RuntimeException("Null or empty XML");
        }
        DIDLContent content = new DIDLContent();
        this.createRootHandler(content, this);
        this.logger.debug("Parsing DIDL XML content");
        this.parse(new InputSource(new StringReader((String)var1_1)));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected RootHandler createRootHandler(DIDLContent instance, SAXParser parser) {
        void var2_2;
        void var1_1;
        return new RootHandler(this, (DIDLContent)var1_1, (SAXParser)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected ContainerHandler createContainerHandler(Container instance, SAXParser.Handler<?> parent) {
        void var2_2;
        void var1_1;
        return new ContainerHandler((Container)var1_1, (SAXParser.Handler<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected ItemHandler createItemHandler(Item instance, SAXParser.Handler<?> parent) {
        void var2_2;
        void var1_1;
        return new ItemHandler((Item)var1_1, (SAXParser.Handler<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected ResHandler createResHandler(Res instance, SAXParser.Handler<?> parent) {
        void var2_2;
        void var1_1;
        return new ResHandler((Res)var1_1, (SAXParser.Handler<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected DescMetaHandler createDescMetaHandler(DescMeta<?> instance, SAXParser.Handler<?> parent) {
        void var2_2;
        void var1_1;
        return new DescMetaHandler((DescMeta)var1_1, (SAXParser.Handler<?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected Container createContainer(Attributes attributes) {
        void var2_2;
        Container container = new Container();
        container.setId(attributes.getValue("id"));
        container.setParentID(attributes.getValue("parentID"));
        if (attributes.getValue("childCount") != null) {
            container.setChildCount(Integer.valueOf(attributes.getValue("childCount")));
        }
        try {
            void var1_1;
            Boolean value = (Boolean)Datatype.Builtin.BOOLEAN.getDatatype().valueOf(attributes.getValue("restricted"));
            if (value != null) {
                container.setRestricted(value);
            }
            if ((value = (Boolean)Datatype.Builtin.BOOLEAN.getDatatype().valueOf(var1_1.getValue("searchable"))) != null) {
                void var3_3;
                container.setSearchable(var3_3.booleanValue());
            }
        }
        catch (Exception exception) {}
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected Item createItem(Attributes attributes) {
        void var2_2;
        Item item = new Item();
        item.setId(attributes.getValue("id"));
        item.setParentID(attributes.getValue("parentID"));
        try {
            Boolean value = (Boolean)Datatype.Builtin.BOOLEAN.getDatatype().valueOf(attributes.getValue("restricted"));
            if (value != null) {
                void var3_3;
                item.setRestricted(var3_3.booleanValue());
            }
        }
        catch (Exception exception) {}
        if (attributes.getValue("refID") != null) {
            void var1_1;
            item.setRefID(var1_1.getValue("refID"));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected Res createResource(Attributes attributes) {
        void var2_3;
        void var1_1;
        Res res = new Res();
        if (attributes.getValue("importUri") != null) {
            res.setImportUri(URI.create(attributes.getValue("importUri")));
        }
        try {
            res.setProtocolInfo(new ProtocolInfo(attributes.getValue("protocolInfo")));
        }
        catch (InvalidValueException e) {
            void var1_2;
            this.logger.warn("In DIDL content, invalid resource protocol info", (Throwable)var1_2);
            return null;
        }
        if (var1_1.getValue("size") != null) {
            res.setSize(this.toLongOrNull(var1_1.getValue("size")));
        }
        if (var1_1.getValue("duration") != null) {
            res.setDuration(var1_1.getValue("duration"));
        }
        if (var1_1.getValue("bitrate") != null) {
            res.setBitrate(this.toLongOrNull(var1_1.getValue("bitrate")));
        }
        if (var1_1.getValue("sampleFrequency") != null) {
            res.setSampleFrequency(this.toLongOrNull(var1_1.getValue("sampleFrequency")));
        }
        if (var1_1.getValue("bitsPerSample") != null) {
            res.setBitsPerSample(this.toLongOrNull(var1_1.getValue("bitsPerSample")));
        }
        if (var1_1.getValue("nrAudioChannels") != null) {
            res.setNrAudioChannels(this.toLongOrNull(var1_1.getValue("nrAudioChannels")));
        }
        if (var1_1.getValue("colorDepth") != null) {
            res.setColorDepth(this.toLongOrNull(var1_1.getValue("colorDepth")));
        }
        if (var1_1.getValue("protection") != null) {
            res.setProtection(var1_1.getValue("protection"));
        }
        if (var1_1.getValue("resolution") != null) {
            res.setResolution(var1_1.getValue("resolution"));
        }
        return var2_3;
    }

    private Long toLongOrNull(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected DescMeta<?> createDescMeta(Attributes attributes) {
        void var2_2;
        DescMeta desc = new DescMeta();
        desc.setId(attributes.getValue("id"));
        if (attributes.getValue("type") != null) {
            desc.setType(attributes.getValue("type"));
        }
        if (attributes.getValue("nameSpace") != null) {
            void var1_1;
            desc.setNameSpace(URI.create(var1_1.getValue("nameSpace")));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String generate(DIDLContent content) throws Exception {
        void var1_1;
        return this.generate((DIDLContent)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public String generate(DIDLContent content, boolean nestedItems) throws Exception {
        void var2_2;
        void var1_1;
        DIDLParser dIDLParser = this;
        return dIDLParser.documentToString(dIDLParser.buildDOM((DIDLContent)var1_1, (boolean)var2_2), true);
    }

    /*
     * WARNING - void declaration
     */
    protected String documentToString(Document document, boolean omitProlog) throws Exception {
        void var2_3;
        void var1_1;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        if (omitProlog) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        StringWriter out = new StringWriter();
        ((Transformer)((Object)transformerFactory)).transform(new DOMSource((Node)var1_1), new StreamResult(out));
        return var2_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected Document buildDOM(DIDLContent content, boolean nestedItems) throws Exception {
        void var3_3;
        void var2_2;
        void var1_1;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document d = factory.newDocumentBuilder().newDocument();
        this.generateRoot((DIDLContent)var1_1, d, (boolean)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void generateRoot(DIDLContent content, Document descriptor, boolean nestedItems) {
        void var1_1;
        Element rootElement = descriptor.createElementNS("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/", "DIDL-Lite");
        descriptor.appendChild(rootElement);
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:upnp", "urn:schemas-upnp-org:metadata-1-0/upnp/");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dc", "http://purl.org/dc/elements/1.1/");
        rootElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sec", "http://www.sec.co.kr/");
        for (Container container : content.getContainers()) {
            if (container == null) continue;
            this.generateContainer(container, descriptor, rootElement, nestedItems);
        }
        for (Item item : content.getItems()) {
            if (item == null) continue;
            this.generateItem(item, descriptor, rootElement);
        }
        for (DescMeta descMeta : var1_1.getDescMetadata()) {
            if (descMeta == null) continue;
            this.generateDescMetadata(descMeta, descriptor, rootElement);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateContainer(Container container, Document descriptor, Element parent, boolean nestedItems) {
        void var1_1;
        if (container.getClazz() == null) {
            throw new RuntimeException("Missing 'upnp:class' element for container: " + container.getId());
        }
        Element containerElement = XMLUtil.appendNewElement((Document)descriptor, (Element)parent, (String)"container");
        if (container.getId() == null) {
            throw new NullPointerException("Missing id on container: " + String.valueOf(container));
        }
        containerElement.setAttribute("id", container.getId());
        if (container.getParentID() == null) {
            throw new NullPointerException("Missing parent id on container: " + String.valueOf(container));
        }
        containerElement.setAttribute("parentID", container.getParentID());
        if (container.getChildCount() != null) {
            containerElement.setAttribute("childCount", Integer.toString(container.getChildCount()));
        }
        containerElement.setAttribute("restricted", this.booleanToInt(container.isRestricted()));
        containerElement.setAttribute("searchable", this.booleanToInt(container.isSearchable()));
        String title = container.getTitle();
        if (title == null) {
            this.logger.warn("Missing 'dc:title' element for container: {}", (Object)container.getId());
            title = UNKNOWN_TITLE;
        }
        XMLUtil.appendNewElementIfNotNull((Document)descriptor, (Element)containerElement, (String)"dc:title", (Object)title, (String)"http://purl.org/dc/elements/1.1/");
        XMLUtil.appendNewElementIfNotNull((Document)descriptor, (Element)containerElement, (String)"dc:creator", (Object)container.getCreator(), (String)"http://purl.org/dc/elements/1.1/");
        XMLUtil.appendNewElementIfNotNull((Document)descriptor, (Element)containerElement, (String)"upnp:writeStatus", (Object)((Object)container.getWriteStatus()), (String)"urn:schemas-upnp-org:metadata-1-0/upnp/");
        this.appendClass(descriptor, containerElement, container.getClazz(), "upnp:class", false);
        for (DIDLObject.Class clazz : container.getSearchClasses()) {
            this.appendClass(descriptor, containerElement, clazz, "upnp:searchClass", true);
        }
        for (DIDLObject.Class clazz : container.getCreateClasses()) {
            this.appendClass(descriptor, containerElement, clazz, "upnp:createClass", true);
        }
        this.appendProperties(descriptor, containerElement, container, "upnp", DIDLObject.Property.UPNP.NAMESPACE.class, "urn:schemas-upnp-org:metadata-1-0/upnp/");
        this.appendProperties(descriptor, containerElement, container, "dc", DIDLObject.Property.DC.NAMESPACE.class, "http://purl.org/dc/elements/1.1/");
        if (nestedItems) {
            for (Item item : container.getItems()) {
                if (item == null) continue;
                this.generateItem(item, descriptor, containerElement);
            }
        }
        for (Res res : container.getResources()) {
            if (res == null) continue;
            this.generateResource(res, descriptor, containerElement);
        }
        for (DescMeta descMeta : var1_1.getDescMetadata()) {
            if (descMeta == null) continue;
            this.generateDescMetadata(descMeta, descriptor, containerElement);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateItem(Item item, Document descriptor, Element parent) {
        void var1_1;
        if (item.getClazz() == null) {
            throw new RuntimeException("Missing 'upnp:class' element for item: " + item.getId());
        }
        Element itemElement = XMLUtil.appendNewElement((Document)descriptor, (Element)parent, (String)"item");
        if (item.getId() == null) {
            throw new NullPointerException("Missing id on item: " + String.valueOf(item));
        }
        itemElement.setAttribute("id", item.getId());
        if (item.getParentID() == null) {
            throw new NullPointerException("Missing parent id on item: " + String.valueOf(item));
        }
        itemElement.setAttribute("parentID", item.getParentID());
        if (item.getRefID() != null) {
            itemElement.setAttribute("refID", item.getRefID());
        }
        itemElement.setAttribute("restricted", this.booleanToInt(item.isRestricted()));
        String title = item.getTitle();
        if (title == null) {
            this.logger.warn("Missing 'dc:title' element for item: {}", (Object)item.getId());
            title = UNKNOWN_TITLE;
        }
        XMLUtil.appendNewElementIfNotNull((Document)descriptor, (Element)itemElement, (String)"dc:title", (Object)title, (String)"http://purl.org/dc/elements/1.1/");
        XMLUtil.appendNewElementIfNotNull((Document)descriptor, (Element)itemElement, (String)"dc:creator", (Object)item.getCreator(), (String)"http://purl.org/dc/elements/1.1/");
        XMLUtil.appendNewElementIfNotNull((Document)descriptor, (Element)itemElement, (String)"upnp:writeStatus", (Object)((Object)item.getWriteStatus()), (String)"urn:schemas-upnp-org:metadata-1-0/upnp/");
        this.appendClass(descriptor, itemElement, item.getClazz(), "upnp:class", false);
        this.appendProperties(descriptor, itemElement, item, "upnp", DIDLObject.Property.UPNP.NAMESPACE.class, "urn:schemas-upnp-org:metadata-1-0/upnp/");
        this.appendProperties(descriptor, itemElement, item, "dc", DIDLObject.Property.DC.NAMESPACE.class, "http://purl.org/dc/elements/1.1/");
        this.appendProperties(descriptor, itemElement, item, "sec", DIDLObject.Property.SEC.NAMESPACE.class, "http://www.sec.co.kr/");
        for (Res res : item.getResources()) {
            if (res == null) continue;
            this.generateResource(res, descriptor, itemElement);
        }
        for (DescMeta descMeta : var1_1.getDescMetadata()) {
            if (descMeta == null) continue;
            this.generateDescMetadata(descMeta, descriptor, itemElement);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateResource(Res resource, Document descriptor, Element parent) {
        void var3_3;
        if (resource.getValue() == null) {
            throw new RuntimeException("Missing resource URI value" + String.valueOf(resource));
        }
        if (resource.getProtocolInfo() == null) {
            throw new RuntimeException("Missing resource protocol info: " + String.valueOf(resource));
        }
        Element resourceElement = XMLUtil.appendNewElement((Document)descriptor, (Element)var3_3, (String)"res", (Object)resource.getValue());
        resourceElement.setAttribute("protocolInfo", resource.getProtocolInfo().toString());
        if (resource.getImportUri() != null) {
            resourceElement.setAttribute("importUri", resource.getImportUri().toString());
        }
        if (resource.getSize() != null) {
            resourceElement.setAttribute("size", resource.getSize().toString());
        }
        if (resource.getDuration() != null) {
            resourceElement.setAttribute("duration", resource.getDuration());
        }
        if (resource.getBitrate() != null) {
            resourceElement.setAttribute("bitrate", resource.getBitrate().toString());
        }
        if (resource.getSampleFrequency() != null) {
            resourceElement.setAttribute("sampleFrequency", resource.getSampleFrequency().toString());
        }
        if (resource.getBitsPerSample() != null) {
            resourceElement.setAttribute("bitsPerSample", resource.getBitsPerSample().toString());
        }
        if (resource.getNrAudioChannels() != null) {
            resourceElement.setAttribute("nrAudioChannels", resource.getNrAudioChannels().toString());
        }
        if (resource.getColorDepth() != null) {
            resourceElement.setAttribute("colorDepth", resource.getColorDepth().toString());
        }
        if (resource.getProtection() != null) {
            resourceElement.setAttribute("protection", resource.getProtection());
        }
        if (resource.getResolution() != null) {
            void var1_1;
            void var2_2;
            var2_2.setAttribute("resolution", var1_1.getResolution());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void generateDescMetadata(DescMeta<?> descMeta, Document descriptor, Element parent) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (descMeta.getId() == null) {
            throw new RuntimeException("Missing id of description metadata: " + String.valueOf(descMeta));
        }
        if (descMeta.getNameSpace() == null) {
            throw new RuntimeException("Missing namespace of description metadata: " + String.valueOf(descMeta));
        }
        Element descElement = XMLUtil.appendNewElement((Document)descriptor, (Element)var3_3, (String)"desc");
        descElement.setAttribute("id", descMeta.getId());
        descElement.setAttribute("nameSpace", descMeta.getNameSpace().toString());
        if (descMeta.getType() != null) {
            descElement.setAttribute("type", descMeta.getType());
        }
        this.populateDescMetadata((Element)var2_2, (DescMeta<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void populateDescMetadata(Element descElement, DescMeta<?> descMeta) {
        void var2_2;
        if (((DescMeta)descMeta).getMetadata() instanceof Document) {
            descMeta = (Document)((DescMeta)descMeta).getMetadata();
            NodeList nl = descMeta.getDocumentElement().getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (n.getNodeType() != 1) continue;
                Node clone = descElement.getOwnerDocument().importNode(n, true);
                descElement.appendChild(clone);
            }
            return;
        }
        this.logger.warn("Unknown desc metadata content, please override populateDescMetadata(): {}", var2_2.getMetadata());
    }

    protected void appendProperties(Document descriptor, Element parent, DIDLObject object, String prefix, Class<? extends DIDLObject.Property.NAMESPACE> namespace, String namespaceURI) {
        for (DIDLObject.Property property : object.getPropertiesByNamespace(namespace)) {
            Element el = descriptor.createElementNS(namespaceURI, prefix + ":" + property.getDescriptorName());
            parent.appendChild(el);
            property.setOnElement(el);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void appendClass(Document descriptor, Element parent, DIDLObject.Class clazz, String element, boolean appendDerivation) {
        void var2_2;
        Element classElement = XMLUtil.appendNewElementIfNotNull((Document)descriptor, (Element)var2_2, (String)element, (Object)clazz.getValue(), (String)"urn:schemas-upnp-org:metadata-1-0/upnp/");
        if (clazz.getFriendlyName() != null && !clazz.getFriendlyName().isEmpty()) {
            classElement.setAttribute("name", clazz.getFriendlyName());
        }
        if (appendDerivation) {
            void var3_3;
            void var1_1;
            var1_1.setAttribute("includeDerived", Boolean.toString(var3_3.isIncludeDerived()));
        }
    }

    protected String booleanToInt(boolean b) {
        if (b) {
            return "1";
        }
        return "0";
    }

    /*
     * WARNING - void declaration
     */
    public void debugXML(String s) {
        if (this.logger.isDebugEnabled()) {
            void var1_1;
            this.logger.debug("-------------------------------------------------------------------------------------");
            this.logger.debug("{}", (Object)var1_1);
            this.logger.debug("-------------------------------------------------------------------------------------");
        }
    }

    public class RootHandler
    extends SAXParser.Handler<DIDLContent> {
        final /* synthetic */ DIDLParser this$0;

        /*
         * WARNING - void declaration
         */
        RootHandler(DIDLParser this$0, DIDLContent instance, SAXParser parser) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((Object)var2_2, (SAXParser)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            void var2_2;
            void var3_3;
            super.startElement(uri, localName, (String)var3_3, attributes);
            if (!"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri)) {
                return;
            }
            if (localName.equals("container")) {
                Container container = this.this$0.createContainer(attributes);
                ((DIDLContent)this.getInstance()).addContainer(container);
                this.this$0.createContainerHandler(container, this);
                return;
            }
            if (localName.equals("item")) {
                Item item = this.this$0.createItem(attributes);
                ((DIDLContent)this.getInstance()).addItem(item);
                this.this$0.createItemHandler(item, this);
                return;
            }
            if (var2_2.equals("desc")) {
                void var1_1;
                DescMeta<?> desc = this.this$0.createDescMeta(attributes);
                ((DIDLContent)this.getInstance()).addDescMetadata(desc);
                this.this$0.createDescMetaHandler((DescMeta<?>)var1_1, this);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected boolean isLastElement(String uri, String localName, String qName) {
            void var2_2;
            void var1_1;
            if ("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(var1_1) && "DIDL-Lite".equals(var2_2)) {
                ((DIDLContent)this.getInstance()).replaceGenericContainerAndItems();
                return true;
            }
            return false;
        }
    }

    public class ContainerHandler
    extends DIDLObjectHandler<Container> {
        /*
         * WARNING - void declaration
         */
        public ContainerHandler(Container instance, SAXParser.Handler<?> parent) {
            void var3_3;
            void var2_2;
            void var1_1;
            super((DIDLParser)var1_1, (DIDLObject)var2_2, (SAXParser.Handler)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Res res;
            void var2_2;
            void var3_3;
            super.startElement(uri, localName, (String)var3_3, attributes);
            if (!"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri)) {
                return;
            }
            if (localName.equals("item")) {
                Item item = DIDLParser.this.createItem(attributes);
                ((Container)this.getInstance()).addItem(item);
                DIDLParser.this.createItemHandler(item, this);
                return;
            }
            if (localName.equals("desc")) {
                DescMeta<?> desc = DIDLParser.this.createDescMeta(attributes);
                ((Container)this.getInstance()).addDescMetadata(desc);
                DIDLParser.this.createDescMetaHandler(desc, this);
                return;
            }
            if (var2_2.equals("res") && (res = DIDLParser.this.createResource(attributes)) != null) {
                void var1_1;
                ((Container)this.getInstance()).addResource(res);
                DIDLParser.this.createResHandler((Res)var1_1, this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            void var1_1;
            void var3_3;
            super.endElement(uri, localName, (String)var3_3);
            if ("urn:schemas-upnp-org:metadata-1-0/upnp/".equals(var1_1)) {
                void var2_2;
                if ("searchClass".equals(localName)) {
                    ((Container)this.getInstance()).getSearchClasses().add(new DIDLObject.Class(this.getCharacters(), this.getAttributes().getValue("name"), "true".equals(this.getAttributes().getValue("includeDerived"))));
                    return;
                }
                if ("createClass".equals(var2_2)) {
                    ((Container)this.getInstance()).getCreateClasses().add(new DIDLObject.Class(this.getCharacters(), this.getAttributes().getValue("name"), "true".equals(this.getAttributes().getValue("includeDerived"))));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        protected boolean isLastElement(String uri, String localName, String qName) {
            void var2_2;
            void var1_1;
            if ("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(var1_1) && "container".equals(var2_2)) {
                if (((Container)this.getInstance()).getTitle() == null) {
                    DIDLParser.this.logger.warn("In DIDL content, missing 'dc:title' element for container: {}", (Object)((Container)this.getInstance()).getId());
                }
                if (((Container)this.getInstance()).getClazz() == null) {
                    DIDLParser.this.logger.warn("In DIDL content, missing 'upnp:class' element for container: {}", (Object)((Container)this.getInstance()).getId());
                }
                return true;
            }
            return false;
        }
    }

    public class ItemHandler
    extends DIDLObjectHandler<Item> {
        /*
         * WARNING - void declaration
         */
        public ItemHandler(Item instance, SAXParser.Handler<?> parent) {
            void var3_3;
            void var2_2;
            void var1_1;
            super((DIDLParser)var1_1, (DIDLObject)var2_2, (SAXParser.Handler)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            void var2_2;
            void var3_3;
            super.startElement(uri, localName, (String)var3_3, attributes);
            if (!"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri)) {
                return;
            }
            if (localName.equals("res")) {
                Res res = DIDLParser.this.createResource(attributes);
                if (res != null) {
                    ((Item)this.getInstance()).addResource(res);
                    DIDLParser.this.createResHandler(res, this);
                }
                return;
            }
            if (var2_2.equals("desc")) {
                void var1_1;
                DescMeta<?> desc = DIDLParser.this.createDescMeta(attributes);
                ((Item)this.getInstance()).addDescMetadata(desc);
                DIDLParser.this.createDescMetaHandler((DescMeta<?>)var1_1, this);
            }
        }

        /*
         * WARNING - void declaration
         */
        protected boolean isLastElement(String uri, String localName, String qName) {
            void var2_2;
            void var1_1;
            if ("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(var1_1) && "item".equals(var2_2)) {
                if (((Item)this.getInstance()).getTitle() == null) {
                    DIDLParser.this.logger.warn("In DIDL content, missing 'dc:title' element for item: {}", (Object)((Item)this.getInstance()).getId());
                }
                if (((Item)this.getInstance()).getClazz() == null) {
                    DIDLParser.this.logger.warn("In DIDL content, missing 'upnp:class' element for item: {}", (Object)((Item)this.getInstance()).getId());
                }
                return true;
            }
            return false;
        }
    }

    protected static class ResHandler
    extends SAXParser.Handler<Res> {
        /*
         * WARNING - void declaration
         */
        public ResHandler(Res instance, SAXParser.Handler<?> parent) {
            super((Object)var1_1, (SAXParser.Handler)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void endElement(String uri, String localName, String qName) throws SAXException {
            void var3_3;
            void var2_2;
            void var1_1;
            super.endElement((String)var1_1, (String)var2_2, (String)var3_3);
            ((Res)this.getInstance()).setValue(this.getCharacters());
        }

        /*
         * WARNING - void declaration
         */
        protected boolean isLastElement(String uri, String localName, String qName) {
            void var2_2;
            void var1_1;
            return "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(var1_1) && "res".equals(var2_2);
        }
    }

    public static class DescMetaHandler
    extends SAXParser.Handler<DescMeta> {
        protected Element current;

        /*
         * WARNING - void declaration
         */
        public DescMetaHandler(DescMeta instance, SAXParser.Handler<?> parent) {
            super((Object)instance, (SAXParser.Handler)var2_2);
            void var1_1;
            void var2_2;
            void v0 = var1_1;
            v0.setMetadata(v0.createMetadataDocument());
            this.current = ((Document)((DescMeta)this.getInstance()).getMetadata()).getDocumentElement();
        }

        public DescMeta<Document> getInstance() {
            return (DescMeta)super.getInstance();
        }

        /*
         * WARNING - void declaration
         */
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            void var1_1;
            void var3_4;
            super.startElement(uri, localName, qName, attributes);
            Element newEl = ((Document)((DescMeta)this.getInstance()).getMetadata()).createElementNS(uri, (String)var3_4);
            for (int i = 0; i < attributes.getLength(); ++i) {
                newEl.setAttributeNS(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
            }
            this.current.appendChild(newEl);
            this.current = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void endElement(String uri, String localName, String qName) throws SAXException {
            void var3_3;
            void var2_2;
            void var1_1;
            super.endElement(uri, localName, qName);
            if (this.isLastElement((String)var1_1, (String)var2_2, (String)var3_3)) {
                return;
            }
            if (!this.getCharacters().isEmpty() && !this.getCharacters().matches("[\\t\\n\\x0B\\f\\r\\s]+")) {
                this.current.appendChild(((Document)((DescMeta)this.getInstance()).getMetadata()).createTextNode(this.getCharacters()));
            }
            this.current = (Element)this.current.getParentNode();
            this.characters = new StringBuilder();
            this.attributes = null;
        }

        /*
         * WARNING - void declaration
         */
        protected boolean isLastElement(String uri, String localName, String qName) {
            void var2_2;
            void var1_1;
            return "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(var1_1) && "desc".equals(var2_2);
        }
    }

    public abstract class DIDLObjectHandler<I extends DIDLObject>
    extends SAXParser.Handler<I> {
        final /* synthetic */ DIDLParser this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected DIDLObjectHandler(I instance, SAXParser.Handler<?> parent) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((Object)var2_2, (SAXParser.Handler)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if ("http://purl.org/dc/elements/1.1/".equals(uri)) {
                if ("title".equals(localName)) {
                    ((DIDLObject)this.getInstance()).setTitle(this.getCharacters());
                    return;
                }
                if ("creator".equals(localName)) {
                    ((DIDLObject)this.getInstance()).setCreator(this.getCharacters());
                    return;
                }
                if ("description".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.DESCRIPTION(this.getCharacters()));
                    return;
                }
                if ("publisher".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.PUBLISHER(new Person(this.getCharacters())));
                    return;
                }
                if ("contributor".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.CONTRIBUTOR(new Person(this.getCharacters())));
                    return;
                }
                if ("date".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.DATE(this.getCharacters()));
                    return;
                }
                if ("language".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.LANGUAGE(this.getCharacters()));
                    return;
                }
                if ("rights".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.RIGHTS(this.getCharacters()));
                    return;
                }
                if ("relation".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.DC.RELATION(URI.create(this.getCharacters())));
                    return;
                }
            } else if ("urn:schemas-upnp-org:metadata-1-0/upnp/".equals(uri)) {
                void var2_2;
                if ("writeStatus".equals(localName)) {
                    try {
                        ((DIDLObject)this.getInstance()).setWriteStatus(WriteStatus.valueOf(this.getCharacters()));
                        return;
                    }
                    catch (Exception exception) {
                        this.this$0.logger.info("Ignoring invalid writeStatus value: {}", (Object)this.getCharacters());
                        return;
                    }
                }
                if ("class".equals(localName)) {
                    ((DIDLObject)this.getInstance()).setClazz(new DIDLObject.Class(this.getCharacters(), this.getAttributes().getValue("name")));
                    return;
                }
                if ("artist".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ARTIST(new PersonWithRole(this.getCharacters(), this.getAttributes().getValue("role"))));
                    return;
                }
                if ("actor".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ACTOR(new PersonWithRole(this.getCharacters(), this.getAttributes().getValue("role"))));
                    return;
                }
                if ("author".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.AUTHOR(new PersonWithRole(this.getCharacters(), this.getAttributes().getValue("role"))));
                    return;
                }
                if ("producer".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.PRODUCER(new Person(this.getCharacters())));
                    return;
                }
                if ("director".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.DIRECTOR(new Person(this.getCharacters())));
                    return;
                }
                if ("longDescription".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.LONG_DESCRIPTION(this.getCharacters()));
                    return;
                }
                if ("storageUsed".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.STORAGE_USED(Long.valueOf(this.getCharacters())));
                    return;
                }
                if ("storageTotal".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.STORAGE_TOTAL(Long.valueOf(this.getCharacters())));
                    return;
                }
                if ("storageFree".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.STORAGE_FREE(Long.valueOf(this.getCharacters())));
                    return;
                }
                if ("storageMaxPartition".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.STORAGE_MAX_PARTITION(Long.valueOf(this.getCharacters())));
                    return;
                }
                if ("storageMedium".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.STORAGE_MEDIUM(StorageMedium.valueOrVendorSpecificOf(this.getCharacters())));
                    return;
                }
                if ("genre".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.GENRE(this.getCharacters()));
                    return;
                }
                if ("album".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ALBUM(this.getCharacters()));
                    return;
                }
                if ("playlist".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.PLAYLIST(this.getCharacters()));
                    return;
                }
                if ("region".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.REGION(this.getCharacters()));
                    return;
                }
                if ("rating".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.RATING(this.getCharacters()));
                    return;
                }
                if ("toc".equals(localName)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.TOC(this.getCharacters()));
                    return;
                }
                if ("albumArtURI".equals(localName)) {
                    void var1_1;
                    DIDLObject.Property.UPNP.ALBUM_ART_URI albumArtURI = new DIDLObject.Property.UPNP.ALBUM_ART_URI(URI.create(this.getCharacters()));
                    Attributes albumArtURIAttributes = this.getAttributes();
                    for (int i = 0; i < albumArtURIAttributes.getLength(); ++i) {
                        if (!"profileID".equals(albumArtURIAttributes.getLocalName(i))) continue;
                        albumArtURI.addAttribute(new DIDLObject.Property.DLNA.PROFILE_ID(new DIDLAttribute("urn:schemas-dlna-org:metadata-1-0/", "dlna", albumArtURIAttributes.getValue(i))));
                    }
                    ((DIDLObject)this.getInstance()).addProperty((DIDLObject.Property)var1_1);
                    return;
                }
                if ("artistDiscographyURI".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ARTIST_DISCO_URI(URI.create(this.getCharacters())));
                    return;
                }
                if ("lyricsURI".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.LYRICS_URI(URI.create(this.getCharacters())));
                    return;
                }
                if ("icon".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ICON(URI.create(this.getCharacters())));
                    return;
                }
                if ("radioCallSign".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.RADIO_CALL_SIGN(this.getCharacters()));
                    return;
                }
                if ("radioStationID".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.RADIO_STATION_ID(this.getCharacters()));
                    return;
                }
                if ("radioBand".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.RADIO_BAND(this.getCharacters()));
                    return;
                }
                if ("channelNr".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.CHANNEL_NR(Integer.valueOf(this.getCharacters())));
                    return;
                }
                if ("channelName".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.CHANNEL_NAME(this.getCharacters()));
                    return;
                }
                if ("scheduledStartTime".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.SCHEDULED_START_TIME(this.getCharacters()));
                    return;
                }
                if ("scheduledEndTime".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.SCHEDULED_END_TIME(this.getCharacters()));
                    return;
                }
                if ("DVDRegionCode".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.DVD_REGION_CODE(Integer.valueOf(this.getCharacters())));
                    return;
                }
                if ("originalTrackNumber".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.ORIGINAL_TRACK_NUMBER(Integer.valueOf(this.getCharacters().split("/")[0])));
                    return;
                }
                if ("userAnnotation".equals(var2_2)) {
                    ((DIDLObject)this.getInstance()).addProperty(new DIDLObject.Property.UPNP.USER_ANNOTATION(this.getCharacters()));
                }
            }
        }
    }
}

