/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.connectionmanager;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jupnp.binding.annotations.UpnpAction;
import org.jupnp.binding.annotations.UpnpInputArgument;
import org.jupnp.binding.annotations.UpnpOutputArgument;
import org.jupnp.binding.annotations.UpnpService;
import org.jupnp.binding.annotations.UpnpServiceId;
import org.jupnp.binding.annotations.UpnpServiceType;
import org.jupnp.binding.annotations.UpnpStateVariable;
import org.jupnp.binding.annotations.UpnpStateVariables;
import org.jupnp.internal.compat.java.beans.PropertyChangeSupport;
import org.jupnp.model.ServiceReference;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.model.types.csv.CSV;
import org.jupnp.model.types.csv.CSVUnsignedIntegerFourBytes;
import org.jupnp.support.connectionmanager.ConnectionManagerErrorCode;
import org.jupnp.support.connectionmanager.ConnectionManagerException;
import org.jupnp.support.model.ConnectionInfo;
import org.jupnp.support.model.ProtocolInfo;
import org.jupnp.support.model.ProtocolInfos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UpnpService(serviceId=@UpnpServiceId(value="ConnectionManager"), serviceType=@UpnpServiceType(value="ConnectionManager", version=1), stringConvertibleTypes={ProtocolInfo.class, ProtocolInfos.class, ServiceReference.class})
@UpnpStateVariables(value={@UpnpStateVariable(name="SourceProtocolInfo", datatype="string"), @UpnpStateVariable(name="SinkProtocolInfo", datatype="string"), @UpnpStateVariable(name="CurrentConnectionIDs", datatype="string"), @UpnpStateVariable(name="A_ARG_TYPE_ConnectionStatus", allowedValuesEnum=ConnectionInfo.Status.class, sendEvents=false), @UpnpStateVariable(name="A_ARG_TYPE_ConnectionManager", datatype="string", sendEvents=false), @UpnpStateVariable(name="A_ARG_TYPE_Direction", allowedValuesEnum=ConnectionInfo.Direction.class, sendEvents=false), @UpnpStateVariable(name="A_ARG_TYPE_ProtocolInfo", datatype="string", sendEvents=false), @UpnpStateVariable(name="A_ARG_TYPE_ConnectionID", datatype="i4", sendEvents=false), @UpnpStateVariable(name="A_ARG_TYPE_AVTransportID", datatype="i4", sendEvents=false), @UpnpStateVariable(name="A_ARG_TYPE_RcsID", datatype="i4", sendEvents=false)})
public class ConnectionManagerService {
    private final Logger logger = LoggerFactory.getLogger((String)ConnectionManagerService.class.getName());
    protected final PropertyChangeSupport propertyChangeSupport;
    protected final Map<Integer, ConnectionInfo> activeConnections = new ConcurrentHashMap<Integer, ConnectionInfo>();
    protected final ProtocolInfos sourceProtocolInfo;
    protected final ProtocolInfos sinkProtocolInfo;

    public ConnectionManagerService() {
        this(new ConnectionInfo());
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManagerService(ProtocolInfos sourceProtocolInfo, ProtocolInfos sinkProtocolInfo) {
        this((ProtocolInfos)var1_1, (ProtocolInfos)var2_2, new ConnectionInfo());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManagerService(ConnectionInfo ... activeConnections) {
        this(null, new ProtocolInfos(new ProtocolInfo[0]), new ProtocolInfos(new ProtocolInfo[0]), (ConnectionInfo[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManagerService(ProtocolInfos sourceProtocolInfo, ProtocolInfos sinkProtocolInfo, ConnectionInfo ... activeConnections) {
        this(null, (ProtocolInfos)var1_1, (ProtocolInfos)var2_2, (ConnectionInfo[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionManagerService(PropertyChangeSupport propertyChangeSupport, ProtocolInfos sourceProtocolInfo, ProtocolInfos sinkProtocolInfo, ConnectionInfo ... activeConnections) {
        void var3_4;
        void var2_2;
        ConnectionInfo[] connectionInfoArray;
        this.propertyChangeSupport = propertyChangeSupport == null ? new PropertyChangeSupport((Object)this) : connectionInfoArray;
        this.sourceProtocolInfo = var2_2;
        this.sinkProtocolInfo = var3_4;
        connectionInfoArray = activeConnections;
        int n = activeConnections.length;
        for (int i = 0; i < n; ++i) {
            ConnectionInfo activeConnection = connectionInfoArray[i];
            this.activeConnections.put(activeConnection.getConnectionID(), activeConnection);
        }
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    /*
     * WARNING - void declaration
     */
    @UpnpAction(out={@UpnpOutputArgument(name="RcsID", getterName="getRcsID"), @UpnpOutputArgument(name="AVTransportID", getterName="getAvTransportID"), @UpnpOutputArgument(name="ProtocolInfo", getterName="getProtocolInfo"), @UpnpOutputArgument(name="PeerConnectionManager", stateVariable="A_ARG_TYPE_ConnectionManager", getterName="getPeerConnectionManager"), @UpnpOutputArgument(name="PeerConnectionID", stateVariable="A_ARG_TYPE_ConnectionID", getterName="getPeerConnectionID"), @UpnpOutputArgument(name="Direction", getterName="getDirection"), @UpnpOutputArgument(name="Status", stateVariable="A_ARG_TYPE_ConnectionStatus", getterName="getConnectionStatus")})
    public synchronized ConnectionInfo getCurrentConnectionInfo(@UpnpInputArgument(name="ConnectionID") int connectionId) throws ActionException {
        void var2_2;
        this.logger.debug("Getting connection information of connection ID: {}", (Object)connectionId);
        ConnectionInfo info = this.activeConnections.get(connectionId);
        if (info == null) {
            void var1_1;
            throw new ConnectionManagerException(ConnectionManagerErrorCode.INVALID_CONNECTION_REFERENCE, "Non-active connection ID: " + (int)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @UpnpAction(out={@UpnpOutputArgument(name="ConnectionIDs")})
    public synchronized CSV<UnsignedIntegerFourBytes> getCurrentConnectionIDs() {
        void var1_1;
        CSVUnsignedIntegerFourBytes csv = new CSVUnsignedIntegerFourBytes();
        for (Integer connectionID : this.activeConnections.keySet()) {
            void var3_3;
            csv.add((Object)new UnsignedIntegerFourBytes((long)var3_3.intValue()));
        }
        this.logger.debug("Returning current connection IDs: {}", (Object)csv.size());
        return var1_1;
    }

    @UpnpAction(out={@UpnpOutputArgument(name="Source", stateVariable="SourceProtocolInfo", getterName="getSourceProtocolInfo"), @UpnpOutputArgument(name="Sink", stateVariable="SinkProtocolInfo", getterName="getSinkProtocolInfo")})
    public synchronized void getProtocolInfo() throws ActionException {
    }

    public synchronized ProtocolInfos getSourceProtocolInfo() {
        return this.sourceProtocolInfo;
    }

    public synchronized ProtocolInfos getSinkProtocolInfo() {
        return this.sinkProtocolInfo;
    }
}

