/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.connectionmanager;

import org.jupnp.binding.annotations.UpnpAction;
import org.jupnp.binding.annotations.UpnpInputArgument;
import org.jupnp.binding.annotations.UpnpOutputArgument;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.internal.compat.java.beans.PropertyChangeSupport;
import org.jupnp.model.ServiceReference;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.model.types.csv.CSV;
import org.jupnp.support.connectionmanager.ConnectionManagerException;
import org.jupnp.support.connectionmanager.ConnectionManagerService;
import org.jupnp.support.connectionmanager.callback.ConnectionComplete;
import org.jupnp.support.connectionmanager.callback.PrepareForConnection;
import org.jupnp.support.model.ConnectionInfo;
import org.jupnp.support.model.ProtocolInfo;
import org.jupnp.support.model.ProtocolInfos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPeeringConnectionManagerService
extends ConnectionManagerService {
    private final Logger logger = LoggerFactory.getLogger(AbstractPeeringConnectionManagerService.class);

    /*
     * WARNING - void declaration
     */
    protected AbstractPeeringConnectionManagerService(ConnectionInfo ... activeConnections) {
        super((ConnectionInfo[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractPeeringConnectionManagerService(ProtocolInfos sourceProtocolInfo, ProtocolInfos sinkProtocolInfo, ConnectionInfo ... activeConnections) {
        super((ProtocolInfos)var1_1, (ProtocolInfos)var2_2, (ConnectionInfo[])var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractPeeringConnectionManagerService(PropertyChangeSupport propertyChangeSupport, ProtocolInfos sourceProtocolInfo, ProtocolInfos sinkProtocolInfo, ConnectionInfo ... activeConnections) {
        super((PropertyChangeSupport)var1_1, (ProtocolInfos)var2_2, (ProtocolInfos)var3_3, activeConnections);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized int getNewConnectionId() {
        void var1_1;
        int currentHighestID = -1;
        for (Integer key : this.activeConnections.keySet()) {
            void var3_3;
            if (key <= currentHighestID) continue;
            currentHighestID = var3_3.intValue();
        }
        ++currentHighestID;
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void storeConnection(ConnectionInfo info) {
        void var1_1;
        void var2_2;
        CSV<UnsignedIntegerFourBytes> oldConnectionIDs = this.getCurrentConnectionIDs();
        this.activeConnections.put(info.getConnectionID(), info);
        this.logger.debug("Connection stored, firing event: {}", (Object)info.getConnectionID());
        CSV<UnsignedIntegerFourBytes> newConnectionIDs = this.getCurrentConnectionIDs();
        this.getPropertyChangeSupport().firePropertyChange("CurrentConnectionIDs", (Object)var2_2, (Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized void removeConnection(int connectionID) {
        void var1_2;
        void var2_3;
        CSV<UnsignedIntegerFourBytes> oldConnectionIDs = this.getCurrentConnectionIDs();
        this.activeConnections.remove(connectionID);
        this.logger.debug("Connection removed, firing event: {}", (Object)connectionID);
        CSV<UnsignedIntegerFourBytes> newConnectionIDs = this.getCurrentConnectionIDs();
        this.getPropertyChangeSupport().firePropertyChange("CurrentConnectionIDs", (Object)var2_3, (Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @UpnpAction(out={@UpnpOutputArgument(name="ConnectionID", stateVariable="A_ARG_TYPE_ConnectionID", getterName="getConnectionID"), @UpnpOutputArgument(name="AVTransportID", stateVariable="A_ARG_TYPE_AVTransportID", getterName="getAvTransportID"), @UpnpOutputArgument(name="RcsID", stateVariable="A_ARG_TYPE_RcsID", getterName="getRcsID")})
    public synchronized ConnectionInfo prepareForConnection(@UpnpInputArgument(name="RemoteProtocolInfo", stateVariable="A_ARG_TYPE_ProtocolInfo") ProtocolInfo remoteProtocolInfo, @UpnpInputArgument(name="PeerConnectionManager", stateVariable="A_ARG_TYPE_ConnectionManager") ServiceReference peerConnectionManager, @UpnpInputArgument(name="PeerConnectionID", stateVariable="A_ARG_TYPE_ConnectionID") int peerConnectionId, @UpnpInputArgument(name="Direction", stateVariable="A_ARG_TYPE_Direction") String direction) throws ActionException {
        void var1_1;
        void var2_2;
        void var3_3;
        ConnectionInfo.Direction dir;
        int connectionId = this.getNewConnectionId();
        try {
            dir = ConnectionInfo.Direction.valueOf(direction);
        }
        catch (Exception exception) {
            throw new ConnectionManagerException(ErrorCode.ARGUMENT_VALUE_INVALID, "Unsupported direction: " + direction);
        }
        this.logger.debug("Preparing for connection with local new ID {} and peer connection ID: {}", (Object)connectionId, (Object)peerConnectionId);
        ConnectionInfo newConnectionInfo = this.createConnection(connectionId, (int)var3_3, (ServiceReference)var2_2, dir, remoteProtocolInfo);
        this.storeConnection(newConnectionInfo);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @UpnpAction
    public synchronized void connectionComplete(@UpnpInputArgument(name="ConnectionID", stateVariable="A_ARG_TYPE_ConnectionID") int connectionID) throws ActionException {
        void var1_1;
        void var2_2;
        ConnectionInfo info = this.getCurrentConnectionInfo(connectionID);
        this.logger.debug("Closing connection ID {}", (Object)connectionID);
        this.closeConnection((ConnectionInfo)var2_2);
        this.removeConnection((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int createConnectionWithPeer(ServiceReference localServiceReference, ControlPoint controlPoint, Service<?, ?> peerService, final ProtocolInfo protInfo, ConnectionInfo.Direction direction) {
        void var3_3;
        void var1_1;
        void var2_2;
        final int localConnectionID = this.getNewConnectionId();
        this.logger.debug("Creating new connection ID {} with peer: {}", (Object)localConnectionID, peerService);
        boolean[] failed = new boolean[1];
        new PrepareForConnection(this, peerService, (ControlPoint)var2_2, protInfo, (ServiceReference)var1_1, localConnectionID, direction, (Service)var3_3, direction, failed){
            final /* synthetic */ Service val$peerService;
            final /* synthetic */ ConnectionInfo.Direction val$direction;
            final /* synthetic */ boolean[] val$failed;
            final /* synthetic */ AbstractPeeringConnectionManagerService this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.val$peerService = service2;
                this.val$direction = direction2;
                this.val$failed = blArray;
                this.this$0 = var1_1;
                super((Service<?, ?>)var2_2, (ControlPoint)var3_3, remoteProtocolInfo, peerConnectionManager, peerConnectionID, direction);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void received(ActionInvocation<?> invocation, int peerConnectionID, int rcsID, int avTransportID) {
                void var1_1;
                void var2_2;
                void var3_3;
                ConnectionInfo info = new ConnectionInfo(localConnectionID, (int)var3_3, avTransportID, protInfo, this.val$peerService.getReference(), (int)var2_2, this.val$direction.getOpposite(), ConnectionInfo.Status.OK);
                this.this$0.storeConnection((ConnectionInfo)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0.peerFailure((ActionInvocation<?>)var1_1, (UpnpResponse)var2_2, (String)var3_3);
                this.val$failed[0] = true;
            }
        }.run();
        if (failed[0]) {
            return -1;
        }
        return localConnectionID;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void closeConnectionWithPeer(ControlPoint controlPoint, Service<?, ?> peerService, int connectionID) throws ActionException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.closeConnectionWithPeer((ControlPoint)var1_1, (Service<?, ?>)var2_2, this.getCurrentConnectionInfo((int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void closeConnectionWithPeer(ControlPoint controlPoint, Service<?, ?> peerService, ConnectionInfo connectionInfo) throws ActionException {
        void var3_3;
        void var1_1;
        void var2_2;
        this.logger.debug("Closing connection ID {} with peer: {}", (Object)connectionInfo.getConnectionID(), peerService);
        new ConnectionComplete(this, (Service)var2_2, (ControlPoint)var1_1, connectionInfo.getPeerConnectionID(), (ConnectionInfo)var3_3){
            final /* synthetic */ ConnectionInfo val$connectionInfo;
            final /* synthetic */ AbstractPeeringConnectionManagerService this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.val$connectionInfo = connectionInfo;
                this.this$0 = var1_1;
                super((Service<?, ?>)var2_2, (ControlPoint)var3_3, connectionID);
            }

            public void success(ActionInvocation invocation) {
                this.this$0.removeConnection(this.val$connectionInfo.getConnectionID());
            }

            /*
             * WARNING - void declaration
             */
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0.peerFailure((ActionInvocation<?>)var1_1, (UpnpResponse)var2_2, (String)var3_3);
            }
        }.run();
    }

    protected abstract ConnectionInfo createConnection(int var1, int var2, ServiceReference var3, ConnectionInfo.Direction var4, ProtocolInfo var5) throws ActionException;

    protected abstract void closeConnection(ConnectionInfo var1);

    protected abstract void peerFailure(ActionInvocation<?> var1, UpnpResponse var2, String var3);
}

