/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.avtransport.impl;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.support.avtransport.AVTransportErrorCode;
import org.jupnp.support.avtransport.AVTransportException;
import org.jupnp.support.avtransport.AbstractAVTransportService;
import org.jupnp.support.avtransport.impl.AVTransportStateMachine;
import org.jupnp.support.avtransport.impl.state.AbstractState;
import org.jupnp.support.lastchange.LastChange;
import org.jupnp.support.model.AVTransport;
import org.jupnp.support.model.DeviceCapabilities;
import org.jupnp.support.model.MediaInfo;
import org.jupnp.support.model.PlayMode;
import org.jupnp.support.model.PositionInfo;
import org.jupnp.support.model.RecordQualityMode;
import org.jupnp.support.model.SeekMode;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.TransportAction;
import org.jupnp.support.model.TransportInfo;
import org.jupnp.support.model.TransportSettings;
import org.jupnp.util.statemachine.StateMachineBuilder;
import org.jupnp.util.statemachine.TransitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AVTransportService<T extends AVTransport>
extends AbstractAVTransportService {
    private final Logger logger = LoggerFactory.getLogger(AVTransportService.class);
    private final Map<Long, AVTransportStateMachine> stateMachines = new ConcurrentHashMap<Long, AVTransportStateMachine>();
    final Class<? extends AVTransportStateMachine> stateMachineDefinition;
    final Class<? extends AbstractState<?>> initialState;
    final Class<? extends AVTransport> transportClass;

    /*
     * WARNING - void declaration
     */
    public AVTransportService(Class<? extends AVTransportStateMachine> stateMachineDefinition, Class<? extends AbstractState<?>> initialState) {
        this((Class<AVTransportStateMachine>)((Class<? extends AVTransportStateMachine>)var1_1), (Class<AbstractState<?>>)var2_2, AVTransport.class);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public AVTransportService(Class<? extends AVTransportStateMachine> stateMachineDefinition, Class<? extends AbstractState<?>> initialState, Class<T> transportClass) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.stateMachineDefinition = var1_1;
        this.initialState = var2_2;
        this.transportClass = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setAVTransportURI(UnsignedIntegerFourBytes instanceId, String currentURI, String currentURIMetaData) throws AVTransportException {
        try {
            URI uri = new URI(currentURI);
        }
        catch (Exception exception) {
            throw new AVTransportException(ErrorCode.INVALID_ARGS, "CurrentURI can not be null or malformed");
        }
        try {
            void var3_4;
            void var2_3;
            instanceId = this.findStateMachine((UnsignedIntegerFourBytes)instanceId, true);
            instanceId.setTransportURI((URI)var2_3, (String)var3_4);
            return;
        }
        catch (TransitionException e) {
            void var1_2;
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setNextAVTransportURI(UnsignedIntegerFourBytes instanceId, String nextURI, String nextURIMetaData) throws AVTransportException {
        try {
            URI uri = new URI(nextURI);
        }
        catch (Exception exception) {
            throw new AVTransportException(ErrorCode.INVALID_ARGS, "NextURI can not be null or malformed");
        }
        try {
            void var3_4;
            void var2_3;
            instanceId = this.findStateMachine((UnsignedIntegerFourBytes)instanceId, true);
            instanceId.setNextTransportURI((URI)var2_3, (String)var3_4);
            return;
        }
        catch (TransitionException e) {
            void var1_2;
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPlayMode(UnsignedIntegerFourBytes instanceId, String newPlayMode) throws AVTransportException {
        Object transport = ((AbstractState)this.findStateMachine(instanceId).getCurrentState()).getTransport();
        try {
            void var1_1;
            ((AVTransport)transport).setTransportSettings(new TransportSettings(PlayMode.valueOf(newPlayMode), var1_1.getTransportSettings().getRecQualityMode()));
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var2_2;
            throw new AVTransportException(AVTransportErrorCode.PLAYMODE_NOT_SUPPORTED, "Unsupported play mode: " + (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setRecordQualityMode(UnsignedIntegerFourBytes instanceId, String newRecordQualityMode) throws AVTransportException {
        Object transport = ((AbstractState)this.findStateMachine(instanceId).getCurrentState()).getTransport();
        try {
            void var1_1;
            ((AVTransport)transport).setTransportSettings(new TransportSettings(var1_1.getTransportSettings().getPlayMode(), RecordQualityMode.valueOrExceptionOf(newRecordQualityMode)));
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var2_2;
            throw new AVTransportException(AVTransportErrorCode.RECORDQUALITYMODE_NOT_SUPPORTED, "Unsupported record quality mode: " + (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MediaInfo getMediaInfo(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        void var1_1;
        return ((AVTransport)((AbstractState)this.findStateMachine((UnsignedIntegerFourBytes)var1_1).getCurrentState()).getTransport()).getMediaInfo();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TransportInfo getTransportInfo(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        void var1_1;
        return ((AVTransport)((AbstractState)this.findStateMachine((UnsignedIntegerFourBytes)var1_1).getCurrentState()).getTransport()).getTransportInfo();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PositionInfo getPositionInfo(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        void var1_1;
        return ((AVTransport)((AbstractState)this.findStateMachine((UnsignedIntegerFourBytes)var1_1).getCurrentState()).getTransport()).getPositionInfo();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DeviceCapabilities getDeviceCapabilities(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        void var1_1;
        return ((AVTransport)((AbstractState)this.findStateMachine((UnsignedIntegerFourBytes)var1_1).getCurrentState()).getTransport()).getDeviceCapabilities();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TransportSettings getTransportSettings(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        void var1_1;
        return ((AVTransport)((AbstractState)this.findStateMachine((UnsignedIntegerFourBytes)var1_1).getCurrentState()).getTransport()).getTransportSettings();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void stop(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).stop();
            return;
        }
        catch (TransitionException e) {
            void var1_2;
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void play(UnsignedIntegerFourBytes instanceId, String speed) throws AVTransportException {
        try {
            void var2_3;
            this.findStateMachine(instanceId).play((String)var2_3);
            return;
        }
        catch (TransitionException e) {
            void var1_2;
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void pause(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).pause();
            return;
        }
        catch (TransitionException e) {
            void var1_2;
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void record(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).record();
            return;
        }
        catch (TransitionException e) {
            void var1_2;
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void seek(UnsignedIntegerFourBytes instanceId, String unit, String target) throws AVTransportException {
        SeekMode seekMode;
        try {
            seekMode = SeekMode.valueOrExceptionOf(unit);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void var2_3;
            throw new AVTransportException(AVTransportErrorCode.SEEKMODE_NOT_SUPPORTED, "Unsupported seek mode: " + (String)var2_3);
        }
        try {
            void var3_4;
            this.findStateMachine(instanceId).seek(seekMode, (String)var3_4);
            return;
        }
        catch (TransitionException e) {
            void var1_2;
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void next(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).next();
            return;
        }
        catch (TransitionException e) {
            void var1_2;
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void previous(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        try {
            this.findStateMachine(instanceId).previous();
            return;
        }
        catch (TransitionException e) {
            void var1_2;
            throw new AVTransportException(AVTransportErrorCode.TRANSITION_NOT_AVAILABLE, var1_2.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected TransportAction[] getCurrentTransportActions(UnsignedIntegerFourBytes instanceId) throws Exception {
        AVTransportStateMachine stateMachine = this.findStateMachine(instanceId);
        try {
            void var1_1;
            return ((AbstractState)var1_1.getCurrentState()).getCurrentTransportActions();
        }
        catch (TransitionException transitionException) {
            return new TransportAction[0];
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UnsignedIntegerFourBytes[] getCurrentInstanceIds() {
        Map<Long, AVTransportStateMachine> map = this.stateMachines;
        synchronized (map) {
            void var2_2;
            UnsignedIntegerFourBytes[] ids = new UnsignedIntegerFourBytes[this.stateMachines.size()];
            int i = 0;
            for (Long id : this.stateMachines.keySet()) {
                ids[i] = new UnsignedIntegerFourBytes(id.longValue());
                ++i;
            }
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected AVTransportStateMachine findStateMachine(UnsignedIntegerFourBytes instanceId) throws AVTransportException {
        void var1_1;
        return this.findStateMachine((UnsignedIntegerFourBytes)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    protected AVTransportStateMachine findStateMachine(UnsignedIntegerFourBytes instanceId, boolean createDefaultTransport) throws AVTransportException {
        Map<Long, AVTransportStateMachine> map = this.stateMachines;
        synchronized (map) {
            void var2_3;
            long id = instanceId.getValue();
            AVTransportStateMachine stateMachine = this.stateMachines.get(id);
            if (stateMachine == null && id == 0L && var2_3 != false) {
                void var1_1;
                this.logger.debug("Creating default transport instance with ID '0'");
                stateMachine = this.createStateMachine((UnsignedIntegerFourBytes)var1_1);
                this.stateMachines.put(id, stateMachine);
            } else if (stateMachine == null) {
                throw new AVTransportException(AVTransportErrorCode.INVALID_INSTANCE_ID);
            }
            this.logger.debug("Found transport control with ID '{}'", (Object)id);
            return stateMachine;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected AVTransportStateMachine createStateMachine(UnsignedIntegerFourBytes instanceId) {
        void var1_1;
        return (AVTransportStateMachine)StateMachineBuilder.build(this.stateMachineDefinition, this.initialState, (Class[])new Class[]{this.transportClass}, (Object[])new Object[]{this.createTransport((UnsignedIntegerFourBytes)var1_1, this.getLastChange())});
    }

    /*
     * WARNING - void declaration
     */
    protected AVTransport createTransport(UnsignedIntegerFourBytes instanceId, LastChange lastChange) {
        void var2_2;
        void var1_1;
        return new AVTransport((UnsignedIntegerFourBytes)var1_1, (LastChange)var2_2, StorageMedium.NETWORK);
    }
}

