/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.contentnegotiation;

import io.ktor.http.BadContentTypeFormatException;
import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.plugins.BadRequestException;
import io.ktor.server.plugins.contentnegotiation.ContentTypeWithQuality;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a'\u0010\t\u001a\u00020\b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/ktor/server/application/ApplicationCall;", "", "Lio/ktor/server/plugins/contentnegotiation/ContentTypeWithQuality;", "parseAcceptHeader", "(Lio/ktor/server/application/ApplicationCall;)Ljava/util/List;", "acceptItems", "Lio/ktor/http/ContentType;", "contentType", "", "checkAcceptHeader", "(Ljava/util/List;Lio/ktor/http/ContentType;)Z", "ktor-server-content-negotiation"})
@SourceDebugExtension(value={"SMAP\nContentNegotiationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentNegotiationUtils.kt\nio/ktor/server/plugins/contentnegotiation/ContentNegotiationUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n1557#2:38\n1628#2,3:39\n1755#2,3:42\n*S KotlinDebug\n*F\n+ 1 ContentNegotiationUtils.kt\nio/ktor/server/plugins/contentnegotiation/ContentNegotiationUtilsKt\n*L\n24#1:38\n24#1:39,3\n35#1:42,3\n*E\n"})
public final class ContentNegotiationUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final List<ContentTypeWithQuality> parseAcceptHeader(ApplicationCall $this$parseAcceptHeader) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$parseAcceptHeader, (String)"<this>");
        Object acceptHeaderContent = ApplicationRequestPropertiesKt.header((ApplicationRequest)$this$parseAcceptHeader.getRequest(), (String)HttpHeaders.INSTANCE.getAccept());
        try {
            Iterable $this$map$iv = HttpHeaderValueParserKt.parseHeaderValue((String)acceptHeaderContent);
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            object = object.iterator();
            while (object.hasNext()) {
                void var3_4;
                void it;
                Object item$iv$iv = object.next();
                item$iv$iv = (HeaderValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                collection.add(new ContentTypeWithQuality(ContentType.Companion.parse(it.getValue()), var3_4.getQuality()));
            }
            destination$iv$iv = (List)destination$iv$iv;
        }
        catch (BadContentTypeFormatException parseFailure) {
            void var1_2;
            Object object;
            throw new BadRequestException("Illegal Accept header format: " + (String)object, (Throwable)var1_2);
        }
        return var1_1;
    }

    public static final boolean checkAcceptHeader(List<ContentTypeWithQuality> acceptItems, ContentType contentType) {
        Intrinsics.checkNotNullParameter(acceptItems, (String)"acceptItems");
        if (acceptItems.isEmpty() || contentType == null) {
            return true;
        }
        Iterable $this$any$iv = acceptItems;
        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) {
            Iterable iterable;
            iterable = iterable.iterator();
            while (iterable.hasNext()) {
                Object e = iterable.next();
                ContentTypeWithQuality it = (ContentTypeWithQuality)e;
                if (!contentType.match(((ContentTypeWithQuality)e).getContentType())) continue;
                return true;
            }
        }
        return false;
    }
}

