/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.internal.MathKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lkotlinx/datetime/internal/DecimalFraction;", "", "fractionalPart", "", "digits", "(II)V", "getDigits", "()I", "getFractionalPart", "compareTo", "other", "equals", "", "", "fractionalPartWithNDigits", "newDigits", "hashCode", "toString", "", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nmath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 math.kt\nkotlinx/datetime/internal/DecimalFraction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n1#2:242\n*E\n"})
public final class DecimalFraction
implements Comparable<DecimalFraction> {
    private final int fractionalPart;
    private final int digits;

    /*
     * WARNING - void declaration
     */
    public DecimalFraction(int fractionalPart, int digits) {
        void var2_3;
        void var1_1;
        this.fractionalPart = var1_1;
        this.digits = var2_3;
        if (!(this.digits >= 0)) {
            String string = "Digits must be non-negative, but was " + this.digits;
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int fractionalPartWithNDigits(int newDigits) {
        void var1_1;
        if (newDigits == this.digits) {
            return this.fractionalPart;
        }
        if (newDigits > this.digits) {
            return this.fractionalPart * MathKt.getPOWERS_OF_TEN()[newDigits - this.digits];
        }
        return this.fractionalPart / MathKt.getPOWERS_OF_TEN()[this.digits - var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private int compareTo(DecimalFraction other) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int maxPrecision = Math.max(this.digits, other.digits);
        return Intrinsics.compare((int)this.fractionalPartWithNDigits(maxPrecision), (int)var1_1.fractionalPartWithNDigits((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof DecimalFraction && this.compareTo((DecimalFraction)var1_1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var3_3;
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        int denominator = MathKt.getPOWERS_OF_TEN()[this.digits];
        $this$toString_u24lambda_u242.append(this.fractionalPart / denominator);
        $this$toString_u24lambda_u242.append('.');
        var2_2.append(StringsKt.removePrefix((String)String.valueOf(denominator + this.fractionalPart % var3_3), (CharSequence)"1"));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final int hashCode() {
        throw new UnsupportedOperationException("DecimalFraction is not supposed to be used as a hash key");
    }
}

