/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.format.DateTimeComponents;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.serializers.InstantIso8601Serializer;
import kotlinx.serialization.Serializable;

@Serializable(with=InstantIso8601Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001!B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\nH\u0016J\u001b\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001e\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001b\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017H\u0086\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u0019J\u0006\u0010\u001e\u001a\u00020\u0006J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\""}, d2={"Lkotlinx/datetime/Instant;", "", "value", "Ljava/time/Instant;", "(Ljava/time/Instant;)V", "epochSeconds", "", "getEpochSeconds", "()J", "nanosecondsOfSecond", "", "getNanosecondsOfSecond", "()I", "getValue$kotlinx_datetime", "()Ljava/time/Instant;", "compareTo", "other", "equals", "", "", "hashCode", "minus", "duration", "Lkotlin/time/Duration;", "minus-LRDsOJo", "(J)Lkotlinx/datetime/Instant;", "minus-5sfh64U", "(Lkotlinx/datetime/Instant;)J", "plus", "plus-LRDsOJo", "toEpochMilliseconds", "toString", "", "Companion", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nInstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Instant.kt\nkotlinx/datetime/Instant\n+ 2 Duration.kt\nkotlin/time/Duration\n*L\n1#1,186:1\n731#2,2:187\n*S KotlinDebug\n*F\n+ 1 Instant.kt\nkotlinx/datetime/Instant\n*L\n36#1:187,2\n*E\n"})
public final class Instant
implements Comparable<Instant> {
    public static final Companion Companion = new Companion(0);
    private final java.time.Instant value;
    private static final Instant MIN;
    private static final Instant MAX;

    /*
     * WARNING - void declaration
     */
    public Instant(java.time.Instant value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = var1_1;
    }

    public final java.time.Instant getValue$kotlinx_datetime() {
        return this.value;
    }

    public final long getEpochSeconds() {
        return this.value.getEpochSecond();
    }

    public final long toEpochMilliseconds() {
        long l;
        try {
            l = this.value.toEpochMilli();
        }
        catch (ArithmeticException arithmeticException) {
            l = this.value.isAfter(java.time.Instant.EPOCH) ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof Instant && Intrinsics.areEqual((Object)this.value, (Object)((Instant)var1_1).value);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    public final String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        java.time.Instant instant = java.time.Instant.ofEpochSecond(-3217862419201L, 999999999L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(...)");
        new Instant(instant);
        java.time.Instant instant2 = java.time.Instant.ofEpochSecond(3093527980800L, 0L);
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"ofEpochSecond(...)");
        new Instant(instant2);
        java.time.Instant instant3 = java.time.Instant.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"MIN");
        MIN = new Instant(instant3);
        java.time.Instant instant4 = java.time.Instant.MAX;
        Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"MAX");
        MAX = new Instant(instant4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u000fJ\b\u0010\u0014\u001a\u00020\u0004H\u0007J\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eH\u00c6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lkotlinx/datetime/Instant$Companion;", "", "()V", "DISTANT_FUTURE", "Lkotlinx/datetime/Instant;", "getDISTANT_FUTURE", "()Lkotlinx/datetime/Instant;", "DISTANT_PAST", "getDISTANT_PAST", "MAX", "getMAX$kotlinx_datetime", "MIN", "getMIN$kotlinx_datetime", "fromEpochMilliseconds", "epochMilliseconds", "", "fromEpochSeconds", "epochSeconds", "nanosecondAdjustment", "", "now", "parse", "input", "", "format", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/format/DateTimeComponents;", "isoString", "", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        public static Instant fromEpochMilliseconds(long epochMilliseconds) {
            long l;
            java.time.Instant instant = java.time.Instant.ofEpochMilli(l);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
            return new Instant(instant);
        }

        /*
         * WARNING - void declaration
         */
        public static Instant parse(CharSequence input, DateTimeFormat<DateTimeComponents> format) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(format, (String)"format");
            try {
                format = format.parse(input).toInstantUsingOffset();
            }
            catch (IllegalArgumentException e) {
                void var1_2;
                CharSequence charSequence;
                throw new DateTimeFormatException("Failed to parse an instant from '" + charSequence + '\'', (Throwable)var1_2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final Instant fromEpochSeconds(long epochSeconds, long nanosecondAdjustment2) {
            Instant instant;
            try {
                java.time.Instant instant2 = java.time.Instant.ofEpochSecond(epochSeconds, nanosecondAdjustment2);
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"ofEpochSecond(...)");
                Instant nanosecondAdjustment2 = new Instant(instant2);
            }
            catch (Exception exception) {
                void var1_1;
                Exception e = exception;
                if (!(exception instanceof ArithmeticException) && !(e instanceof DateTimeException)) {
                    throw instant;
                }
                instant = var1_1 > 0L ? MAX : MIN;
            }
            return instant;
        }

        public /* synthetic */ Companion(byte by) {
            this();
        }
    }
}

