/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class StatusPrinter {
    private static PrintStream ps = System.out;
    static CachingDateFormatter cachingDateFormat = new CachingDateFormatter("HH:mm:ss,SSS");

    public static void setPrintStream(PrintStream printStream) {
        ps = printStream;
    }

    public static void printInCaseOfErrorsOrWarnings(Context context) {
        StatusPrinter.printInCaseOfErrorsOrWarnings(context, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public static void printInCaseOfErrorsOrWarnings(Context context, long threshold) {
        Object object;
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
            return;
        }
        if (((StatusUtil)(object = new StatusUtil((Context)object))).getHighestLevel(threshold) > 0) {
            void var1_1;
            void var3_2;
            StatusPrinter.print((StatusManager)var3_2, (long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void printIfErrorsOccured(Context context) {
        Object object;
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
            return;
        }
        if (((StatusUtil)(object = new StatusUtil((Context)object))).getHighestLevel(0L) == 2) {
            void var1_1;
            StatusPrinter.print((StatusManager)var1_1);
        }
    }

    public static void print(Context context) {
        StatusPrinter.print(context, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public static void print(Context context, long threshold) {
        void var1_1;
        void var3_2;
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            Context context2;
            ps.println("WARN: Context named \"" + context2.getName() + "\" has no status manager");
            return;
        }
        StatusPrinter.print((StatusManager)var3_2, (long)var1_1);
    }

    public static void print(StatusManager sm) {
        StatusPrinter.print(sm, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public static void print(StatusManager sm, long threshold) {
        void var3_2;
        List<Status> list;
        void var1_1;
        StringBuilder sb = new StringBuilder();
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(sm.getCopyOfStatusList(), (long)var1_1);
        StatusPrinter.buildStrFromStatusList(sb, list);
        ps.println(var3_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    public static void print(List<Status> statusList) {
        void var1_1;
        List<Status> list;
        StringBuilder sb = new StringBuilder();
        StatusPrinter.buildStrFromStatusList(sb, list);
        ps.println(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    private static void buildStrFromStatusList(StringBuilder sb, List<Status> statusList) {
        Iterator iterator;
        if (statusList == null) {
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Status s = (Status)iterator.next();
            StatusPrinter.buildStr(sb, "", (Status)var2_2);
        }
    }

    private static void appendThrowable(StringBuilder sb, Throwable t) {
        String[] stringArray = ThrowableToStringArray.convert(t);
        String[] stringArray2 = stringArray;
        stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String s = stringArray2[i];
            if (!s.startsWith("Caused by: ")) {
                if (Character.isDigit(s.charAt(0))) {
                    sb.append("\t... ");
                } else {
                    sb.append("\tat ");
                }
            }
            sb.append(s).append(CoreConstants.LINE_SEPARATOR);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void buildStr(StringBuilder sb, String indentation, Status s) {
        void var3_3;
        String prefix = s.hasChildren() ? indentation + "+ " : indentation + "|-";
        if (cachingDateFormat != null) {
            String dateStr = cachingDateFormat.format(s.getTimestamp());
            sb.append(dateStr).append(" ");
        }
        sb.append((String)var3_3).append(s).append(CoreConstants.LINE_SEPARATOR);
        if (s.getThrowable() != null) {
            StatusPrinter.appendThrowable(sb, s.getThrowable());
        }
        if (s.hasChildren()) {
            Iterator<Status> ite = s.iterator();
            while (ite.hasNext()) {
                void var2_2;
                Status child = ite.next();
                StatusPrinter.buildStr(sb, indentation + "  ", (Status)var2_2);
            }
        }
    }
}

