/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetworkAddressUtil
extends ContextAwareBase {
    /*
     * WARNING - void declaration
     */
    public NetworkAddressUtil(Context context) {
        void var1_1;
        this.setContext((Context)var1_1);
    }

    public static String getLocalHostName() throws UnknownHostException, SocketException {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return NetworkAddressUtil.getLocalAddressAsString();
        }
    }

    public static String getCanonicalLocalHostName() throws UnknownHostException, SocketException {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return NetworkAddressUtil.getLocalAddressAsString();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String getLocalAddressAsString() throws UnknownHostException, SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces != null && interfaces.hasMoreElements()) {
            Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
            while (addresses != null && addresses.hasMoreElements()) {
                void var2_2;
                InetAddress address = addresses.nextElement();
                if (!NetworkAddressUtil.acceptableAddress(address)) continue;
                return var2_2.getHostAddress();
            }
        }
        throw new UnknownHostException();
    }

    private static boolean acceptableAddress(InetAddress address) {
        InetAddress inetAddress;
        return address != null && !address.isLoopbackAddress() && !address.isAnyLocalAddress() && !inetAddress.isLinkLocalAddress();
    }

    /*
     * WARNING - void declaration
     */
    public String safelyGetLocalHostName() {
        try {
            String string = NetworkAddressUtil.getLocalHostName();
            return string;
        }
        catch (SecurityException | SocketException | UnknownHostException e) {
            void var1_2;
            this.addError("Failed to get local hostname", (Throwable)var1_2);
            return "UNKNOWN_LOCALHOST";
        }
    }

    /*
     * WARNING - void declaration
     */
    public String safelyGetCanonicalLocalHostName() {
        try {
            String string = NetworkAddressUtil.getCanonicalLocalHostName();
            return string;
        }
        catch (SecurityException | SocketException | UnknownHostException e) {
            void var1_2;
            this.addError("Failed to get canonical local hostname", (Throwable)var1_2);
            return "UNKNOWN_LOCALHOST";
        }
    }
}

