/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSize {
    private static final String LENGTH_PART = "([0-9]+)";
    private static final int DOUBLE_GROUP = 1;
    private static final String UNIT_PART = "(|kb|mb|gb)s?";
    private static final int UNIT_GROUP = 2;
    private static final Pattern FILE_SIZE_PATTERN = Pattern.compile("([0-9]+)\\s*(|kb|mb|gb)s?", 2);
    public static final long KB_COEFFICIENT = 1024L;
    public static final long MB_COEFFICIENT = 0x100000L;
    public static final long GB_COEFFICIENT = 0x40000000L;
    final long size;

    /*
     * WARNING - void declaration
     */
    public FileSize(long size) {
        void var1_1;
        this.size = var1_1;
    }

    public long getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public static FileSize valueOf(String fileSizeStr) {
        String string;
        Matcher matcher = FILE_SIZE_PATTERN.matcher(fileSizeStr);
        if (matcher.matches()) {
            void var2_3;
            long coefficient;
            String lenStr = matcher.group(1);
            String unitStr = matcher.group(2);
            long lenValue = Long.valueOf(string);
            if (unitStr.equalsIgnoreCase("")) {
                coefficient = 1L;
            } else if (unitStr.equalsIgnoreCase("kb")) {
                coefficient = 1024L;
            } else if (unitStr.equalsIgnoreCase("mb")) {
                coefficient = 0x100000L;
            } else if (unitStr.equalsIgnoreCase("gb")) {
                coefficient = 0x40000000L;
            } else {
                void var1_1;
                throw new IllegalStateException("Unexpected " + (String)var1_1);
            }
            return new FileSize(lenValue * var2_3);
        }
        throw new IllegalArgumentException("String value [" + string + "] is not in the expected format.");
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        long inKB = this.size / 1024L;
        if (inKB == 0L) {
            return this.size + " Bytes";
        }
        long inMB = this.size / 0x100000L;
        if (inMB == 0L) {
            void var1_1;
            return (long)var1_1 + " KB";
        }
        long inGB = this.size / 0x40000000L;
        if (inGB == 0L) {
            void var3_2;
            return (long)var3_2 + " MB";
        }
        return inGB + " GB";
    }
}

