/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;

public class CachingDateFormatter {
    final DateTimeFormatter dtf;
    final ZoneId zoneId;
    final AtomicReference<CacheTuple> atomicReference;

    /*
     * WARNING - void declaration
     */
    public CachingDateFormatter(String pattern) {
        this((String)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CachingDateFormatter(String pattern, ZoneId aZoneId) {
        this((String)var1_1, (ZoneId)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CachingDateFormatter(String pattern, ZoneId aZoneId, Locale aLocale) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.zoneId = aZoneId == null ? ZoneId.systemDefault() : aZoneId;
        Locale locale = aLocale != null ? var3_3 : Locale.getDefault();
        this.dtf = DateTimeFormatter.ofPattern(pattern).withZone(this.zoneId).withLocale((Locale)var2_2);
        CacheTuple cacheTuple = new CacheTuple(-1L, null);
        this.atomicReference = new AtomicReference<void>(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String format(long now) {
        CacheTuple cacheTuple;
        CacheTuple localCacheTuple;
        CacheTuple oldCacheTuple = localCacheTuple = this.atomicReference.get();
        if (now != localCacheTuple.lastTimestamp) {
            void var1_1;
            Instant instant = Instant.ofEpochMilli(now);
            String result = this.dtf.format(instant);
            cacheTuple = new CacheTuple((long)var1_1, (String)((Object)cacheTuple));
            this.atomicReference.compareAndSet(oldCacheTuple, cacheTuple);
        }
        return cacheTuple.cachedStr;
    }

    static class CacheTuple {
        final long lastTimestamp;
        final String cachedStr;

        /*
         * WARNING - void declaration
         */
        public CacheTuple(long lastTimestamp, String cachedStr) {
            void var3_2;
            void var1_1;
            this.lastTimestamp = var1_1;
            this.cachedStr = var3_2;
        }
    }
}

