/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.testUtil;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileToBufferUtil {
    /*
     * WARNING - void declaration
     */
    public static void readIntoList(File file, List<String> stringList) throws IOException {
        void var1_1;
        File file2;
        if (file.getName().endsWith(".gz")) {
            FileToBufferUtil.gzFileReadIntoList(file, stringList);
            return;
        }
        if (file.getName().endsWith(".zip")) {
            FileToBufferUtil.zipFileReadIntoList(file, stringList);
            return;
        }
        FileToBufferUtil.regularReadIntoList(file2, (List<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void zipFileReadIntoList(File file, List<String> stringList) throws IOException {
        System.out.println("Reading zip file [" + file + "]");
        ZipFile zipFile = new ZipFile(file);
        try {
            void var1_1;
            void var3_4;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ZipEntry entry = enumeration.nextElement();
            FileToBufferUtil.readInputStream(zipFile.getInputStream((ZipEntry)var3_4), (List<String>)var1_1);
        }
        catch (Throwable throwable) {
            try {
                ZipFile zipFile2;
                zipFile2.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        zipFile.close();
    }

    /*
     * WARNING - void declaration
     */
    static void readInputStream(InputStream is, List<String> stringList) throws IOException {
        Closeable closeable;
        String line;
        Closeable in = new BufferedReader(new InputStreamReader(is));
        while ((line = ((BufferedReader)in).readLine()) != null) {
            void var2_2;
            stringList.add((String)var2_2);
        }
        ((BufferedReader)closeable).close();
    }

    /*
     * WARNING - void declaration
     */
    public static void regularReadIntoList(File file, List<String> stringList) throws IOException {
        FileInputStream fileInputStream;
        String line;
        FileInputStream fis = new FileInputStream(file);
        FileInputStream in = new BufferedReader(new InputStreamReader(fis));
        while ((line = ((BufferedReader)((Object)in)).readLine()) != null) {
            void var2_2;
            stringList.add((String)var2_2);
        }
        ((BufferedReader)((Object)fileInputStream)).close();
    }

    /*
     * WARNING - void declaration
     */
    public static void gzFileReadIntoList(File file, List<String> stringList) throws IOException {
        void var1_1;
        FileInputStream fileInputStream;
        FileInputStream fis = new FileInputStream(file);
        fileInputStream = new GZIPInputStream(fileInputStream);
        FileToBufferUtil.readInputStream(fileInputStream, (List<String>)var1_1);
    }
}

