/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.subst;

import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.Token;
import java.util.ArrayList;
import java.util.List;

public class Tokenizer {
    final String pattern;
    final int patternLength;
    TokenizerState state = TokenizerState.LITERAL_STATE;
    int pointer = 0;

    /*
     * WARNING - void declaration
     */
    public Tokenizer(String pattern) {
        void var1_1;
        this.pattern = pattern;
        this.patternLength = var1_1.length();
    }

    /*
     * WARNING - void declaration
     */
    List<Token> tokenize() throws ScanException {
        void var1_1;
        ArrayList<Token> tokenList = new ArrayList<Token>();
        StringBuilder buf = new StringBuilder();
        while (this.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state.ordinal()) {
                case 0: {
                    this.handleLiteralState(c, tokenList, buf);
                    break;
                }
                case 1: {
                    this.handleStartState(c, tokenList, buf);
                    break;
                }
                case 2: {
                    void var3_3;
                    this.handleDefaultValueState((char)var3_3, tokenList, buf);
                }
            }
        }
        switch (this.state.ordinal()) {
            case 0: {
                this.addLiteralToken(tokenList, buf);
                break;
            }
            case 2: {
                buf.append(':');
                this.addLiteralToken(tokenList, buf);
                break;
            }
            case 1: {
                void var2_2;
                buf.append('$');
                this.addLiteralToken(tokenList, (StringBuilder)var2_2);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void handleDefaultValueState(char c, List<Token> tokenList, StringBuilder stringBuilder) {
        void var1_1;
        void var3_3;
        switch (c) {
            case '-': {
                tokenList.add(Token.DEFAULT_SEP_TOKEN);
                this.state = TokenizerState.LITERAL_STATE;
                return;
            }
            case '$': {
                stringBuilder.append(':');
                this.addLiteralToken(tokenList, stringBuilder);
                stringBuilder.setLength(0);
                this.state = TokenizerState.START_STATE;
                return;
            }
            case '{': {
                void var2_2;
                stringBuilder.append(':');
                this.addLiteralToken(tokenList, stringBuilder);
                stringBuilder.setLength(0);
                var2_2.add(Token.CURLY_LEFT_TOKEN);
                this.state = TokenizerState.LITERAL_STATE;
                return;
            }
        }
        var3_3.append(':').append((char)var1_1);
        this.state = TokenizerState.LITERAL_STATE;
    }

    /*
     * WARNING - void declaration
     */
    private void handleStartState(char c, List<Token> tokenList, StringBuilder stringBuilder) {
        if (c == '{') {
            void var2_2;
            var2_2.add(Token.START_TOKEN);
        } else {
            void var1_1;
            void var3_3;
            var3_3.append('$').append((char)var1_1);
        }
        this.state = TokenizerState.LITERAL_STATE;
    }

    /*
     * WARNING - void declaration
     */
    private void handleLiteralState(char c, List<Token> tokenList, StringBuilder stringBuilder) {
        void var1_1;
        void var3_3;
        switch (c) {
            case '$': {
                this.addLiteralToken(tokenList, stringBuilder);
                stringBuilder.setLength(0);
                this.state = TokenizerState.START_STATE;
                return;
            }
            case ':': {
                this.addLiteralToken(tokenList, stringBuilder);
                stringBuilder.setLength(0);
                this.state = TokenizerState.DEFAULT_VAL_STATE;
                return;
            }
            case '{': {
                this.addLiteralToken(tokenList, stringBuilder);
                tokenList.add(Token.CURLY_LEFT_TOKEN);
                stringBuilder.setLength(0);
                return;
            }
            case '}': {
                void var2_2;
                this.addLiteralToken(tokenList, stringBuilder);
                var2_2.add(Token.CURLY_RIGHT_TOKEN);
                stringBuilder.setLength(0);
                return;
            }
        }
        var3_3.append((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void addLiteralToken(List<Token> tokenList, StringBuilder stringBuilder) {
        void var2_2;
        void var1_1;
        if (stringBuilder.length() == 0) {
            return;
        }
        var1_1.add(new Token(Token.Type.LITERAL, var2_2.toString()));
    }

    static enum TokenizerState {
        LITERAL_STATE,
        START_STATE,
        DEFAULT_VAL_STATE;

    }
}

