/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ViewStatusMessagesServletBase
extends HttpServlet {
    private static final long serialVersionUID = -3551928133801157219L;
    private static CachingDateFormatter SDF = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss");
    static String SUBMIT = "submit";
    static String CLEAR = "Clear";
    int count;

    protected abstract StatusManager getStatusManager(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract String getPageTitle(HttpServletRequest var1, HttpServletResponse var2);

    /*
     * WARNING - void declaration
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        void var1_1;
        void var2_2;
        this.count = 0;
        StatusManager sm = this.getStatusManager(req, resp);
        resp.setContentType("text/html");
        PrintWriter output = resp.getWriter();
        output.append("<html>\r\n");
        output.append("<head>\r\n");
        this.printCSS(req.getContextPath(), output);
        output.append("</head>\r\n");
        output.append("<body>\r\n");
        output.append(this.getPageTitle(req, (HttpServletResponse)var2_2));
        output.append("<form method=\"POST\">\r\n");
        output.append("<input type=\"submit\" name=\"" + SUBMIT + "\" value=\"" + CLEAR + "\">");
        output.append("</form>\r\n");
        if (CLEAR.equalsIgnoreCase(req.getParameter(SUBMIT))) {
            sm.clear();
            sm.add(new InfoStatus("Cleared all status messages", (Object)this));
        }
        output.append("<table>");
        StringBuilder buf = new StringBuilder();
        if (sm != null) {
            void var3_3;
            this.printList(buf, (StatusManager)var3_3);
        } else {
            output.append("Could not find status manager");
        }
        output.append((CharSequence)var1_1);
        output.append("</table>");
        output.append("</body>\r\n");
        output.append("</html>\r\n");
        output.flush();
        output.close();
    }

    /*
     * WARNING - void declaration
     */
    public void printCSS(String localRef, PrintWriter output) {
        void var2_2;
        output.append("  <STYLE TYPE=\"text/css\">\r\n");
        output.append("    .warn  { font-weight: bold; color: #FF6600;} \r\n");
        output.append("    .error { font-weight: bold; color: #CC0000;} \r\n");
        output.append("    table { margin-left: 2em; margin-right: 2em; border-left: 2px solid #AAA; }\r\n");
        output.append("    tr.even { background: #FFFFFF; }\r\n");
        output.append("    tr.odd  { background: #EAEAEA; }\r\n");
        output.append("    td { padding-right: 1ex; padding-left: 1ex; border-right: 2px solid #AAA; }\r\n");
        output.append("    td.date { text-align: right; font-family: courier, monospace; font-size: smaller; }");
        output.append(CoreConstants.LINE_SEPARATOR);
        output.append("  td.level { text-align: right; }");
        output.append(CoreConstants.LINE_SEPARATOR);
        output.append("    tr.header { background: #596ED5; color: #FFF; font-weight: bold; font-size: larger; }");
        output.append(CoreConstants.LINE_SEPARATOR);
        output.append("  td.exception { background: #A2AEE8; white-space: pre; font-family: courier, monospace;}");
        output.append(CoreConstants.LINE_SEPARATOR);
        var2_2.append("  </STYLE>\r\n");
    }

    /*
     * WARNING - void declaration
     */
    public void printList(StringBuilder buf, StatusManager sm) {
        void var1_1;
        Object object;
        buf.append("<table>\r\n");
        this.printHeader(buf);
        object = object.getCopyOfStatusList();
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            Status s = (Status)object.next();
            ++this.count;
            this.printStatus(buf, (Status)var3_3);
        }
        var1_1.append("</table>\r\n");
    }

    /*
     * WARNING - void declaration
     */
    public void printHeader(StringBuilder buf) {
        void var1_1;
        buf.append("  <tr class=\"header\">\r\n");
        buf.append("    <th>Date </th>\r\n");
        buf.append("    <th>Level</th>\r\n");
        buf.append("    <th>Origin</th>\r\n");
        buf.append("    <th>Message</th>\r\n");
        var1_1.append("  </tr>\r\n");
    }

    String statusLevelAsString(Status s) {
        switch (s.getEffectiveLevel()) {
            case 0: {
                return "INFO";
            }
            case 1: {
                return "<span class=\"warn\">WARN</span>";
            }
            case 2: {
                return "<span class=\"error\">ERROR</span>";
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    String abbreviatedOrigin(Status s) {
        void var1_1;
        Object o = s.getOrigin();
        if (o == null) {
            return null;
        }
        String fqClassName = o.getClass().getName();
        int lastIndex = fqClassName.lastIndexOf(46);
        if (lastIndex != -1) {
            void var2_2;
            return fqClassName.substring((int)(var2_2 + true), fqClassName.length());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void printStatus(StringBuilder buf, Status s) {
        void var3_3;
        String trClass = this.count % 2 == 0 ? "even" : "odd";
        buf.append("  <tr class=\"").append(trClass).append("\">\r\n");
        String dateStr = SDF.format(s.getTimestamp());
        buf.append("    <td class=\"date\">").append((String)var3_3).append("</td>\r\n");
        buf.append("    <td class=\"level\">").append(this.statusLevelAsString(s)).append("</td>\r\n");
        buf.append("    <td>").append(this.abbreviatedOrigin(s)).append("</td>\r\n");
        buf.append("    <td>").append(s.getMessage()).append("</td>\r\n");
        buf.append("  </tr>\r\n");
        if (s.getThrowable() != null) {
            void var2_2;
            void var1_1;
            this.printThrowable((StringBuilder)var1_1, var2_2.getThrowable());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void printThrowable(StringBuilder buf, Throwable t) {
        void var1_1;
        void var3_3;
        void var2_2;
        buf.append("  <tr>\r\n");
        buf.append("    <td colspan=\"4\" class=\"exception\"><pre>");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        var2_2.printStackTrace(pw);
        buf.append(Transform.escapeTags(var3_3.getBuffer()));
        buf.append("    </pre></td>\r\n");
        var1_1.append("  </tr>\r\n");
    }
}

