/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.WarnStatus;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StatusUtil {
    StatusManager sm;

    /*
     * WARNING - void declaration
     */
    public StatusUtil(StatusManager sm) {
        void var1_1;
        this.sm = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public StatusUtil(Context context) {
        void var1_1;
        this.sm = var1_1.getStatusManager();
    }

    public static boolean contextHasStatusListener(Context context) {
        List<StatusListener> list;
        List<StatusListener> sm = context.getStatusManager();
        if (sm == null) {
            return false;
        }
        List<StatusListener> listeners = sm.getCopyOfStatusListenerList();
        return listeners != null && list.size() != 0;
    }

    /*
     * WARNING - void declaration
     */
    public static List<Status> filterStatusListByTimeThreshold(List<Status> rawList, long threshold) {
        void var3_2;
        Iterator<Status> iterator;
        ArrayList<Status> filteredList = new ArrayList<Status>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Status s = (Status)iterator.next();
            if (s.getTimestamp() < threshold) continue;
            filteredList.add(s);
        }
        return var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public void addStatus(Status status) {
        if (this.sm != null) {
            void var1_1;
            this.sm.add((Status)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addInfo(Object caller, String msg) {
        void var1_1;
        void var2_2;
        this.addStatus(new InfoStatus((String)var2_2, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addWarn(Object caller, String msg) {
        void var1_1;
        void var2_2;
        this.addStatus(new WarnStatus((String)var2_2, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void addError(Object caller, String msg, Throwable t) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.addStatus(new ErrorStatus((String)var2_2, var1_1, (Throwable)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasXMLParsingErrors(long threshold) {
        void var1_1;
        return this.containsMatch((long)var1_1, 2, "XML_PARSING");
    }

    /*
     * WARNING - void declaration
     */
    public boolean noXMLParsingErrorsOccurred(long threshold) {
        void var1_1;
        return !this.hasXMLParsingErrors((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int getHighestLevel(long threshold) {
        void var2_3;
        Iterator iterator;
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), threshold);
        int maxLevel = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_4;
            Status s = (Status)iterator.next();
            if (s.getLevel() <= maxLevel) continue;
            maxLevel = var3_4.getLevel();
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isErrorFree(long threshold) {
        void var1_1;
        return this.getHighestLevel((long)var1_1) < 2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isWarningOrErrorFree(long threshold) {
        void var1_1;
        return 1 > this.getHighestLevel((long)var1_1);
    }

    public boolean containsMatch(long threshold, int level, String regex) {
        Iterator iterator;
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), threshold);
        Pattern p = Pattern.compile(regex);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String msg;
            Matcher matcher;
            Status status = (Status)iterator.next();
            if (level != status.getLevel() || !(matcher = p.matcher(msg = status.getMessage())).lookingAt()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsMatch(int level, String regex) {
        void var2_2;
        void var1_1;
        return this.containsMatch(0L, (int)var1_1, (String)var2_2);
    }

    public boolean containsMatch(String regex) {
        Pattern p = Pattern.compile(regex);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String string = status.getMessage();
            Matcher object = p.matcher(string);
            if (!object.lookingAt()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int levelCount(int level, long threshold) {
        void var3_4;
        Iterator iterator;
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), threshold);
        int count = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Status status = (Status)iterator.next();
            if (status.getLevel() != level) continue;
            ++count;
        }
        return (int)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public int matchCount(String regex) {
        void var2_2;
        int count = 0;
        Pattern p = Pattern.compile(regex);
        for (Status status : this.sm.getCopyOfStatusList()) {
            String string = status.getMessage();
            Matcher object = p.matcher(string);
            if (!object.lookingAt()) continue;
            ++count;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsException(Class<?> exceptionType) {
        void var1_1;
        return this.containsException((Class<?>)var1_1, null);
    }

    public boolean containsException(Class<?> exceptionType, String msgRegex) {
        for (Status status : this.sm.getCopyOfStatusList()) {
            for (Throwable t = status.getThrowable(); t != null; t = t.getCause()) {
                if (!t.getClass().getName().equals(exceptionType.getName())) continue;
                if (msgRegex == null) {
                    return true;
                }
                if (!this.checkRegexMatch(t.getMessage(), msgRegex)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkRegexMatch(String message, String msgRegex) {
        Matcher matcher;
        Pattern pattern = Pattern.compile(msgRegex);
        matcher = pattern.matcher((CharSequence)((Object)matcher));
        return matcher.lookingAt();
    }

    /*
     * WARNING - void declaration
     */
    public long timeOfLastReset() {
        List<Status> statusList = this.sm.getCopyOfStatusList();
        if (statusList == null) {
            return -1L;
        }
        int n = statusList.size();
        for (int i = n - 1; i >= 0; --i) {
            void var3_3;
            Status s = statusList.get(i);
            if (!"Will reset and reconfigure context ".equals(s.getMessage())) continue;
            return var3_3.getTimestamp();
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    public static String diff(Status left, Status right) {
        void var2_2;
        StringBuilder sb = new StringBuilder();
        if (left.getLevel() != right.getLevel()) {
            sb.append(" left.level ").append(left.getLevel()).append(" != right.level ").append(right.getLevel());
        }
        if (left.getTimestamp() != right.getTimestamp()) {
            sb.append(" left.timestamp ").append(left.getTimestamp()).append(" != right.timestamp ").append(right.getTimestamp());
        }
        if (!Objects.equals(left.getMessage(), right.getMessage())) {
            void var1_1;
            Status status;
            sb.append(" left.message ").append(status.getMessage()).append(" != right.message ").append(var1_1.getMessage());
        }
        return var2_2.toString();
    }
}

