/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class StatusBase
implements Status {
    private static final List<Status> EMPTY_LIST = new ArrayList<Status>(0);
    int level;
    final String message;
    final Object origin;
    List<Status> childrenList;
    Throwable throwable;
    long timestamp;

    /*
     * WARNING - void declaration
     */
    StatusBase(int level, String msg, Object origin) {
        this((int)var1_1, (String)var2_2, var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    StatusBase(int level, String msg, Object origin, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.level = var1_1;
        this.message = var2_2;
        this.origin = var3_3;
        this.throwable = t;
        this.timestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void add(Status child) {
        void var1_1;
        if (child == null) {
            throw new NullPointerException("Null values are not valid Status.");
        }
        if (this.childrenList == null) {
            this.childrenList = new ArrayList<Status>();
        }
        this.childrenList.add((Status)var1_1);
    }

    @Override
    public synchronized boolean hasChildren() {
        return this.childrenList != null && this.childrenList.size() > 0;
    }

    @Override
    public synchronized Iterator<Status> iterator() {
        if (this.childrenList != null) {
            return this.childrenList.iterator();
        }
        return EMPTY_LIST.iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean remove(Status statusToRemove) {
        void var1_1;
        if (this.childrenList == null) {
            return false;
        }
        return this.childrenList.remove(var1_1);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized int getEffectiveLevel() {
        void var1_1;
        int result = this.level;
        Iterator<Status> it = this.iterator();
        while (it.hasNext()) {
            void var2_3;
            Status status = it.next();
            int effLevel = status.getEffectiveLevel();
            if (effLevel <= result) continue;
            result = var2_3;
        }
        return (int)var1_1;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Object getOrigin() {
        return this.origin;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buf = new StringBuilder();
        switch (this.getEffectiveLevel()) {
            case 0: {
                buf.append("INFO");
                break;
            }
            case 1: {
                buf.append("WARN");
                break;
            }
            case 2: {
                buf.append("ERROR");
            }
        }
        if (this.origin != null) {
            buf.append(" in ");
            buf.append(this.origin);
            buf.append(" -");
        }
        buf.append(" ");
        buf.append(this.message);
        if (this.throwable != null) {
            buf.append(" ");
            buf.append(this.throwable);
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusBase that = (StatusBase)o;
        return this.level == that.level && this.timestamp == that.timestamp && Objects.equals(this.message, var1_1.message);
    }

    public int hashCode() {
        return Objects.hash(this.level, this.message, this.timestamp);
    }
}

