/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.PrintStream;
import java.util.Iterator;

public abstract class OnPrintStreamStatusListenerBase
extends ContextAwareBase
implements LifeCycle,
StatusListener {
    boolean isStarted = false;
    static final long DEFAULT_RETROSPECTIVE = 300L;
    long retrospectiveThresold = 300L;
    boolean resetResistant = false;
    String prefix;

    protected abstract PrintStream getPrintStream();

    /*
     * WARNING - void declaration
     */
    private void print(Status status) {
        void var2_2;
        void var1_1;
        StringBuilder sb = new StringBuilder();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        StatusPrinter.buildStr(sb, "", (Status)var1_1);
        this.getPrintStream().print(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addStatusEvent(Status status) {
        void var1_1;
        if (!this.isStarted) {
            return;
        }
        this.print((Status)var1_1);
    }

    private void retrospectivePrint() {
        if (this.context == null) {
            return;
        }
        long now = System.currentTimeMillis();
        Iterator<Status> iterator = this.context.getStatusManager();
        iterator = iterator.getCopyOfStatusList();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Status status = iterator.next();
            long timestampOfStatusMesage = status.getTimestamp();
            if (!this.isElapsedTimeLongerThanThreshold(now, timestampOfStatusMesage)) continue;
            this.print(status);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isElapsedTimeLongerThanThreshold(long now, long timestamp) {
        void var3_2;
        long l = now - var3_2;
        return l < this.retrospectiveThresold;
    }

    @Override
    public void start() {
        this.isStarted = true;
        if (this.retrospectiveThresold > 0L) {
            this.retrospectivePrint();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrefix(String prefix) {
        void var1_1;
        this.prefix = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRetrospective(long retrospective) {
        void var1_1;
        this.retrospectiveThresold = var1_1;
    }

    public long getRetrospective() {
        return this.retrospectiveThresold;
    }

    @Override
    public void stop() {
        this.isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public boolean isResetResistant() {
        return this.resetResistant;
    }

    /*
     * WARNING - void declaration
     */
    public void setResetResistant(boolean resetResistant) {
        void var1_1;
        this.resetResistant = var1_1;
    }
}

