/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.helper.PeriodicityType;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class RollingCalendar
extends GregorianCalendar {
    private static final long serialVersionUID = -5937537740925066161L;
    static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    PeriodicityType periodicityType = PeriodicityType.ERRONEOUS;
    String datePattern;

    /*
     * WARNING - void declaration
     */
    public RollingCalendar(String datePattern) {
        void var1_1;
        this.datePattern = var1_1;
        this.periodicityType = this.computePeriodicityType();
    }

    /*
     * WARNING - void declaration
     */
    public RollingCalendar(String datePattern, TimeZone tz, Locale locale) {
        super((TimeZone)var2_2, (Locale)var3_3);
        void var1_1;
        void var3_3;
        void var2_2;
        this.datePattern = var1_1;
        this.periodicityType = this.computePeriodicityType();
    }

    public PeriodicityType getPeriodicityType() {
        return this.periodicityType;
    }

    public PeriodicityType computePeriodicityType() {
        GregorianCalendar calendar = new GregorianCalendar(GMT_TIMEZONE, Locale.getDefault());
        Instant epoch = Instant.ofEpochMilli(0L);
        ZoneId gmtZone = ZoneId.of("UTC");
        if (this.datePattern != null) {
            PeriodicityType[] periodicityTypeArray = PeriodicityType.VALID_ORDERED_LIST;
            int n = PeriodicityType.VALID_ORDERED_LIST.length;
            for (int i = 0; i < n; ++i) {
                PeriodicityType i2 = periodicityTypeArray[i];
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern(this.datePattern).withZone(gmtZone);
                String r0 = dtf.format(epoch);
                Instant next = RollingCalendar.innerGetEndOfThisPeriod(calendar, i2, epoch);
                String r1 = dtf.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i2;
            }
        }
        return PeriodicityType.ERRONEOUS;
    }

    public boolean isCollisionFree() {
        switch (this.periodicityType) {
            case TOP_OF_HOUR: {
                return !this.collision(43200000L);
            }
            case TOP_OF_DAY: {
                if (this.collision(604800000L)) {
                    return false;
                }
                if (this.collision(2678400000L)) {
                    return false;
                }
                return !this.collision(31536000000L);
            }
            case TOP_OF_WEEK: {
                if (this.collision(2937600000L)) {
                    return false;
                }
                return !this.collision(31622400000L);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean collision(long delta) {
        void var1_2;
        void var3_3;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
        simpleDateFormat.setTimeZone(GMT_TIMEZONE);
        Date epoch0 = new Date(0L);
        String r0 = simpleDateFormat.format(epoch0);
        Date epoch12 = new Date(delta);
        String r12 = var3_3.format(epoch12);
        return r0.equals(var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public void printPeriodicity(ContextAwareBase cab) {
        void var1_1;
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                cab.addInfo("Roll-over every millisecond.");
                return;
            }
            case TOP_OF_SECOND: {
                cab.addInfo("Roll-over every second.");
                return;
            }
            case TOP_OF_MINUTE: {
                cab.addInfo("Roll-over every minute.");
                return;
            }
            case TOP_OF_HOUR: {
                cab.addInfo("Roll-over at the top of every hour.");
                return;
            }
            case HALF_DAY: {
                cab.addInfo("Roll-over at midday and midnight.");
                return;
            }
            case TOP_OF_DAY: {
                cab.addInfo("Roll-over at midnight.");
                return;
            }
            case TOP_OF_WEEK: {
                cab.addInfo("Rollover at the start of week.");
                return;
            }
            case TOP_OF_MONTH: {
                cab.addInfo("Rollover at start of every month.");
                return;
            }
        }
        var1_1.addInfo("Unknown periodicity.");
    }

    /*
     * WARNING - void declaration
     */
    public long periodBarriersCrossed(long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException("Start cannot come before end");
        }
        long startFloored = this.getStartOfCurrentPeriodWithGMTOffsetCorrection(start, this.getTimeZone());
        long l = this.getStartOfCurrentPeriodWithGMTOffsetCorrection(end, this.getTimeZone());
        long diff = l - startFloored;
        switch (this.periodicityType) {
            case TOP_OF_MILLISECOND: {
                return diff;
            }
            case TOP_OF_SECOND: {
                return diff / 1000L;
            }
            case TOP_OF_MINUTE: {
                return diff / 60000L;
            }
            case TOP_OF_HOUR: {
                return diff / 3600000L;
            }
            case TOP_OF_DAY: {
                return diff / 86400000L;
            }
            case TOP_OF_WEEK: {
                return diff / 604800000L;
            }
            case TOP_OF_MONTH: {
                void var3_2;
                void var1_1;
                return RollingCalendar.diffInMonths((long)var1_1, (long)var3_2);
            }
        }
        throw new IllegalStateException("Unknown periodicity type.");
    }

    /*
     * WARNING - void declaration
     */
    public static int diffInMonths(long startTime, long endTime) {
        void var0_2;
        void var1_5;
        void var2_3;
        if (startTime > endTime) {
            throw new IllegalArgumentException("startTime cannot be larger than endTime");
        }
        Calendar startCal = Calendar.getInstance();
        startCal.setTimeInMillis(startTime);
        Calendar endCal = Calendar.getInstance();
        endCal.setTimeInMillis((long)var2_3);
        int yearDiff = endCal.get(1) - startCal.get(1);
        int monthDiff = endCal.get(2) - startCal.get(2);
        return (int)(var1_5 * 12 + var0_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Instant innerGetEndOfThisPeriod(Calendar cal, PeriodicityType periodicityType, Instant instant) {
        void var2_2;
        void var1_1;
        return RollingCalendar.innerGetEndOfNextNthPeriod(cal, (PeriodicityType)var1_1, (Instant)var2_2, 1);
    }

    /*
     * WARNING - void declaration
     */
    private static Instant innerGetEndOfNextNthPeriod(Calendar cal, PeriodicityType periodicityType, Instant instant, int numPeriods) {
        Calendar calendar;
        void var1_1;
        void var2_2;
        cal.setTimeInMillis(var2_2.toEpochMilli());
        switch (1.$SwitchMap$ch$qos$logback$core$rolling$helper$PeriodicityType[var1_1.ordinal()]) {
            case 4: {
                cal.add(14, numPeriods);
                break;
            }
            case 5: {
                cal.set(14, 0);
                cal.add(13, numPeriods);
                break;
            }
            case 6: {
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(12, numPeriods);
                break;
            }
            case 1: {
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(11, numPeriods);
                break;
            }
            case 2: {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(5, numPeriods);
                break;
            }
            case 3: {
                cal.set(7, cal.getFirstDayOfWeek());
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(3, numPeriods);
                break;
            }
            case 8: {
                void var3_3;
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(2, (int)var3_3);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown periodicity type.");
            }
        }
        return Instant.ofEpochMilli(calendar.getTimeInMillis());
    }

    /*
     * WARNING - void declaration
     */
    public Instant getEndOfNextNthPeriod(Instant instant, int periods) {
        void var2_2;
        void var1_1;
        RollingCalendar rollingCalendar = this;
        return RollingCalendar.innerGetEndOfNextNthPeriod(rollingCalendar, rollingCalendar.periodicityType, (Instant)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Instant getNextTriggeringDate(Instant instant) {
        void var1_1;
        return this.getEndOfNextNthPeriod((Instant)var1_1, 1);
    }

    /*
     * WARNING - void declaration
     */
    public long getStartOfCurrentPeriodWithGMTOffsetCorrection(long now, TimeZone timezone) {
        void var1_2;
        void var3_3;
        Calendar aCal = Calendar.getInstance(timezone);
        aCal.setTimeInMillis(now);
        Instant instant = Instant.ofEpochMilli(aCal.getTimeInMillis());
        Instant toppedInstant = this.getEndOfNextNthPeriod(instant, 0);
        Calendar secondCalendar = Calendar.getInstance((TimeZone)var3_3);
        secondCalendar.setTimeInMillis(toppedInstant.toEpochMilli());
        long gmtOffset = secondCalendar.get(15) + secondCalendar.get(16);
        return var1_2.toEpochMilli() + gmtOffset;
    }
}

