/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling.helper;

import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.FileStoreUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;

public class RenameUtil
extends ContextAwareBase {
    static String RENAMING_ERROR_URL = "http://logback.qos.ch/codes.html#renamingError";

    /*
     * WARNING - void declaration
     */
    public void rename(String src, String target) throws RolloverFailure {
        void var1_1;
        if (src.equals(target)) {
            this.addWarn("Source and target files are the same [" + src + "]. Skipping.");
            return;
        }
        File srcFile = new File(src);
        if (srcFile.exists()) {
            File targetFile = new File(target);
            this.createMissingTargetDirsIfNecessary(targetFile);
            this.addInfo("Renaming file [" + srcFile + "] to [" + targetFile + "]");
            boolean bl = srcFile.renameTo(targetFile);
            if (!bl) {
                void var3_3;
                this.addWarn("Failed to rename file [" + srcFile + "] as [" + targetFile + "].");
                Boolean areOnDifferentVolumes = this.areOnDifferentVolumes(srcFile, targetFile);
                if (Boolean.TRUE.equals(var3_3)) {
                    void var2_2;
                    this.addWarn("Detected different file systems for source [" + src + "] and target [" + target + "]. Attempting rename by copying.");
                    this.renameByCopying(src, (String)var2_2);
                    return;
                }
                this.addWarn("Please consider leaving the [file] option of " + RollingFileAppender.class.getSimpleName() + " empty.");
                this.addWarn("See also " + RENAMING_ERROR_URL);
            }
            return;
        }
        throw new RolloverFailure("File [" + (String)var1_1 + "] does not exist.");
    }

    /*
     * WARNING - void declaration
     */
    Boolean areOnDifferentVolumes(File srcFile2, File targetFile) throws RolloverFailure {
        if (!EnvUtil.isJDK7OrHigher()) {
            return Boolean.FALSE;
        }
        File parentOfTarget = targetFile.getAbsoluteFile().getParentFile();
        if (parentOfTarget == null) {
            this.addWarn("Parent of target file [" + targetFile + "] is null");
            return null;
        }
        if (!parentOfTarget.exists()) {
            void var2_4;
            this.addWarn("Parent of target file [" + var2_4 + "] does not exist");
            return null;
        }
        try {
            void var3_5;
            boolean srcFile2 = FileStoreUtil.areOnSameFileStore(srcFile2, (File)var3_5);
            return !srcFile2;
        }
        catch (RolloverFailure rf) {
            void var1_3;
            this.addWarn("Error while checking file store equality", (Throwable)var1_3);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void renameByCopying(String src, String target) throws RolloverFailure {
        File file;
        FileUtil fileUtil = new FileUtil(this.getContext());
        fileUtil.copy(src, (String)((Object)file));
        file = new File(src);
        if (!file.delete()) {
            void var1_1;
            this.addWarn("Could not delete " + (String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    void createMissingTargetDirsIfNecessary(File toFile) throws RolloverFailure {
        boolean bl = FileUtil.createMissingParentDirectories(toFile);
        if (!bl) {
            void var1_1;
            throw new RolloverFailure("Failed to create parent directories for [" + var1_1.getAbsolutePath() + "]");
        }
    }

    public String toString() {
        return "c.q.l.co.rolling.helper.RenameUtil";
    }
}

