/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.joran.spi.NoAutoStart;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicyBase;
import ch.qos.logback.core.rolling.helper.ArchiveRemover;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.FileFilterUtil;
import ch.qos.logback.core.rolling.helper.SizeAndTimeBasedArchiveRemover;
import ch.qos.logback.core.util.Duration;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.InvocationGate;
import ch.qos.logback.core.util.SimpleInvocationGate;
import java.io.File;
import java.time.Instant;

@NoAutoStart
public class SizeAndTimeBasedFNATP<E>
extends TimeBasedFileNamingAndTriggeringPolicyBase<E> {
    volatile int currentPeriodsCounter = 0;
    FileSize maxFileSize;
    Duration checkIncrement = null;
    static String MISSING_INT_TOKEN = "Missing integer token, that is %i, in FileNamePattern [";
    static String MISSING_DATE_TOKEN = "Missing date token, that is %d, in FileNamePattern [";
    private final Usage usage;
    InvocationGate invocationGate = new SimpleInvocationGate();

    public SizeAndTimeBasedFNATP() {
        this(Usage.DIRECT);
    }

    /*
     * WARNING - void declaration
     */
    public SizeAndTimeBasedFNATP(Usage usage) {
        void var1_1;
        this.usage = var1_1;
    }

    @Override
    public void start() {
        super.start();
        if (this.usage == Usage.DIRECT) {
            this.addWarn("SizeAndTimeBasedFNATP is deprecated. Use SizeAndTimeBasedRollingPolicy instead");
            this.addWarn("For more information see http://logback.qos.ch/manual/appenders.html#SizeAndTimeBasedRollingPolicy");
        }
        if (!super.isErrorFree()) {
            return;
        }
        if (this.maxFileSize == null) {
            this.addError("maxFileSize property is mandatory.");
            this.withErrors();
        }
        if (this.checkIncrement != null) {
            this.invocationGate = new SimpleInvocationGate(this.checkIncrement);
        }
        if (!this.validateDateAndIntegerTokens()) {
            this.withErrors();
            return;
        }
        this.archiveRemover = this.createArchiveRemover();
        this.archiveRemover.setContext(this.context);
        String string = this.tbrp.fileNamePattern.toRegexForFixedDate(this.dateInCurrentPeriod);
        String stemRegex = FileFilterUtil.afterLastSlash(string);
        this.computeCurrentPeriodsHighestCounterValue(string);
        if (this.isErrorFree()) {
            this.started = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean validateDateAndIntegerTokens() {
        void var1_1;
        boolean inError = false;
        if (this.tbrp.fileNamePattern.getIntegerTokenConverter() == null) {
            inError = true;
            this.addError(MISSING_INT_TOKEN + this.tbrp.fileNamePatternStr + "]");
            this.addError("See also http://logback.qos.ch/codes.html#sat_missing_integer_token");
        }
        if (this.tbrp.fileNamePattern.getPrimaryDateTokenConverter() == null) {
            inError = true;
            this.addError(MISSING_DATE_TOKEN + this.tbrp.fileNamePatternStr + "]");
        }
        return var1_1 == false;
    }

    protected ArchiveRemover createArchiveRemover() {
        return new SizeAndTimeBasedArchiveRemover(this.tbrp.fileNamePattern, this.rc);
    }

    /*
     * WARNING - void declaration
     */
    void computeCurrentPeriodsHighestCounterValue(String stemRegex) {
        void var1_1;
        File file = new File(((TimeBasedFileNamingAndTriggeringPolicyBase)this).getCurrentPeriodsFileNameWithoutCompressionSuffix());
        File[] matchingFileArray = FileFilterUtil.filesInFolderMatchingStemRegex(file = file.getParentFile(), stemRegex);
        if (matchingFileArray == null || matchingFileArray.length == 0) {
            this.currentPeriodsCounter = 0;
            return;
        }
        this.currentPeriodsCounter = FileFilterUtil.findHighestCounter((File[])file, (String)var1_1);
        if (this.tbrp.getParentsRawFileProperty() != null || this.tbrp.compressionMode != CompressionMode.NONE) {
            ++this.currentPeriodsCounter;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isTriggeringEvent(File activeFile, E event) {
        void var3_3;
        void var1_1;
        long localNextCheck;
        long currentTime = this.getCurrentTime();
        if (currentTime >= (localNextCheck = this.atomicNextCheck.get())) {
            long nextCheckCandidate = this.computeNextCheck(currentTime);
            this.atomicNextCheck.set(nextCheckCandidate);
            Instant instantInElapsedPeriod = this.dateInCurrentPeriod;
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(var1_1, this.currentPeriodsCounter);
            this.currentPeriodsCounter = 0;
            this.setDateInCurrentPeriod(currentTime);
            return true;
        }
        return this.checkSizeBasedTrigger((File)var1_1, (long)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkSizeBasedTrigger(File activeFile, long currentTime) {
        void var1_1;
        void var2_2;
        if (this.invocationGate.isTooSoon((long)var2_2)) {
            return false;
        }
        if (activeFile == null) {
            this.addWarn("activeFile == null");
            return false;
        }
        if (this.maxFileSize == null) {
            this.addWarn("maxFileSize = null");
            return false;
        }
        if (var1_1.length() >= this.maxFileSize.getSize()) {
            this.elapsedPeriodsFileName = this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
            ++this.currentPeriodsCounter;
            return true;
        }
        return false;
    }

    public Duration getCheckIncrement() {
        return this.checkIncrement;
    }

    /*
     * WARNING - void declaration
     */
    public void setCheckIncrement(Duration checkIncrement) {
        void var1_1;
        this.checkIncrement = var1_1;
    }

    @Override
    public String getCurrentPeriodsFileNameWithoutCompressionSuffix() {
        return this.tbrp.fileNamePatternWithoutCompSuffix.convertMultipleArguments(this.dateInCurrentPeriod, this.currentPeriodsCounter);
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxFileSize(FileSize aMaxFileSize) {
        void var1_1;
        this.maxFileSize = var1_1;
    }

    static enum Usage {
        EMBEDDED,
        DIRECT;

    }
}

