/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import ch.qos.logback.core.util.ContextUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RollingFileAppender<E>
extends FileAppender<E> {
    File currentlyActiveFile;
    TriggeringPolicy<E> triggeringPolicy;
    RollingPolicy rollingPolicy;
    Lock triggeringPolicyLock = new ReentrantLock();
    private static String RFA_NO_TP_URL = "http://logback.qos.ch/codes.html#rfa_no_tp";
    private static String RFA_NO_RP_URL = "http://logback.qos.ch/codes.html#rfa_no_rp";
    private static String COLLISION_URL = "http://logback.qos.ch/codes.html#rfa_collision";
    private static String RFA_LATE_FILE_URL = "http://logback.qos.ch/codes.html#rfa_file_after";

    @Override
    public void start() {
        if (this.triggeringPolicy == null) {
            this.addWarn("No TriggeringPolicy was set for the RollingFileAppender named " + this.getName());
            this.addWarn("For more information, please visit " + RFA_NO_TP_URL);
            return;
        }
        if (!this.triggeringPolicy.isStarted()) {
            this.addWarn("TriggeringPolicy has not started. RollingFileAppender will not start");
            return;
        }
        if (this.checkForCollisionsInPreviousRollingFileAppenders()) {
            this.addError("Collisions detected with FileAppender/RollingAppender instances defined earlier. Aborting.");
            this.addError("For more information, please visit " + COLLISION_WITH_EARLIER_APPENDER_URL);
            return;
        }
        if (!this.append) {
            this.addWarn("Append mode is mandatory for RollingFileAppender. Defaulting to append=true.");
            this.append = true;
        }
        if (this.rollingPolicy == null) {
            this.addError("No RollingPolicy was set for the RollingFileAppender named " + this.getName());
            this.addError("For more information, please visit " + RFA_NO_RP_URL);
            return;
        }
        if (this.checkForFileAndPatternCollisions()) {
            this.addError("File property collides with fileNamePattern. Aborting.");
            this.addError("For more information, please visit " + COLLISION_URL);
            return;
        }
        if (this.isPrudent()) {
            if (this.rawFileProperty() != null) {
                this.addWarn("Setting \"File\" property to null on account of prudent mode");
                ((FileAppender)this).setFile(null);
            }
            if (this.rollingPolicy.getCompressionMode() != CompressionMode.NONE) {
                this.addError("Compression is not supported in prudent mode. Aborting");
                return;
            }
        }
        this.currentlyActiveFile = new File(((FileAppender)this).getFile());
        this.addInfo("Active log file name: " + ((FileAppender)this).getFile());
        super.start();
    }

    private boolean checkForFileAndPatternCollisions() {
        if (this.triggeringPolicy instanceof RollingPolicyBase) {
            RollingPolicyBase rollingPolicyBase = (RollingPolicyBase)((Object)this.triggeringPolicy);
            FileNamePattern fileNamePattern = rollingPolicyBase.fileNamePattern;
            if (fileNamePattern != null && this.fileName != null) {
                String regex = fileNamePattern.toRegex();
                return this.fileName.matches((String)((Object)rollingPolicyBase));
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkForCollisionsInPreviousRollingFileAppenders() {
        void var1_1;
        boolean collisionResult = false;
        if (this.triggeringPolicy instanceof RollingPolicyBase) {
            RollingPolicyBase rollingPolicyBase = (RollingPolicyBase)((Object)this.triggeringPolicy);
            FileNamePattern fileNamePattern = rollingPolicyBase.fileNamePattern;
            boolean bl = this.innerCheckForFileNamePatternCollisionInPreviousRFA((FileNamePattern)((Object)rollingPolicyBase));
            if (bl) {
                collisionResult = true;
            }
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean innerCheckForFileNamePatternCollisionInPreviousRFA(FileNamePattern fileNamePattern) {
        void var2_2;
        boolean collisionsDetected = false;
        Map map = (Map)this.context.getObject("RFA_FILENAME_PATTERN_COLLISION_MAP");
        if (map == null) {
            return false;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!fileNamePattern.equals(entry.getValue())) continue;
            this.addErrorForCollision("FileNamePattern", ((FileNamePattern)entry.getValue()).toString(), (String)entry.getKey());
            collisionsDetected = true;
        }
        if (this.name != null) {
            void var1_1;
            void var3_3;
            var3_3.put(this.getName(), var1_1);
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void stop() {
        Map<String, FileNamePattern> map;
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        if (this.rollingPolicy != null) {
            this.rollingPolicy.stop();
        }
        if (this.triggeringPolicy != null) {
            this.triggeringPolicy.stop();
        }
        if ((map = ContextUtil.getFilenamePatternCollisionMap(this.context)) != null && this.getName() != null) {
            void var1_1;
            var1_1.remove(this.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setFile(String file) {
        void var1_1;
        if (file != null && (this.triggeringPolicy != null || this.rollingPolicy != null)) {
            this.addError("File property must be set before any triggeringPolicy or rollingPolicy properties");
            this.addError("For more information, please visit " + RFA_LATE_FILE_URL);
        }
        super.setFile((String)var1_1);
    }

    @Override
    public String getFile() {
        return this.rollingPolicy.getActiveFileName();
    }

    public void rollover() {
        this.streamWriteLock.lock();
        try {
            this.closeOutputStream();
            this.attemptRollover();
            this.attemptOpenFile();
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void attemptOpenFile() {
        try {
            this.currentlyActiveFile = new File(this.rollingPolicy.getActiveFileName());
            RollingFileAppender rollingFileAppender = this;
            rollingFileAppender.openFile(rollingFileAppender.rollingPolicy.getActiveFileName());
            return;
        }
        catch (IOException e) {
            void var1_1;
            this.addError("setFile(" + this.fileName + ", false) call failed.", (Throwable)var1_1);
            return;
        }
    }

    private void attemptRollover() {
        try {
            this.rollingPolicy.rollover();
            return;
        }
        catch (RolloverFailure rolloverFailure) {
            this.addWarn("RolloverFailure occurred. Deferring roll-over.");
            this.append = true;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void subAppend(E event) {
        void var1_1;
        this.triggeringPolicyLock.lock();
        try {
            if (this.triggeringPolicy.isTriggeringEvent(this.currentlyActiveFile, event)) {
                this.rollover();
            }
        }
        finally {
            this.triggeringPolicyLock.unlock();
        }
        super.subAppend(var1_1);
    }

    public RollingPolicy getRollingPolicy() {
        return this.rollingPolicy;
    }

    public TriggeringPolicy<E> getTriggeringPolicy() {
        return this.triggeringPolicy;
    }

    /*
     * WARNING - void declaration
     */
    public void setRollingPolicy(RollingPolicy policy) {
        this.rollingPolicy = policy;
        if (this.rollingPolicy instanceof TriggeringPolicy) {
            void var1_1;
            this.triggeringPolicy = (TriggeringPolicy)var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setTriggeringPolicy(TriggeringPolicy<E> policy) {
        this.triggeringPolicy = policy;
        if (policy instanceof RollingPolicy) {
            void var1_1;
            this.rollingPolicy = (RollingPolicy)var1_1;
        }
    }
}

