/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.recovery.RecoveryCoordinator;
import ch.qos.logback.core.recovery.RecoveryListener;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class ResilientOutputStreamBase
extends OutputStream {
    static final int STATUS_COUNT_LIMIT = 8;
    private int noContextWarning = 0;
    private int statusCount = 0;
    private Context context;
    private RecoveryCoordinator recoveryCoordinator;
    protected OutputStream os;
    protected boolean presumedClean = true;
    List<RecoveryListener> recoveryListeners = new ArrayList<RecoveryListener>(0);

    private boolean isPresumedInError() {
        return this.recoveryCoordinator != null && !this.presumedClean;
    }

    /*
     * WARNING - void declaration
     */
    public void addRecoveryListener(RecoveryListener listener) {
        void var1_1;
        this.recoveryListeners.add((RecoveryListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeRecoveryListener(RecoveryListener listener) {
        void var1_1;
        this.recoveryListeners.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b, int off, int len) {
        if (this.isPresumedInError()) {
            if (!this.recoveryCoordinator.isTooSoon()) {
                this.attemptRecovery();
            }
            return;
        }
        try {
            void var3_4;
            void var2_3;
            this.os.write(b, (int)var2_3, (int)var3_4);
            this.postSuccessfulWrite();
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.postIOFailure((IOException)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int b) {
        if (this.isPresumedInError()) {
            if (!this.recoveryCoordinator.isTooSoon()) {
                this.attemptRecovery();
            }
            return;
        }
        try {
            this.os.write(b);
            this.postSuccessfulWrite();
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.postIOFailure((IOException)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void flush() {
        if (this.os != null) {
            try {
                this.os.flush();
                this.postSuccessfulWrite();
                return;
            }
            catch (IOException e) {
                void var1_1;
                this.postIOFailure((IOException)var1_1);
            }
        }
    }

    abstract String getDescription();

    abstract OutputStream openNewOutputStream() throws IOException;

    private void postSuccessfulWrite() {
        if (this.recoveryCoordinator != null) {
            this.recoveryCoordinator = null;
            this.statusCount = 0;
            this.recoveryListeners.forEach(listener -> listener.recoveryOccured());
            this.addStatus(new InfoStatus("Recovered from IO failure on " + this.getDescription(), this));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void postIOFailure(IOException e) {
        this.addStatusIfCountNotOverLimit(new ErrorStatus("IO failure while writing to " + this.getDescription(), this, e));
        this.presumedClean = false;
        if (this.recoveryCoordinator == null) {
            void var1_1;
            this.recoveryCoordinator = new RecoveryCoordinator();
            this.recoveryListeners.forEach(arg_0 -> ResilientOutputStreamBase.lambda$postIOFailure$1((IOException)var1_1, arg_0));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    void attemptRecovery() {
        try {
            this.close();
        }
        catch (IOException iOException) {}
        this.addStatusIfCountNotOverLimit(new InfoStatus("Attempting to recover from IO failure on " + this.getDescription(), this));
        try {
            this.os = this.openNewOutputStream();
            this.presumedClean = true;
            return;
        }
        catch (IOException e) {
            void var1_1;
            this.addStatusIfCountNotOverLimit(new ErrorStatus("Failed to open " + this.getDescription(), this, (Throwable)var1_1));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addStatusIfCountNotOverLimit(Status s) {
        ++this.statusCount;
        if (this.statusCount < 8) {
            this.addStatus(s);
        }
        if (this.statusCount == 8) {
            void var1_1;
            this.addStatus((Status)var1_1);
            this.addStatus(new InfoStatus("Will supress future messages regarding " + this.getDescription(), this));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addStatus(Status status) {
        if (this.context == null) {
            if (this.noContextWarning++ == 0) {
                System.out.println("LOGBACK: No context given for " + this);
            }
            return;
        }
        StatusManager sm = this.context.getStatusManager();
        if (sm != null) {
            void var1_1;
            void var2_2;
            var2_2.add((Status)var1_1);
        }
    }

    public Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public void setContext(Context context) {
        void var1_1;
        this.context = var1_1;
    }

    private static /* synthetic */ void lambda$postIOFailure$1(IOException e, RecoveryListener listener) {
        IOException iOException;
        listener.newFailure(iOException);
    }
}

