/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.OptionTokenizer;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.pattern.util.RestrictedEscapeUtil;
import ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;

class TokenStream {
    final String pattern;
    final int patternLength;
    final IEscapeUtil escapeUtil;
    final IEscapeUtil optionEscapeUtil = new RestrictedEscapeUtil();
    TokenizerState state = TokenizerState.LITERAL_STATE;
    int pointer = 0;

    /*
     * WARNING - void declaration
     */
    TokenStream(String pattern) {
        this((String)var1_1, new RegularEscapeUtil());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    TokenStream(String pattern, IEscapeUtil escapeUtil) {
        void var2_2;
        void var1_1;
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("null or empty pattern string not allowed");
        }
        this.pattern = pattern;
        this.patternLength = var1_1.length();
        this.escapeUtil = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    List<Token> tokenize() throws ScanException {
        void var1_1;
        ArrayList<Token> tokenList = new ArrayList<Token>();
        StringBuffer buf = new StringBuffer();
        while (this.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state.ordinal()) {
                case 0: {
                    this.handleLiteralState(c, tokenList, buf);
                    break;
                }
                case 1: {
                    this.handleFormatModifierState(c, tokenList, buf);
                    break;
                }
                case 3: {
                    this.processOption(c, tokenList, buf);
                    break;
                }
                case 2: {
                    this.handleKeywordState(c, tokenList, buf);
                    break;
                }
                case 4: {
                    void var3_3;
                    this.handleRightParenthesisState((char)var3_3, tokenList, buf);
                }
            }
        }
        switch (this.state.ordinal()) {
            case 0: {
                this.addValuedToken(1000, buf, tokenList);
                break;
            }
            case 2: {
                void var2_2;
                tokenList.add(new Token(1004, var2_2.toString()));
                break;
            }
            case 4: {
                tokenList.add(Token.RIGHT_PARENTHESIS_TOKEN);
                break;
            }
            case 1: 
            case 3: {
                throw new ScanException("Unexpected end of pattern string");
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void handleRightParenthesisState(char c, List<Token> tokenList, StringBuffer buf) {
        void var1_1;
        void var3_3;
        tokenList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        switch (c) {
            case ')': {
                return;
            }
            case '{': {
                this.state = TokenizerState.OPTION_STATE;
                return;
            }
            case '\\': {
                this.escape("%{}", buf);
                this.state = TokenizerState.LITERAL_STATE;
                return;
            }
        }
        var3_3.append((char)var1_1);
        this.state = TokenizerState.LITERAL_STATE;
    }

    /*
     * WARNING - void declaration
     */
    private void processOption(char c, List<Token> tokenList, StringBuffer buf) throws ScanException {
        void var2_2;
        void var1_1;
        OptionTokenizer optionTokenizer = new OptionTokenizer(this);
        optionTokenizer.tokenize((char)var1_1, (List<Token>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void handleFormatModifierState(char c, List<Token> tokenList, StringBuffer buf) {
        void var1_1;
        void var3_3;
        if (c == '(') {
            this.addValuedToken(1002, buf, tokenList);
            tokenList.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
            this.state = TokenizerState.LITERAL_STATE;
            return;
        }
        if (Character.isJavaIdentifierStart(c)) {
            void var2_2;
            this.addValuedToken(1002, buf, (List<Token>)var2_2);
            this.state = TokenizerState.KEYWORD_STATE;
            buf.append(c);
            return;
        }
        var3_3.append((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void handleLiteralState(char c, List<Token> tokenList, StringBuffer buf) {
        void var1_1;
        void var3_3;
        switch (c) {
            case '\\': {
                this.escape("%()", buf);
                return;
            }
            case '%': {
                this.addValuedToken(1000, buf, tokenList);
                tokenList.add(Token.PERCENT_TOKEN);
                this.state = TokenizerState.FORMAT_MODIFIER_STATE;
                return;
            }
            case ')': {
                void var2_2;
                this.addValuedToken(1000, buf, (List<Token>)var2_2);
                this.state = TokenizerState.RIGHT_PARENTHESIS_STATE;
                return;
            }
        }
        var3_3.append((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void handleKeywordState(char c, List<Token> tokenList, StringBuffer buf) {
        if (Character.isJavaIdentifierPart(c)) {
            buf.append(c);
            return;
        }
        if (c == '{') {
            this.addValuedToken(1004, buf, tokenList);
            this.state = TokenizerState.OPTION_STATE;
            return;
        }
        if (c == '(') {
            this.addValuedToken(1005, buf, tokenList);
        } else {
            void var1_1;
            void var2_2;
            if (c == '%') {
                this.addValuedToken(1004, buf, tokenList);
                tokenList.add(Token.PERCENT_TOKEN);
                this.state = TokenizerState.FORMAT_MODIFIER_STATE;
                return;
            }
            if (c == ')') {
                this.addValuedToken(1004, buf, tokenList);
                this.state = TokenizerState.RIGHT_PARENTHESIS_STATE;
                return;
            }
            this.addValuedToken(1004, buf, (List<Token>)var2_2);
            if (c == '\\') {
                if (this.pointer < this.patternLength) {
                    char next = this.pattern.charAt(this.pointer++);
                    this.escapeUtil.escape("%()", buf, (char)var1_1, this.pointer);
                }
            } else {
                void var3_3;
                var3_3.append((char)var1_1);
            }
        }
        this.state = TokenizerState.LITERAL_STATE;
    }

    /*
     * WARNING - void declaration
     */
    void escape(String escapeChars, StringBuffer buf) {
        if (this.pointer < this.patternLength) {
            void var3_3;
            void var2_2;
            void var1_1;
            char next = this.pattern.charAt(this.pointer++);
            this.escapeUtil.escape((String)var1_1, (StringBuffer)var2_2, (char)var3_3, this.pointer);
        }
    }

    /*
     * WARNING - void declaration
     */
    void optionEscape(String escapeChars, StringBuffer buf) {
        if (this.pointer < this.patternLength) {
            void var3_3;
            void var2_2;
            void var1_1;
            char next = this.pattern.charAt(this.pointer++);
            this.optionEscapeUtil.escape((String)var1_1, (StringBuffer)var2_2, (char)var3_3, this.pointer);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addValuedToken(int type, StringBuffer buf, List<Token> tokenList) {
        if (buf.length() > 0) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.add(new Token((int)var1_1, buf.toString()));
            var2_2.setLength(0);
        }
    }

    static enum TokenizerState {
        LITERAL_STATE,
        FORMAT_MODIFIER_STATE,
        KEYWORD_STATE,
        OPTION_STATE,
        RIGHT_PARENTHESIS_STATE;

    }
}

