/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.IdentityCompositeConverter;
import ch.qos.logback.core.pattern.ReplacingCompositeConverter;
import ch.qos.logback.core.pattern.parser.Compiler;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Parser<E>
extends ContextAwareBase {
    public static final String MISSING_RIGHT_PARENTHESIS = "http://logback.qos.ch/codes.html#missingRightParenthesis";
    public static final Map<String, String> DEFAULT_COMPOSITE_CONVERTER_MAP = new HashMap<String, String>();
    public static final String REPLACE_CONVERTER_WORD = "replace";
    final List<Token> tokenList;
    int pointer = 0;

    /*
     * WARNING - void declaration
     */
    Parser(TokenStream ts) throws ScanException {
        void var1_1;
        this.tokenList = var1_1.tokenize();
    }

    /*
     * WARNING - void declaration
     */
    public Parser(String pattern) throws ScanException {
        this((String)var1_1, new RegularEscapeUtil());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Parser(String pattern, IEscapeUtil escapeUtil) throws ScanException {
        try {
            void var2_3;
            TokenStream ts = new TokenStream(pattern, (IEscapeUtil)var2_3);
            this.tokenList = ts.tokenize();
            return;
        }
        catch (IllegalArgumentException npe) {
            void var1_2;
            throw new ScanException("Failed to initialize Parser", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Converter<E> compile(Node top, Map<String, String> converterMap) {
        void var1_1;
        void var2_2;
        Compiler compiler = new Compiler(top, (Map<String, String>)var2_2);
        compiler.setContext(this.context);
        return var1_1.compile();
    }

    public Node parse() throws ScanException {
        return this.E();
    }

    /*
     * WARNING - void declaration
     */
    Node E() throws ScanException {
        void var1_1;
        Node t = this.T();
        if (t == null) {
            return null;
        }
        Node eOpt = this.Eopt();
        if (eOpt != null) {
            void var2_2;
            t.setNext((Node)var2_2);
        }
        return var1_1;
    }

    Node Eopt() throws ScanException {
        Token token = this.getCurentToken();
        if (token == null) {
            return null;
        }
        return this.E();
    }

    /*
     * WARNING - void declaration
     */
    Node T() throws ScanException {
        Token t = this.getCurentToken();
        this.expectNotNull(t, "a LITERAL or '%'");
        switch (t.getType()) {
            case 1000: {
                this.advanceTokenPointer();
                return new Node(0, t.getValue());
            }
            case 37: {
                void var2_2;
                FormattingNode c;
                this.advanceTokenPointer();
                Token u = this.getCurentToken();
                this.expectNotNull(u, "a FORMAT_MODIFIER, SIMPLE_KEYWORD or COMPOUND_KEYWORD");
                if (u.getType() == 1002) {
                    void var1_1;
                    FormatInfo fi = FormatInfo.valueOf(u.getValue());
                    this.advanceTokenPointer();
                    c = this.C();
                    c.setFormatInfo((FormatInfo)var1_1);
                } else {
                    c = this.C();
                }
                return var2_2;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    FormattingNode C() throws ScanException {
        void var1_1;
        Token t = this.getCurentToken();
        this.expectNotNull(t, "a LEFT_PARENTHESIS or KEYWORD");
        int n = t.getType();
        switch (n) {
            case 1004: {
                return this.SINGLE();
            }
            case 1005: {
                this.advanceTokenPointer();
                return this.COMPOSITE(t.getValue().toString());
            }
        }
        throw new IllegalStateException("Unexpected token " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    FormattingNode SINGLE() throws ScanException {
        void var1_1;
        Token t = this.getNextToken();
        SimpleKeywordNode keywordNode = new SimpleKeywordNode(t.getValue());
        Token ot = this.getCurentToken();
        if (ot != null && ot.getType() == 1006) {
            void var2_2;
            List<String> optionList = ot.getOptionsList();
            keywordNode.setOptions((List<String>)var2_2);
            this.advanceTokenPointer();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    FormattingNode COMPOSITE(String keyword) throws ScanException {
        void var1_1;
        CompositeNode compositeNode = new CompositeNode(keyword);
        Node childNode = this.E();
        compositeNode.setChildNode(childNode);
        Token t = this.getNextToken();
        if (t == null || t.getType() != 41) {
            String msg = "Expecting RIGHT_PARENTHESIS token but got " + t;
            this.addError(msg);
            this.addError("See also http://logback.qos.ch/codes.html#missingRightParenthesis");
            throw new ScanException(msg);
        }
        Token ot = this.getCurentToken();
        if (ot != null && ot.getType() == 1006) {
            void var2_2;
            List<String> optionList = ot.getOptionsList();
            compositeNode.setOptions((List<String>)var2_2);
            this.advanceTokenPointer();
        }
        return var1_1;
    }

    Token getNextToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer++);
        }
        return null;
    }

    Token getCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer);
        }
        return null;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    /*
     * WARNING - void declaration
     */
    void expectNotNull(Token t, String expected) {
        if (t == null) {
            void var2_2;
            throw new IllegalStateException("All tokens consumed but was expecting " + (String)var2_2);
        }
    }

    static {
        DEFAULT_COMPOSITE_CONVERTER_MAP.put(Token.BARE_COMPOSITE_KEYWORD_TOKEN.getValue().toString(), IdentityCompositeConverter.class.getName());
        DEFAULT_COMPOSITE_CONVERTER_MAP.put(REPLACE_CONVERTER_WORD, ReplacingCompositeConverter.class.getName());
    }
}

