/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.PostCompileProcessor;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.StatusManager;
import java.util.HashMap;
import java.util.Map;

public abstract class PatternLayoutBase<E>
extends LayoutBase<E> {
    static final int INTIAL_STRING_BUILDER_SIZE = 256;
    Converter<E> head;
    String pattern;
    protected PostCompileProcessor<E> postCompileProcessor;
    Map<String, String> instanceConverterMap = new HashMap<String, String>();
    protected boolean outputPatternAsHeader = false;

    public abstract Map<String, String> getDefaultConverterMap();

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getEffectiveConverterMap() {
        void var1_1;
        Map contextMap;
        Context context;
        HashMap<String, String> effectiveMap = new HashMap<String, String>();
        Map<String, String> defaultMap = this.getDefaultConverterMap();
        if (defaultMap != null) {
            effectiveMap.putAll(defaultMap);
        }
        if ((context = ((ContextAwareBase)this).getContext()) != null && (contextMap = (Map)context.getObject("PATTERN_RULE_REGISTRY")) != null) {
            void var2_2;
            effectiveMap.putAll((Map<String, String>)var2_2);
        }
        effectiveMap.putAll(this.instanceConverterMap);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        if (this.pattern == null || this.pattern.length() == 0) {
            this.addError("Empty or null pattern.");
            return;
        }
        try {
            void var2_3;
            Parser p = new Parser(this.pattern);
            if (((ContextAwareBase)this).getContext() != null) {
                p.setContext(((ContextAwareBase)this).getContext());
            }
            Node t = p.parse();
            this.head = p.compile((Node)var2_3, this.getEffectiveConverterMap());
            if (this.postCompileProcessor != null) {
                this.postCompileProcessor.process(this.context, this.head);
            }
            ConverterUtil.setContextForConverters(((ContextAwareBase)this).getContext(), this.head);
            ConverterUtil.startConverters(this.head);
            super.start();
            return;
        }
        catch (ScanException sce) {
            void var1_2;
            StatusManager statusManager = ((ContextAwareBase)this).getContext().getStatusManager();
            statusManager.add(new ErrorStatus("Failed to parse pattern \"" + this.getPattern() + "\".", this, (Throwable)var1_2));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPostCompileProcessor(PostCompileProcessor<E> postCompileProcessor) {
        void var1_1;
        this.postCompileProcessor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void setContextForConverters(Converter<E> head) {
        void var1_1;
        ConverterUtil.setContextForConverters(((ContextAwareBase)this).getContext(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected String writeLoopOnConverters(E event) {
        void var2_2;
        StringBuilder strBuilder = new StringBuilder(256);
        for (Converter<E> c = this.head; c != null; c = c.getNext()) {
            c.write(strBuilder, event);
        }
        return var2_2.toString();
    }

    public String getPattern() {
        return this.pattern;
    }

    /*
     * WARNING - void declaration
     */
    public void setPattern(String pattern) {
        void var1_1;
        this.pattern = var1_1;
    }

    public String toString() {
        return this.getClass().getName() + "(\"" + this.getPattern() + "\")";
    }

    public Map<String, String> getInstanceConverterMap() {
        return this.instanceConverterMap;
    }

    protected String getPresentationHeaderPrefix() {
        return "";
    }

    public boolean isOutputPatternAsHeader() {
        return this.outputPatternAsHeader;
    }

    /*
     * WARNING - void declaration
     */
    public void setOutputPatternAsHeader(boolean outputPatternAsHeader) {
        void var1_1;
        this.outputPatternAsHeader = var1_1;
    }

    @Override
    public String getPresentationHeader() {
        if (this.outputPatternAsHeader) {
            return this.getPresentationHeaderPrefix() + this.pattern;
        }
        return super.getPresentationHeader();
    }
}

