/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.SpacePadder;

public abstract class FormattingConverter<E>
extends Converter<E> {
    static final int INITIAL_BUF_SIZE = 256;
    static final int MAX_CAPACITY = 1024;
    FormatInfo formattingInfo;

    public final FormatInfo getFormattingInfo() {
        return this.formattingInfo;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFormattingInfo(FormatInfo formattingInfo) {
        void var1_1;
        if (this.formattingInfo != null) {
            throw new IllegalStateException("FormattingInfo has been already set");
        }
        this.formattingInfo = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(StringBuilder buf, E event) {
        void var2_2;
        void var1_1;
        String s = this.convert(event);
        if (this.formattingInfo == null) {
            buf.append(s);
            return;
        }
        int min = this.formattingInfo.getMin();
        int max = this.formattingInfo.getMax();
        if (s == null) {
            if (min > 0) {
                SpacePadder.spacePad(buf, min);
            }
            return;
        }
        int len = s.length();
        if (len > max) {
            if (this.formattingInfo.isLeftTruncate()) {
                buf.append(s.substring(len - max));
                return;
            }
            buf.append(s.substring(0, max));
            return;
        }
        if (len < min) {
            void var3_3;
            if (this.formattingInfo.isLeftPad()) {
                SpacePadder.leftPad(buf, s, min);
                return;
            }
            SpacePadder.rightPad(buf, s, (int)var3_3);
            return;
        }
        var1_1.append((String)var2_2);
    }
}

