/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.net.ssl.SSLConfigurable;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.StringCollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class SSLParametersConfiguration
extends ContextAwareBase {
    private String includedProtocols;
    private String excludedProtocols;
    private String includedCipherSuites;
    private String excludedCipherSuites;
    private Boolean needClientAuth;
    private Boolean wantClientAuth;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;
    private Boolean hostnameVerification;

    /*
     * WARNING - void declaration
     */
    public void configure(SSLConfigurable socket) {
        socket.setEnabledProtocols(this.enabledProtocols(socket.getSupportedProtocols(), socket.getDefaultProtocols()));
        socket.setEnabledCipherSuites(this.enabledCipherSuites(socket.getSupportedCipherSuites(), socket.getDefaultCipherSuites()));
        if (this.isNeedClientAuth() != null) {
            socket.setNeedClientAuth(this.isNeedClientAuth());
        }
        if (this.isWantClientAuth() != null) {
            socket.setWantClientAuth(this.isWantClientAuth());
        }
        if (this.hostnameVerification != null) {
            void var1_1;
            this.addInfo("hostnameVerification=" + this.hostnameVerification);
            var1_1.setHostnameVerification(this.hostnameVerification);
        }
    }

    public boolean getHostnameVerification() {
        if (this.hostnameVerification == null) {
            return false;
        }
        return this.hostnameVerification;
    }

    /*
     * WARNING - void declaration
     */
    public void setHostnameVerification(boolean hostnameVerification) {
        void var1_1;
        this.hostnameVerification = (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String[] enabledProtocols(String[] supportedProtocols, String[] defaultProtocols) {
        if (this.enabledProtocols == null) {
            String[] stringArray;
            if (OptionHelper.isNullOrEmpty(this.getIncludedProtocols()) && OptionHelper.isNullOrEmpty(this.getExcludedProtocols())) {
                void var2_2;
                void v0 = var2_2;
                this.enabledProtocols = (String[])Arrays.copyOf(v0, ((void)v0).length);
            } else {
                this.enabledProtocols = this.includedStrings(stringArray, this.getIncludedProtocols(), this.getExcludedProtocols());
            }
            stringArray = this.enabledProtocols;
            int n = this.enabledProtocols.length;
            for (int i = 0; i < n; ++i) {
                String protocol = stringArray[i];
                this.addInfo("enabled protocol: " + protocol);
            }
        }
        return this.enabledProtocols;
    }

    /*
     * WARNING - void declaration
     */
    private String[] enabledCipherSuites(String[] supportedCipherSuites, String[] defaultCipherSuites) {
        if (this.enabledCipherSuites == null) {
            String[] stringArray;
            if (OptionHelper.isNullOrEmpty(this.getIncludedCipherSuites()) && OptionHelper.isNullOrEmpty(this.getExcludedCipherSuites())) {
                void var2_2;
                void v0 = var2_2;
                this.enabledCipherSuites = (String[])Arrays.copyOf(v0, ((void)v0).length);
            } else {
                this.enabledCipherSuites = this.includedStrings(stringArray, this.getIncludedCipherSuites(), this.getExcludedCipherSuites());
            }
            stringArray = this.enabledCipherSuites;
            int n = this.enabledCipherSuites.length;
            for (int i = 0; i < n; ++i) {
                String cipherSuite = stringArray[i];
                this.addInfo("enabled cipher suite: " + cipherSuite);
            }
        }
        return this.enabledCipherSuites;
    }

    /*
     * WARNING - void declaration
     */
    private String[] includedStrings(String[] defaults, String included, String excluded) {
        void var1_1;
        ArrayList<String> values = new ArrayList<String>(defaults.length);
        values.addAll(Arrays.asList(var1_1));
        if (included != null) {
            void var2_2;
            StringCollectionUtil.retainMatching(values, this.stringToArray((String)var2_2));
        }
        if (excluded != null) {
            void var3_3;
            StringCollectionUtil.removeMatching(values, this.stringToArray((String)var3_3));
        }
        ArrayList<String> arrayList = values;
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] stringToArray(String s) {
        return s.split("\\s*,\\s*");
    }

    public String getIncludedProtocols() {
        return this.includedProtocols;
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludedProtocols(String protocols) {
        void var1_1;
        this.includedProtocols = var1_1;
    }

    public String getExcludedProtocols() {
        return this.excludedProtocols;
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludedProtocols(String protocols) {
        void var1_1;
        this.excludedProtocols = var1_1;
    }

    public String getIncludedCipherSuites() {
        return this.includedCipherSuites;
    }

    /*
     * WARNING - void declaration
     */
    public void setIncludedCipherSuites(String cipherSuites) {
        void var1_1;
        this.includedCipherSuites = var1_1;
    }

    public String getExcludedCipherSuites() {
        return this.excludedCipherSuites;
    }

    /*
     * WARNING - void declaration
     */
    public void setExcludedCipherSuites(String cipherSuites) {
        void var1_1;
        this.excludedCipherSuites = var1_1;
    }

    public Boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    /*
     * WARNING - void declaration
     */
    public void setNeedClientAuth(Boolean needClientAuth) {
        void var1_1;
        this.needClientAuth = var1_1;
    }

    public Boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    /*
     * WARNING - void declaration
     */
    public void setWantClientAuth(Boolean wantClientAuth) {
        void var1_1;
        this.wantClientAuth = var1_1;
    }
}

