/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.net.ssl.KeyManagerFactoryFactoryBean;
import ch.qos.logback.core.net.ssl.KeyStoreFactoryBean;
import ch.qos.logback.core.net.ssl.SecureRandomFactoryBean;
import ch.qos.logback.core.net.ssl.TrustManagerFactoryFactoryBean;
import ch.qos.logback.core.spi.ContextAware;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextFactoryBean {
    private static final String JSSE_KEY_STORE_PROPERTY = "javax.net.ssl.keyStore";
    private static final String JSSE_TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    private KeyStoreFactoryBean keyStore;
    private KeyStoreFactoryBean trustStore;
    private SecureRandomFactoryBean secureRandom;
    private KeyManagerFactoryFactoryBean keyManagerFactory;
    private TrustManagerFactoryFactoryBean trustManagerFactory;
    private String protocol;
    private String provider;

    /*
     * WARNING - void declaration
     */
    public SSLContext createContext(ContextAware context) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException, UnrecoverableKeyException, KeyStoreException, CertificateException {
        void var2_2;
        void var1_1;
        void var3_3;
        SSLContext sslContext = this.getProvider() != null ? SSLContext.getInstance(this.getProtocol(), this.getProvider()) : SSLContext.getInstance(this.getProtocol());
        context.addInfo("SSL protocol '" + sslContext.getProtocol() + "' provider '" + sslContext.getProvider() + "'");
        KeyManager[] keyManagers = this.createKeyManagers(context);
        TrustManager[] trustManagers = this.createTrustManagers(context);
        SecureRandom secureRandom = this.createSecureRandom(context);
        sslContext.init((KeyManager[])var3_3, trustManagers, (SecureRandom)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private KeyManager[] createKeyManagers(ContextAware context) throws NoSuchProviderException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        void var3_3;
        void var1_1;
        void var2_2;
        if (this.getKeyStore() == null) {
            return null;
        }
        KeyStore keyStore = this.getKeyStore().createKeyStore();
        context.addInfo("key store of type '" + keyStore.getType() + "' provider '" + keyStore.getProvider() + "': " + this.getKeyStore().getLocation());
        KeyManagerFactory kmf = this.getKeyManagerFactory().createKeyManagerFactory();
        context.addInfo("key manager algorithm '" + kmf.getAlgorithm() + "' provider '" + kmf.getProvider() + "'");
        char[] passphrase = this.getKeyStore().getPassword().toCharArray();
        kmf.init((KeyStore)var2_2, (char[])var1_1);
        return var3_3.getKeyManagers();
    }

    /*
     * WARNING - void declaration
     */
    private TrustManager[] createTrustManagers(ContextAware context) throws NoSuchProviderException, NoSuchAlgorithmException, KeyStoreException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.getTrustStore() == null) {
            return null;
        }
        KeyStore trustStore = this.getTrustStore().createKeyStore();
        context.addInfo("trust store of type '" + trustStore.getType() + "' provider '" + trustStore.getProvider() + "': " + this.getTrustStore().getLocation());
        TrustManagerFactory tmf = this.getTrustManagerFactory().createTrustManagerFactory();
        var1_1.addInfo("trust manager algorithm '" + tmf.getAlgorithm() + "' provider '" + tmf.getProvider() + "'");
        tmf.init((KeyStore)var2_2);
        return var3_3.getTrustManagers();
    }

    /*
     * WARNING - void declaration
     */
    private SecureRandom createSecureRandom(ContextAware context) throws NoSuchProviderException, NoSuchAlgorithmException {
        void var2_2;
        void var1_1;
        SecureRandom secureRandom = this.getSecureRandom().createSecureRandom();
        var1_1.addInfo("secure random algorithm '" + secureRandom.getAlgorithm() + "' provider '" + secureRandom.getProvider() + "'");
        return var2_2;
    }

    public KeyStoreFactoryBean getKeyStore() {
        if (this.keyStore == null) {
            this.keyStore = this.keyStoreFromSystemProperties(JSSE_KEY_STORE_PROPERTY);
        }
        return this.keyStore;
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyStore(KeyStoreFactoryBean keyStore) {
        void var1_1;
        this.keyStore = var1_1;
    }

    public KeyStoreFactoryBean getTrustStore() {
        if (this.trustStore == null) {
            this.trustStore = this.keyStoreFromSystemProperties(JSSE_TRUST_STORE_PROPERTY);
        }
        return this.trustStore;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStore(KeyStoreFactoryBean trustStore) {
        void var1_1;
        this.trustStore = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private KeyStoreFactoryBean keyStoreFromSystemProperties(String property) {
        void var2_2;
        void var1_1;
        if (System.getProperty(property) == null) {
            return null;
        }
        KeyStoreFactoryBean keyStore = new KeyStoreFactoryBean();
        keyStore.setLocation(this.locationFromSystemProperty(property));
        keyStore.setProvider(System.getProperty(property + "Provider"));
        keyStore.setPassword(System.getProperty(property + "Password"));
        keyStore.setType(System.getProperty((String)var1_1 + "Type"));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String locationFromSystemProperty(String name) {
        void var1_1;
        String location = System.getProperty(name);
        if (location != null && !location.startsWith("file:")) {
            location = "file:" + location;
        }
        return var1_1;
    }

    public SecureRandomFactoryBean getSecureRandom() {
        if (this.secureRandom == null) {
            return new SecureRandomFactoryBean();
        }
        return this.secureRandom;
    }

    /*
     * WARNING - void declaration
     */
    public void setSecureRandom(SecureRandomFactoryBean secureRandom) {
        void var1_1;
        this.secureRandom = var1_1;
    }

    public KeyManagerFactoryFactoryBean getKeyManagerFactory() {
        if (this.keyManagerFactory == null) {
            return new KeyManagerFactoryFactoryBean();
        }
        return this.keyManagerFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyManagerFactory(KeyManagerFactoryFactoryBean keyManagerFactory) {
        void var1_1;
        this.keyManagerFactory = var1_1;
    }

    public TrustManagerFactoryFactoryBean getTrustManagerFactory() {
        if (this.trustManagerFactory == null) {
            return new TrustManagerFactoryFactoryBean();
        }
        return this.trustManagerFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustManagerFactory(TrustManagerFactoryFactoryBean trustManagerFactory) {
        void var1_1;
        this.trustManagerFactory = var1_1;
    }

    public String getProtocol() {
        if (this.protocol == null) {
            return "SSL";
        }
        return this.protocol;
    }

    /*
     * WARNING - void declaration
     */
    public void setProtocol(String protocol) {
        void var1_1;
        this.protocol = var1_1;
    }

    public String getProvider() {
        return this.provider;
    }

    /*
     * WARNING - void declaration
     */
    public void setProvider(String provider) {
        void var1_1;
        this.provider = var1_1;
    }
}

