/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.util.LocationUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class KeyStoreFactoryBean {
    private String location;
    private String provider;
    private String type;
    private String password;

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyStore createKeyStore() throws NoSuchProviderException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore keyStore;
        if (this.getLocation() == null) {
            throw new IllegalArgumentException("location is required");
        }
        Object inputStream = null;
        try {
            URL uRL = LocationUtil.urlForResource(this.getLocation());
            inputStream = uRL.openStream();
            keyStore = this.newKeyStore();
            keyStore.load((InputStream)inputStream, this.getPassword().toCharArray());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            try {
                throw new NoSuchProviderException("no such keystore provider: " + this.getProvider());
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new NoSuchAlgorithmException("no such keystore type: " + this.getType());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new KeyStoreException(this.getLocation() + ": file not found");
                }
                catch (Exception ex) {
                    void var2_3;
                    throw new KeyStoreException(this.getLocation() + ": " + ex.getMessage(), (Throwable)var2_3);
                }
            }
            catch (Throwable throwable) {
                IOException iOException;
                try {
                    if (inputStream == null) throw throwable;
                    ((InputStream)((Object)iOException)).close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                    iOException2.printStackTrace(System.err);
                }
                throw throwable;
            }
        }
        try {
            if (inputStream == null) return keyStore;
            ((InputStream)inputStream).close();
            return keyStore;
        }
        catch (IOException iOException) {
            inputStream = iOException;
            iOException.printStackTrace(System.err);
        }
        return keyStore;
    }

    private KeyStore newKeyStore() throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException {
        if (this.getProvider() != null) {
            return KeyStore.getInstance(this.getType(), this.getProvider());
        }
        return KeyStore.getInstance(this.getType());
    }

    public String getLocation() {
        return this.location;
    }

    /*
     * WARNING - void declaration
     */
    public void setLocation(String location) {
        void var1_1;
        this.location = var1_1;
    }

    public String getType() {
        if (this.type == null) {
            return "JKS";
        }
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public void setType(String type) {
        void var1_1;
        this.type = var1_1;
    }

    public String getProvider() {
        return this.provider;
    }

    /*
     * WARNING - void declaration
     */
    public void setProvider(String provider) {
        void var1_1;
        this.provider = var1_1;
    }

    public String getPassword() {
        if (this.password == null) {
            return "changeit";
        }
        return this.password;
    }

    /*
     * WARNING - void declaration
     */
    public void setPassword(String password) {
        void var1_1;
        this.password = var1_1;
    }
}

