/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.helpers.CyclicBuffer;
import ch.qos.logback.core.net.LoginAuthenticator;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.sift.DefaultDiscriminator;
import ch.qos.logback.core.sift.Discriminator;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.CyclicBufferTracker;
import ch.qos.logback.core.util.ContentTypeUtil;
import ch.qos.logback.core.util.JNDIUtil;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.Context;

public abstract class SMTPAppenderBase<E>
extends AppenderBase<E> {
    static InternetAddress[] EMPTY_IA_ARRAY = new InternetAddress[0];
    static final long MAX_DELAY_BETWEEN_STATUS_MESSAGES = 1228800000L;
    long lastTrackerStatusPrint = 0L;
    long delayBetweenStatusMessages = 300000L;
    protected Layout<E> subjectLayout;
    protected Layout<E> layout;
    private List<PatternLayoutBase<E>> toPatternLayoutList = new ArrayList<PatternLayoutBase<E>>();
    private String from;
    private String subjectStr = null;
    private String smtpHost;
    private int smtpPort = 25;
    private boolean starttls = false;
    private boolean ssl = false;
    private boolean sessionViaJNDI = false;
    private String jndiLocation = "java:comp/env/mail/Session";
    String username;
    String password;
    String localhost;
    boolean asynchronousSending = true;
    protected Future<?> asynchronousSendingFuture = null;
    private String charsetEncoding = "UTF-8";
    protected Session session;
    protected EventEvaluator<E> eventEvaluator;
    protected Discriminator<E> discriminator = new DefaultDiscriminator();
    protected CyclicBufferTracker<E> cbTracker;
    private int errorCount = 0;

    protected abstract Layout<E> makeSubjectLayout(String var1);

    @Override
    public void start() {
        if (this.cbTracker == null) {
            this.cbTracker = new CyclicBufferTracker();
        }
        this.session = this.sessionViaJNDI ? this.lookupSessionInJNDI() : this.buildSessionFromProperties();
        if (this.session == null) {
            this.addError("Failed to obtain javax.mail.Session. Cannot start.");
            return;
        }
        this.subjectLayout = this.makeSubjectLayout(this.subjectStr);
        this.started = true;
    }

    /*
     * WARNING - void declaration
     */
    private Session lookupSessionInJNDI() {
        this.addInfo("Looking up javax.mail.Session at JNDI location [" + this.jndiLocation + "]");
        try {
            Object object = JNDIUtil.getInitialContext();
            object = JNDIUtil.lookupObject((Context)object, this.jndiLocation);
            return (Session)object;
        }
        catch (Exception e) {
            void var1_2;
            this.addError("Failed to obtain javax.mail.Session from JNDI location [" + this.jndiLocation + "]", (Throwable)var1_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Session buildSessionFromProperties() {
        void var2_2;
        void var1_1;
        Properties props = new Properties(OptionHelper.getSystemProperties());
        if (this.smtpHost != null) {
            props.put("mail.smtp.host", this.smtpHost);
        }
        props.put("mail.smtp.port", Integer.toString(this.smtpPort));
        if (this.localhost != null) {
            props.put("mail.smtp.localhost", this.localhost);
        }
        LoginAuthenticator loginAuthenticator = null;
        if (!OptionHelper.isNullOrEmpty(this.username)) {
            loginAuthenticator = new LoginAuthenticator(this.username, this.password);
            props.put("mail.smtp.auth", "true");
        }
        if (this.isSTARTTLS() && this.isSSL()) {
            this.addError("Both SSL and StartTLS cannot be enabled simultaneously");
        } else {
            if (this.isSTARTTLS()) {
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.transport.protocol", "true");
            }
            if (this.isSSL()) {
                props.put("mail.smtp.ssl.enable", "true");
            }
        }
        return Session.getInstance((Properties)var1_1, (Authenticator)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void append(E eventObject) {
        void var1_1;
        long now;
        block9: {
            if (!this.checkEntryConditions()) {
                return;
            }
            String key = this.discriminator.getDiscriminatingValue(eventObject);
            now = System.currentTimeMillis();
            CyclicBuffer cb = (CyclicBuffer)this.cbTracker.getOrCreate(key, now);
            this.subAppend(cb, eventObject);
            try {
                if (this.eventEvaluator.evaluate(eventObject)) {
                    CyclicBuffer cbClone = new CyclicBuffer(cb);
                    cb.clear();
                    if (this.asynchronousSending) {
                        SenderRunnable senderRunnable = new SenderRunnable(this, cbClone, eventObject);
                        this.asynchronousSendingFuture = this.context.getExecutorService().submit(senderRunnable);
                    } else {
                        this.sendBuffer(cbClone, eventObject);
                    }
                }
            }
            catch (EvaluationException ex) {
                ++this.errorCount;
                if (this.errorCount >= 4) break block9;
                this.addError("SMTPAppender's EventEvaluator threw an Exception-", ex);
            }
        }
        if (this.eventMarksEndOfLife(var1_1)) {
            void var2_2;
            this.cbTracker.endOfLife((String)var2_2);
        }
        this.cbTracker.removeStaleComponents(now);
        if (this.lastTrackerStatusPrint + this.delayBetweenStatusMessages < now) {
            void var3_3;
            this.addInfo("SMTPAppender [" + this.name + "] is tracking [" + this.cbTracker.getComponentCount() + "] buffers");
            this.lastTrackerStatusPrint = var3_3;
            if (this.delayBetweenStatusMessages < 1228800000L) {
                this.delayBetweenStatusMessages <<= 2;
            }
        }
    }

    protected abstract boolean eventMarksEndOfLife(E var1);

    protected abstract void subAppend(CyclicBuffer<E> var1, E var2);

    public boolean checkEntryConditions() {
        if (!this.started) {
            this.addError("Attempting to append to a non-started appender: " + this.getName());
            return false;
        }
        if (this.eventEvaluator == null) {
            this.addError("No EventEvaluator is set for appender [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.addError("No layout set for appender named [" + this.name + "]. For more information, please visit http://logback.qos.ch/codes.html#smtp_no_layout");
            return false;
        }
        return true;
    }

    @Override
    public synchronized void stop() {
        this.started = false;
    }

    /*
     * WARNING - void declaration
     */
    InternetAddress getAddress(String addressStr) {
        try {
            return new InternetAddress(addressStr);
        }
        catch (AddressException e) {
            void var2_2;
            void var1_1;
            this.addError("Could not parse address [" + (String)var1_1 + "].", (Throwable)var2_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<InternetAddress> parseAddress(E event) {
        void var3_3;
        int len = this.toPatternLayoutList.size();
        ArrayList<InternetAddress> iaList = new ArrayList<InternetAddress>();
        for (int i = 0; i < len; ++i) {
            try {
                PatternLayoutBase<E> patternLayoutBase = this.toPatternLayoutList.get(i);
                String emailAdrr = patternLayoutBase.doLayout(event);
                if (emailAdrr == null || emailAdrr.length() == 0) continue;
                InternetAddress[] tmp = InternetAddress.parse((String)emailAdrr, (boolean)true);
                iaList.addAll(Arrays.asList(tmp));
                continue;
            }
            catch (AddressException e) {
                this.addError("Could not parse email address for [" + this.toPatternLayoutList.get(i) + "] for event [" + event + "]", e);
                return iaList;
            }
        }
        return var3_3;
    }

    public List<PatternLayoutBase<E>> getToList() {
        return this.toPatternLayoutList;
    }

    protected void updateMimeMsg(MimeMessage mimeMsg, CyclicBuffer<E> cb, E lastEventObject) {
    }

    /*
     * WARNING - void declaration
     */
    protected void sendBuffer(CyclicBuffer<E> cb, E lastEventObject) {
        try {
            void var2_2;
            void var1_1;
            int newLinePos;
            String footer;
            String presentationHeader;
            MimeBodyPart part = new MimeBodyPart();
            StringBuffer sbuf = new StringBuffer();
            String header = this.layout.getFileHeader();
            if (header != null) {
                sbuf.append(header);
            }
            if ((presentationHeader = this.layout.getPresentationHeader()) != null) {
                sbuf.append(presentationHeader);
            }
            this.fillBuffer(cb, sbuf);
            String presentationFooter = this.layout.getPresentationFooter();
            if (presentationFooter != null) {
                sbuf.append(presentationFooter);
            }
            if ((footer = this.layout.getFileFooter()) != null) {
                sbuf.append(footer);
            }
            String subjectStr = "Undefined subject";
            if (this.subjectLayout != null && (newLinePos = (subjectStr = this.subjectLayout.doLayout(lastEventObject)) != null ? subjectStr.indexOf(10) : -1) >= 0) {
                subjectStr = subjectStr.substring(0, newLinePos);
            }
            MimeMessage mimeMsg = new MimeMessage(this.session);
            if (this.from != null) {
                SMTPAppenderBase sMTPAppenderBase = this;
                mimeMsg.setFrom((Address)sMTPAppenderBase.getAddress(sMTPAppenderBase.from));
            } else {
                mimeMsg.setFrom();
            }
            mimeMsg.setSubject(subjectStr, this.charsetEncoding);
            List<InternetAddress> destinationAddresses = this.parseAddress(lastEventObject);
            if (destinationAddresses.isEmpty()) {
                this.addInfo("Empty destination address. Aborting email transmission");
                return;
            }
            Object[] toAddressArray = destinationAddresses.toArray(EMPTY_IA_ARRAY);
            mimeMsg.setRecipients(Message.RecipientType.TO, (Address[])toAddressArray);
            String contentType = this.layout.getContentType();
            if (ContentTypeUtil.isTextual(contentType)) {
                part.setText(sbuf.toString(), this.charsetEncoding, ContentTypeUtil.getSubType(contentType));
            } else {
                part.setContent((Object)sbuf.toString(), this.layout.getContentType());
            }
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)part);
            mimeMsg.setContent((Multipart)mp);
            this.updateMimeMsg(mimeMsg, (CyclicBuffer<E>)var1_1, var2_2);
            mimeMsg.setSentDate(new Date());
            this.addInfo("About to send out SMTP message \"" + subjectStr + "\" to " + Arrays.toString(toAddressArray));
            Transport.send((Message)mimeMsg);
            return;
        }
        catch (Exception e) {
            void var3_4;
            this.addError("Error occurred while sending e-mail notification.", (Throwable)var3_4);
            return;
        }
    }

    protected abstract void fillBuffer(CyclicBuffer<E> var1, StringBuffer var2);

    public String getFrom() {
        return this.from;
    }

    public String getSubject() {
        return this.subjectStr;
    }

    /*
     * WARNING - void declaration
     */
    public void setFrom(String from) {
        void var1_1;
        this.from = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSubject(String subject) {
        void var1_1;
        this.subjectStr = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setSMTPHost(String smtpHost) {
        void var1_1;
        this.setSmtpHost((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSmtpHost(String smtpHost) {
        void var1_1;
        this.smtpHost = var1_1;
    }

    public String getSMTPHost() {
        return this.getSmtpHost();
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    /*
     * WARNING - void declaration
     */
    public void setSMTPPort(int port) {
        void var1_1;
        this.setSmtpPort((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSmtpPort(int port) {
        void var1_1;
        this.smtpPort = var1_1;
    }

    public int getSMTPPort() {
        return this.getSmtpPort();
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public String getLocalhost() {
        return this.localhost;
    }

    /*
     * WARNING - void declaration
     */
    public void setLocalhost(String localhost) {
        void var1_1;
        this.localhost = var1_1;
    }

    public CyclicBufferTracker<E> getCyclicBufferTracker() {
        return this.cbTracker;
    }

    /*
     * WARNING - void declaration
     */
    public void setCyclicBufferTracker(CyclicBufferTracker<E> cbTracker) {
        void var1_1;
        this.cbTracker = var1_1;
    }

    public Discriminator<E> getDiscriminator() {
        return this.discriminator;
    }

    /*
     * WARNING - void declaration
     */
    public void setDiscriminator(Discriminator<E> discriminator) {
        void var1_1;
        this.discriminator = var1_1;
    }

    public boolean isAsynchronousSending() {
        return this.asynchronousSending;
    }

    /*
     * WARNING - void declaration
     */
    public void setAsynchronousSending(boolean asynchronousSending) {
        void var1_1;
        this.asynchronousSending = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void addTo(String to) {
        void var1_1;
        if (to == null || to.length() == 0) {
            throw new IllegalArgumentException("Null or empty <to> property");
        }
        PatternLayoutBase<E> plb = this.makeNewToPatternLayout(to.trim());
        ((ContextAwareBase)plb).setContext(this.context);
        ((LayoutBase)plb).start();
        this.toPatternLayoutList.add((PatternLayoutBase<void>)var1_1);
    }

    protected abstract PatternLayoutBase<E> makeNewToPatternLayout(String var1);

    /*
     * WARNING - void declaration
     */
    public List<String> getToAsListOfString() {
        void var1_1;
        ArrayList<String> toList = new ArrayList<String>();
        for (PatternLayoutBase<E> plb : this.toPatternLayoutList) {
            void var3_3;
            toList.add(var3_3.getPattern());
        }
        return var1_1;
    }

    public boolean isSTARTTLS() {
        return this.starttls;
    }

    /*
     * WARNING - void declaration
     */
    public void setSTARTTLS(boolean startTLS) {
        void var1_1;
        this.starttls = var1_1;
    }

    public boolean isSSL() {
        return this.ssl;
    }

    /*
     * WARNING - void declaration
     */
    public void setSSL(boolean ssl) {
        void var1_1;
        this.ssl = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEvaluator(EventEvaluator<E> eventEvaluator) {
        void var1_1;
        this.eventEvaluator = var1_1;
    }

    public String getUsername() {
        return this.username;
    }

    /*
     * WARNING - void declaration
     */
    public void setUsername(String username) {
        void var1_1;
        this.username = var1_1;
    }

    public String getPassword() {
        return this.password;
    }

    /*
     * WARNING - void declaration
     */
    public void setPassword(String password) {
        void var1_1;
        this.password = var1_1;
    }

    public String getCharsetEncoding() {
        return this.charsetEncoding;
    }

    public String getJndiLocation() {
        return this.jndiLocation;
    }

    /*
     * WARNING - void declaration
     */
    public void setJndiLocation(String jndiLocation) {
        void var1_1;
        this.jndiLocation = var1_1;
    }

    public boolean isSessionViaJNDI() {
        return this.sessionViaJNDI;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionViaJNDI(boolean sessionViaJNDI) {
        void var1_1;
        this.sessionViaJNDI = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setCharsetEncoding(String charsetEncoding) {
        void var1_1;
        this.charsetEncoding = var1_1;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    /*
     * WARNING - void declaration
     */
    public void setLayout(Layout<E> layout) {
        void var1_1;
        this.layout = var1_1;
    }

    class SenderRunnable
    implements Runnable {
        final CyclicBuffer<E> cyclicBuffer;
        final E e;
        final /* synthetic */ SMTPAppenderBase this$0;

        /*
         * WARNING - void declaration
         */
        SenderRunnable(SMTPAppenderBase this$0, CyclicBuffer<E> cyclicBuffer, E e) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.cyclicBuffer = var2_2;
            this.e = var3_3;
        }

        @Override
        public void run() {
            this.this$0.sendBuffer(this.cyclicBuffer, this.e);
        }
    }
}

