/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net;

import ch.qos.logback.core.util.EnvUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HardenedObjectInputStream
extends ObjectInputStream {
    private final List<String> whitelistedClassNames;
    private static final String[] JAVA_PACKAGES = new String[]{"java.lang", "java.util"};
    private static final int DEPTH_LIMIT = 16;
    private static final int ARRAY_LIMIT = 10000;

    public HardenedObjectInputStream(InputStream in, String[] whitelist) throws IOException {
        super(in);
        this.initObjectFilter();
        this.whitelistedClassNames = new ArrayList<String>();
        if (whitelist != null) {
            for (int i = 0; i < whitelist.length; ++i) {
                this.whitelistedClassNames.add(whitelist[i]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public HardenedObjectInputStream(InputStream in, List<String> whitelist) throws IOException {
        super((InputStream)var1_1);
        void var2_2;
        void var1_1;
        this.initObjectFilter();
        this.whitelistedClassNames = new ArrayList<String>();
        this.whitelistedClassNames.addAll((Collection<String>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void initObjectFilter() {
        if (EnvUtil.isJDK9OrHigher()) {
            try {
                void var2_3;
                ClassLoader classLoader = this.getClass().getClassLoader();
                Class<?> oifClass = classLoader.loadClass("java.io.ObjectInputFilter");
                GenericDeclaration oifConfigClass = classLoader.loadClass("java.io.ObjectInputFilter$Config");
                Method setObjectInputFilterMethod = this.getClass().getMethod("setObjectInputFilter", oifClass);
                oifConfigClass = oifConfigClass.getMethod("createFilter", String.class);
                Object filter = ((Method)oifConfigClass).invoke(null, "maxarray=10000;maxdepth=16;");
                var2_3.invoke((Object)this, filter);
                return;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                void var1_2;
                throw new RuntimeException("Failed to initialize object filter", (Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Class<?> resolveClass(ObjectStreamClass anObjectStreamClass) throws IOException, ClassNotFoundException {
        void var1_1;
        void var2_2;
        String incomingClassName = anObjectStreamClass.getName();
        if (!this.isWhitelisted((String)var2_2)) {
            throw new InvalidClassException("Unauthorized deserialization attempt", anObjectStreamClass.getName());
        }
        return super.resolveClass((ObjectStreamClass)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isWhitelisted(String incomingClassName) {
        for (int i = 0; i < JAVA_PACKAGES.length; ++i) {
            if (!incomingClassName.startsWith(JAVA_PACKAGES[i])) continue;
            return true;
        }
        for (String whiteListed : this.whitelistedClassNames) {
            void var3_4;
            if (!incomingClassName.equals(var3_4)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected void addToWhitelist(List<String> additionalAuthorizedClasses) {
        void var1_1;
        this.whitelistedClassNames.addAll((Collection<String>)var1_1);
    }
}

