/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class PropertyModelHandler
extends ModelHandlerBase {
    public static final String INVALID_ATTRIBUTES = "In <property> element, either the \"file\" attribute alone, or the \"resource\" element alone, or both the \"name\" and \"value\" attributes must be set.";

    /*
     * WARNING - void declaration
     */
    public PropertyModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        Context context2;
        return new PropertyModelHandler(context2);
    }

    protected Class<PropertyModel> getSupportedModelClass() {
        return PropertyModel.class;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(ModelInterpretationContext interpretationContext, Model model) {
        void var2_4;
        void e12;
        PropertyModel propertyModel = (PropertyModel)model;
        ActionUtil.Scope scope = ActionUtil.stringToScope(propertyModel.getScopeStr());
        if (this.checkFileAttributeSanity(propertyModel)) {
            String file = propertyModel.getFile();
            file = interpretationContext.subst(file);
            try (FileInputStream istream = new FileInputStream(file);){
                this.loadAndSetProperties(interpretationContext, istream, scope);
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.addError("Could not find properties file [" + file + "].");
                return;
            }
            catch (IOException | IllegalArgumentException e12) {
                this.addError("Could not read properties file [" + file + "].", e12);
            }
            return;
        }
        if (this.checkResourceAttributeSanity((PropertyModel)e12)) {
            String resource = e12.getResource();
            URL resourceURL = Loader.getResourceBySelfClassLoader(resource = interpretationContext.subst(resource));
            if (resourceURL == null) {
                this.addError("Could not find resource [" + resource + "].");
                return;
            }
            try {
                InputStream istream = var2_4.openStream();
                try {
                    this.loadAndSetProperties(interpretationContext, istream, scope);
                    return;
                }
                finally {
                    if (istream == null) return;
                    istream.close();
                }
            }
            catch (IOException e) {
                this.addError("Could not read resource file [" + resource + "].", e);
            }
            return;
        }
        if (this.checkValueNameAttributesSanity((PropertyModel)var2_4)) {
            void var3_7;
            void var1_1;
            String resource = var2_4.getValue();
            String value = resource.trim();
            value = interpretationContext.subst(value);
            ActionUtil.setProperty((ModelInterpretationContext)var1_1, var2_4.getName(), value, (ActionUtil.Scope)var3_7);
            return;
        }
        this.addError(INVALID_ATTRIBUTES);
    }

    /*
     * WARNING - void declaration
     */
    void loadAndSetProperties(ModelInterpretationContext mic, InputStream istream, ActionUtil.Scope scope) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Properties props = new Properties();
        props.load((InputStream)var2_2);
        ModelUtil.setProperties((ModelInterpretationContext)var1_1, props, (ActionUtil.Scope)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    boolean checkFileAttributeSanity(PropertyModel propertyModel) {
        void var1_1;
        void var3_3;
        void var2_2;
        String file = propertyModel.getFile();
        String name = propertyModel.getName();
        String value = propertyModel.getValue();
        String resource = propertyModel.getResource();
        return !OptionHelper.isNullOrEmpty((String)var2_2) && OptionHelper.isNullOrEmpty((String)var3_3) && OptionHelper.isNullOrEmpty(value) && OptionHelper.isNullOrEmpty((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    boolean checkResourceAttributeSanity(PropertyModel propertyModel) {
        void var2_2;
        void var3_3;
        String string;
        String file = propertyModel.getFile();
        String name = propertyModel.getName();
        String value = propertyModel.getValue();
        return !OptionHelper.isNullOrEmpty(string = ((PropertyModel)((Object)string)).getResource()) && OptionHelper.isNullOrEmpty((String)var3_3) && OptionHelper.isNullOrEmpty(value) && OptionHelper.isNullOrEmpty((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    boolean checkValueNameAttributesSanity(PropertyModel propertyModel) {
        void var1_1;
        void var2_2;
        void var3_3;
        String file = propertyModel.getFile();
        String name = propertyModel.getName();
        String value = propertyModel.getValue();
        String resource = propertyModel.getResource();
        return !OptionHelper.isNullOrEmpty((String)var3_3) && !OptionHelper.isNullOrEmpty(value) && OptionHelper.isNullOrEmpty((String)var2_2) && OptionHelper.isNullOrEmpty((String)var1_1);
    }
}

