/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model.processor;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.model.EventEvaluatorModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.processor.ModelHandlerBase;
import ch.qos.logback.core.model.processor.ModelHandlerException;
import ch.qos.logback.core.model.processor.ModelInterpretationContext;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.OptionHelper;
import java.util.Map;

public class EventEvaluatorModelHandler
extends ModelHandlerBase {
    EventEvaluator<?> evaluator;
    boolean inError = false;

    /*
     * WARNING - void declaration
     */
    public EventEvaluatorModelHandler(Context context) {
        super((Context)var1_1);
        void var1_1;
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        Context context2;
        return new EventEvaluatorModelHandler(context2);
    }

    protected Class<EventEvaluatorModel> getSupportedModelClass() {
        return EventEvaluatorModel.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(ModelInterpretationContext intercon, Model model) throws ModelHandlerException {
        void var2_3;
        EventEvaluatorModel eem = (EventEvaluatorModel)model;
        String className = eem.getClassName();
        if (OptionHelper.isNullOrEmpty(className)) {
            String defaultClassName = this.defaultClassName(intercon, eem);
            if (OptionHelper.isNullOrEmpty(defaultClassName)) {
                this.inError = true;
                this.addError("Mandatory \"class\" attribute missing for <evaluator>");
                this.addError("No default classname could be found.");
                return;
            }
            this.addInfo("Assuming default evaluator class [" + defaultClassName + "]");
            className = defaultClassName;
        } else {
            className = intercon.getImport(className);
        }
        String evaluatorName = intercon.subst(var2_3.getName());
        try {
            this.evaluator = (EventEvaluator)OptionHelper.instantiateByClassName(className, EventEvaluator.class, this.context);
            this.evaluator.setContext(this.context);
            this.evaluator.setName(evaluatorName);
            intercon.pushObject(this.evaluator);
            return;
        }
        catch (Exception oops) {
            void var1_2;
            void var3_4;
            this.inError = true;
            this.addError("Could not create evaluator of type " + (String)var3_4 + "].", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String defaultClassName(ModelInterpretationContext mic, EventEvaluatorModel model) {
        void var2_2;
        DefaultNestedComponentRegistry defaultNestedComponentRegistry = mic.getDefaultNestedComponentRegistry();
        return defaultNestedComponentRegistry.findDefaultComponentTypeByTag(var2_2.getTag());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void postHandle(ModelInterpretationContext intercon, Model model) throws ModelHandlerException {
        Object object;
        if (this.inError) {
            return;
        }
        if (this.evaluator instanceof LifeCycle) {
            this.evaluator.start();
            this.addInfo("Starting evaluator named [" + this.evaluator.getName() + "]");
        }
        if ((object = intercon.peekObject()) != this.evaluator) {
            this.addWarn("The object on the top the of the stack is not the evaluator pushed earlier.");
            return;
        }
        intercon.popObject();
        try {
            Map evaluatorMap = (Map)this.context.getObject("EVALUATOR_MAP");
            if (evaluatorMap != null) {
                evaluatorMap.put(this.evaluator.getName(), this.evaluator);
                return;
            }
            this.addError("Could not find EvaluatorMap");
        }
        catch (Exception ex) {
            void var1_2;
            this.addError("Could not set evaluator named [" + this.evaluator + "].", (Throwable)var1_2);
        }
    }
}

