/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.util;

import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.util.StringToObjectConverter;
import ch.qos.logback.core.joran.util.beans.BeanDescription;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.joran.util.beans.BeanUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.AggregationType;
import ch.qos.logback.core.util.PropertySetterException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropertySetter
extends ContextAwareBase {
    protected final Object obj;
    protected final Class<?> objClass;
    protected final BeanDescription beanDescription;

    /*
     * WARNING - void declaration
     */
    public PropertySetter(BeanDescriptionCache beanDescriptionCache, Object obj) {
        void var1_1;
        void var2_2;
        this.obj = obj;
        this.objClass = var2_2.getClass();
        this.beanDescription = var1_1.getBeanDescription(this.objClass);
    }

    /*
     * WARNING - void declaration
     */
    public void setProperty(String name, String value) {
        if (value == null) {
            return;
        }
        Method setter = this.findSetterMethod(name);
        if (setter == null) {
            this.addWarn("No setter for property [" + name + "] in " + this.objClass.getName() + ".");
            return;
        }
        try {
            this.setProperty(setter, name, value);
            return;
        }
        catch (PropertySetterException ex) {
            void var3_4;
            void var2_2;
            void var1_1;
            this.addWarn("Failed to set property [" + (String)var1_1 + "] to value \"" + (String)var2_2 + "\". ", (Throwable)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setProperty(Method setter, String name, String value) throws PropertySetterException {
        Object arg;
        Class<?>[] paramTypes = setter.getParameterTypes();
        try {
            arg = StringToObjectConverter.convertArg(this, value, paramTypes[0]);
        }
        catch (Throwable t) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed. ", t);
        }
        if (arg == null) {
            void var2_4;
            throw new PropertySetterException("Conversion to type [" + var2_4[0] + "] failed.");
        }
        try {
            void var3_5;
            t.invoke(this.obj, var3_5);
            return;
        }
        catch (Exception ex) {
            void var1_3;
            throw new PropertySetterException((Throwable)var1_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public AggregationType computeAggregationType(String name) {
        void var1_1;
        Method setter;
        String cName = this.capitalizeFirstLetter(name);
        Method addMethod = this.findAdderMethod(cName);
        if (addMethod != null) {
            AggregationType type = this.computeRawAggregationType(addMethod);
            switch (type) {
                case NOT_FOUND: {
                    return AggregationType.NOT_FOUND;
                }
                case AS_BASIC_PROPERTY: {
                    return AggregationType.AS_BASIC_PROPERTY_COLLECTION;
                }
                case AS_COMPLEX_PROPERTY: {
                    return AggregationType.AS_COMPLEX_PROPERTY_COLLECTION;
                }
                case AS_BASIC_PROPERTY_COLLECTION: 
                case AS_COMPLEX_PROPERTY_COLLECTION: {
                    this.addError("Unexpected AggregationType " + (Object)((Object)type));
                }
            }
        }
        if ((setter = this.findSetterMethod((String)var1_1)) != null) {
            void var2_2;
            return this.computeRawAggregationType((Method)var2_2);
        }
        return AggregationType.NOT_FOUND;
    }

    /*
     * WARNING - void declaration
     */
    private Method findAdderMethod(String name) {
        void var1_1;
        String propertyName = BeanUtil.toLowerCamelCase(name);
        return this.beanDescription.getAdder((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Method findSetterMethod(String name) {
        void var1_1;
        String propertyName = BeanUtil.toLowerCamelCase(name);
        return this.beanDescription.getSetter((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Class<?> getParameterClassForMethod(Method method) {
        void var1_1;
        if (method == null) {
            return null;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length != 1) {
            return null;
        }
        return var1_1[0];
    }

    /*
     * WARNING - void declaration
     */
    private AggregationType computeRawAggregationType(Method method) {
        void var1_1;
        Class<?> parameterClass = this.getParameterClassForMethod(method);
        if (parameterClass == null) {
            return AggregationType.NOT_FOUND;
        }
        if (StringToObjectConverter.canBeBuiltFromSimpleString(var1_1)) {
            return AggregationType.AS_BASIC_PROPERTY;
        }
        return AggregationType.AS_COMPLEX_PROPERTY;
    }

    private boolean isUnequivocallyInstantiable(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        try {
            Object t;
            t = ((Class)t).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return t != null;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
    }

    public Class<?> getObjClass() {
        return this.objClass;
    }

    /*
     * WARNING - void declaration
     */
    public void addComplexProperty(String name, Object complexProperty) {
        void var1_1;
        Method adderMethod = this.findAdderMethod(name);
        if (adderMethod != null) {
            void var2_2;
            void var3_3;
            Class<?>[] paramTypes = adderMethod.getParameterTypes();
            if (!this.isSanityCheckSuccessful(name, adderMethod, paramTypes, complexProperty)) {
                return;
            }
            this.invokeMethodWithSingleParameterOnThisObject((Method)var3_3, var2_2);
            return;
        }
        this.addError("Could not find method [add" + (String)var1_1 + "] in class [" + this.objClass.getName() + "].");
    }

    /*
     * WARNING - void declaration
     */
    void invokeMethodWithSingleParameterOnThisObject(Method method, Object parameter) {
        Class<?> ccc = parameter.getClass();
        try {
            method.invoke(this.obj, parameter);
            return;
        }
        catch (Exception e) {
            void var2_3;
            void var3_4;
            void var1_1;
            this.addError("Could not invoke method " + var1_1.getName() + " in class " + this.obj.getClass().getName() + " with parameter of type " + var3_4.getName(), (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBasicProperty(String name, String strValue) {
        void var1_1;
        if (strValue == null) {
            return;
        }
        Method adderMethod = this.findAdderMethod(name = this.capitalizeFirstLetter(name));
        if (adderMethod == null) {
            this.addError("No adder for property [" + name + "].");
            return;
        }
        Class<?>[] paramTypes = adderMethod.getParameterTypes();
        this.isSanityCheckSuccessful(name, adderMethod, paramTypes, strValue);
        try {
            Object arg = StringToObjectConverter.convertArg(this, strValue, paramTypes[0]);
        }
        catch (Throwable t) {
            this.addError("Conversion to type [" + paramTypes[0] + "] failed. ", t);
            return;
        }
        if (var1_1 != null) {
            void var2_3;
            void var3_4;
            this.invokeMethodWithSingleParameterOnThisObject((Method)var3_4, var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setComplexProperty(String name, Object complexProperty) {
        Method setter = this.findSetterMethod(name);
        if (setter == null) {
            this.addWarn("Not setter method for property [" + name + "] in " + this.obj.getClass().getName());
            return;
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        if (!this.isSanityCheckSuccessful(name, setter, paramTypes, complexProperty)) {
            return;
        }
        try {
            void var2_3;
            void var3_4;
            this.invokeMethodWithSingleParameterOnThisObject((Method)var3_4, var2_3);
            return;
        }
        catch (Exception e) {
            void var1_2;
            this.addError("Could not set component " + this.obj + " for parent component " + this.obj, (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSanityCheckSuccessful(String name, Method method, Class<?>[] params, Object complexProperty) {
        Class<?> ccc = complexProperty.getClass();
        if (params.length != 1) {
            void var1_1;
            this.addError("Wrong number of parameters in setter method for property [" + (String)var1_1 + "] in " + this.obj.getClass().getName());
            return false;
        }
        if (!params[0].isAssignableFrom(complexProperty.getClass())) {
            void var2_2;
            void var3_3;
            this.addError("A \"" + ccc.getName() + "\" object is not assignable to a \"" + params[0].getName() + "\" variable.");
            this.addError("The class \"" + params[0].getName() + "\" was loaded by ");
            this.addError("[" + var3_3[0].getClassLoader() + "] whereas object of type ");
            this.addError("\"" + ccc.getName() + "\" was loaded by [" + var2_2.getClassLoader() + "].");
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String capitalizeFirstLetter(String name) {
        void var1_1;
        return name.substring(0, 1).toUpperCase() + var1_1.substring(1);
    }

    public Object getObj() {
        return this.obj;
    }

    /*
     * WARNING - void declaration
     */
    Method getRelevantMethod(String name, AggregationType aggregationType) {
        void var1_1;
        Method relevantMethod;
        if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY_COLLECTION) {
            relevantMethod = this.findAdderMethod(name);
        } else if (aggregationType == AggregationType.AS_COMPLEX_PROPERTY) {
            relevantMethod = this.findSetterMethod((String)((Object)relevantMethod));
        } else {
            void var2_2;
            throw new IllegalStateException(var2_2 + " not allowed here");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    <T extends Annotation> T getAnnotation(String name, Class<T> annonationClass, Method relevantMethod) {
        if (relevantMethod != null) {
            void var2_2;
            void var3_3;
            return var3_3.getAnnotation(var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Class<?> getDefaultClassNameByAnnonation(String name, Method relevantMethod) {
        void var2_2;
        DefaultClass defaultClassAnnon = this.getAnnotation(name, DefaultClass.class, (Method)var2_2);
        if (defaultClassAnnon != null) {
            void var1_1;
            return var1_1.value();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    Class<?> getByConcreteType(String name, Method relevantMethod) {
        void var2_2;
        Class<?> paramType = this.getParameterClassForMethod((Method)var2_2);
        if (paramType == null) {
            return null;
        }
        boolean bl = this.isUnequivocallyInstantiable(paramType);
        if (bl) {
            void var1_1;
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> getClassNameViaImplicitRules(String name, AggregationType aggregationType, DefaultNestedComponentRegistry registry) {
        void var2_2;
        void var1_1;
        Class<?> registryResult = registry.findDefaultComponentType(this.obj.getClass(), name);
        if (registryResult != null) {
            return registryResult;
        }
        Method relevantMethod = this.getRelevantMethod(name, aggregationType);
        if (relevantMethod == null) {
            return null;
        }
        Class<?> byAnnotation = this.getDefaultClassNameByAnnonation(name, relevantMethod);
        if (byAnnotation != null) {
            void var3_3;
            return var3_3;
        }
        return this.getByConcreteType((String)var1_1, (Method)var2_2);
    }
}

