/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.sanity;

import ch.qos.logback.core.joran.sanity.Pair;
import ch.qos.logback.core.joran.sanity.SanityChecker;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class AppenderWithinAppenderSanityChecker
extends ContextAwareBase
implements SanityChecker {
    public static String NESTED_APPENDERS_WARNING = "As of logback version 1.3, nested appenders are not allowed.";

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(Model model) {
        Iterator iterator;
        if (model == null) {
            return;
        }
        ArrayList<Model> appenderModels = new ArrayList<Model>();
        this.deepFindAllModelsOfType(AppenderModel.class, appenderModels, (Model)model);
        model = this.deepFindNestedSubModelsOfType(AppenderModel.class, appenderModels);
        List filteredNestedPairs = model.stream().filter(pair -> {
            void var1_1;
            return !this.isSiftingAppender((Model)var1_1.first);
        }).collect(Collectors.toList());
        if (filteredNestedPairs.isEmpty()) {
            return;
        }
        this.addWarn(NESTED_APPENDERS_WARNING);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Pair pair2 = (Pair)iterator.next();
            this.addWarn("Appender at line " + ((Model)pair2.first).getLineNumber() + " contains a nested appender at line " + ((Model)var2_2.second).getLineNumber());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSiftingAppender(Model first) {
        if (first instanceof AppenderModel) {
            void var1_1;
            AppenderModel appenderModel = (AppenderModel)first;
            String string = appenderModel.getClassName();
            if (string == null) {
                return false;
            }
            return var1_1.getClassName().contains("SiftingAppender");
        }
        return false;
    }
}

