/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.event;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.BodyEvent;
import ch.qos.logback.core.joran.event.EndEvent;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.StartEvent;
import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.ContextAwareImpl;
import ch.qos.logback.core.status.Status;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxEventRecorder
extends DefaultHandler
implements ContextAware {
    final ContextAwareImpl contextAwareImpl;
    final ElementPath elementPath;
    List<SaxEvent> saxEventList = new ArrayList<SaxEvent>();
    Locator locator;

    /*
     * WARNING - void declaration
     */
    public SaxEventRecorder(Context context) {
        this((Context)var1_1, new ElementPath());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SaxEventRecorder(Context context, ElementPath elementPath) {
        void var2_2;
        void var1_1;
        this.contextAwareImpl = new ContextAwareImpl((Context)var1_1, this);
        this.elementPath = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void recordEvents(InputStream inputStream) throws JoranException {
        void var1_1;
        this.recordEvents(new InputSource((InputStream)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void recordEvents(InputSource inputSource) throws JoranException {
        SAXParser saxParser = this.buildSaxParser();
        try {
            void var2_5;
            var2_5.parse(inputSource, (DefaultHandler)this);
            return;
        }
        catch (IOException ie) {
            this.handleError("I/O error occurred while parsing xml file", ie);
        }
        catch (SAXException se) {
            throw new JoranException("Problem parsing XML document. See previously reported errors.", se);
        }
        catch (Exception ex) {
            void var1_4;
            this.handleError("Unexpected exception while parsing XML document.", (Throwable)var1_4);
        }
        throw new IllegalStateException("This point can never be reached");
    }

    /*
     * WARNING - void declaration
     */
    private void handleError(String errMsg, Throwable t) throws JoranException {
        void var2_2;
        void var1_1;
        this.addError(errMsg, t);
        throw new JoranException((String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private SAXParser buildSaxParser() throws JoranException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(false);
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setNamespaceAware(true);
            return spf.newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            String errMsg = "Error during SAX paser configuration. See https://logback.qos.ch/codes.html#saxParserConfiguration";
            this.addError(errMsg, pce);
            throw new JoranException(errMsg, pce);
        }
        catch (SAXException pce) {
            void var1_3;
            void var2_5;
            String errMsg = "Error during parser creation or parser configuration";
            this.addError(errMsg, pce);
            throw new JoranException((String)var2_5, (Throwable)var1_3);
        }
    }

    @Override
    public void startDocument() {
    }

    public Locator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDocumentLocator(Locator l) {
        void var1_1;
        this.locator = var1_1;
    }

    protected boolean shouldIgnoreForElementPath(String tagName) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        void var3_3;
        void var2_2;
        void var1_1;
        String tagName = this.getTagName(localName, qName);
        if (!this.shouldIgnoreForElementPath(tagName)) {
            this.elementPath.push(tagName);
        }
        ElementPath current = this.elementPath.duplicate();
        this.saxEventList.add(new StartEvent(current, (String)var1_1, (String)var2_2, (String)var3_3, atts, this.getLocator()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void characters(char[] ch, int start, int length) {
        void var3_4;
        String bodyStr = new String(ch, start, (int)var3_4);
        SaxEvent lastEvent = this.getLastEvent();
        if (lastEvent instanceof BodyEvent) {
            BodyEvent bodyEvent;
            bodyEvent = bodyEvent;
            bodyEvent.append(bodyStr);
            return;
        }
        if (!this.isSpaceOnly(bodyStr)) {
            void var1_1;
            this.saxEventList.add(new BodyEvent((String)var1_1, this.getLocator()));
        }
    }

    boolean isSpaceOnly(String bodyStr) {
        String string = bodyStr.trim();
        return string.length() == 0;
    }

    /*
     * WARNING - void declaration
     */
    SaxEvent getLastEvent() {
        void var1_1;
        if (this.saxEventList.isEmpty()) {
            return null;
        }
        int size = this.saxEventList.size();
        return this.saxEventList.get((int)(var1_1 - true));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.saxEventList.add(new EndEvent(namespaceURI, localName, qName, this.getLocator()));
        String tagName = this.getTagName((String)var2_2, (String)var3_3);
        if (!this.shouldIgnoreForElementPath((String)var1_1)) {
            this.elementPath.pop();
        }
    }

    /*
     * WARNING - void declaration
     */
    String getTagName(String localName, String qName) {
        void var1_1;
        String tagName = localName;
        if (tagName == null || tagName.length() <= 0) {
            void var2_2;
            tagName = var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(SAXParseException spe) throws SAXException {
        void var1_1;
        this.addError("XML_PARSING - Parsing error on line " + spe.getLineNumber() + " and column " + spe.getColumnNumber());
        this.addError(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fatalError(SAXParseException spe) throws SAXException {
        void var1_1;
        this.addError("XML_PARSING - Parsing fatal error on line " + spe.getLineNumber() + " and column " + spe.getColumnNumber());
        this.addError(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warning(SAXParseException spe) throws SAXException {
        void var1_1;
        this.addWarn("XML_PARSING - Parsing warning on line " + spe.getLineNumber() + " and column " + spe.getColumnNumber(), (Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addError(String msg) {
        void var1_1;
        this.contextAwareImpl.addError((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addError(String msg, Throwable ex) {
        void var2_2;
        void var1_1;
        this.contextAwareImpl.addError((String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addInfo(String msg) {
        void var1_1;
        this.contextAwareImpl.addInfo((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addInfo(String msg, Throwable ex) {
        void var2_2;
        void var1_1;
        this.contextAwareImpl.addInfo((String)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addStatus(Status status) {
        void var1_1;
        this.contextAwareImpl.addStatus((Status)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addWarn(String msg) {
        void var1_1;
        this.contextAwareImpl.addWarn((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addWarn(String msg, Throwable ex) {
        void var2_2;
        void var1_1;
        this.contextAwareImpl.addWarn((String)var1_1, (Throwable)var2_2);
    }

    @Override
    public Context getContext() {
        return this.contextAwareImpl.getContext();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setContext(Context context) {
        void var1_1;
        this.contextAwareImpl.setContext((Context)var1_1);
    }

    public List<SaxEvent> getSaxEventList() {
        return this.saxEventList;
    }
}

