/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.event.SaxEventRecorder;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.xml.sax.Attributes;

public class IncludeAction
extends Action {
    private static final String FILE_ATTR = "file";
    private static final String URL_ATTR = "url";
    private static final String RESOURCE_ATTR = "resource";
    private static final String OPTIONAL_ATTR = "optional";
    private String attributeInUse;
    private boolean optional;
    Model parentModel;
    IncludeModel includeModel;
    boolean inError = false;

    /*
     * WARNING - void declaration
     */
    @Override
    public void begin(SaxEventInterpretationContext ec, String name, Attributes attributes) throws ActionException {
        void var3_5;
        this.parentModel = null;
        this.includeModel = null;
        SaxEventRecorder recorder = new SaxEventRecorder(this.context);
        String optionalStr = attributes.getValue(OPTIONAL_ATTR);
        this.createModelForAlternateUse(ec, name, attributes, optionalStr);
        this.attributeInUse = null;
        this.optional = OptionHelper.toBoolean(optionalStr, false);
        if (!this.checkAttributes(attributes)) {
            this.inError = true;
            return;
        }
        InputStream in = this.getInputStream(ec, (Attributes)var3_5);
        try {
            if (in != null) {
                this.parseAndRecord(in, recorder);
                this.trimHeadAndTail(recorder);
                ec.getSaxEventInterpreter().getEventPlayer().addEventsDynamically(recorder.getSaxEventList(), 2);
            }
            this.close(in);
            return;
        }
        catch (JoranException je) {
            try {
                void var1_2;
                this.addError("Error while parsing  " + this.attributeInUse, (Throwable)var1_2);
                this.close(in);
                return;
            }
            catch (Throwable throwable) {
                void var2_4;
                this.close((InputStream)var2_4);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createModelForAlternateUse(SaxEventInterpretationContext seic, String name, Attributes attributes, String optionalStr) {
        void var1_1;
        void var2_3;
        void var3_4;
        this.includeModel = new IncludeModel();
        this.includeModel.setOptional(optionalStr);
        IncludeAction includeAction = this;
        includeAction.fillInIncludeModelAttributes(includeAction.includeModel, name, (Attributes)var3_4);
        if (!seic.isModelStackEmpty()) {
            this.parentModel = seic.peekModel();
        }
        int lineNumber = IncludeAction.getLineNumber(seic);
        this.includeModel.setLineNumber((int)var2_3);
        var1_1.pushModel(this.includeModel);
    }

    /*
     * WARNING - void declaration
     */
    private void fillInIncludeModelAttributes(IncludeModel includeModel, String name, Attributes attributes) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.includeModel.setTag(name);
        String fileAttribute = attributes.getValue(FILE_ATTR);
        String urlAttribute = attributes.getValue(URL_ATTR);
        String resourceAttribute = attributes.getValue(RESOURCE_ATTR);
        this.includeModel.setFile((String)var1_1);
        this.includeModel.setUrl((String)var2_2);
        this.includeModel.setResource((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    void close(InputStream in) {
        if (in != null) {
            try {
                void var1_1;
                var1_1.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkAttributes(Attributes attributes) {
        void var1_1;
        void var3_3;
        void var2_2;
        String fileAttribute = attributes.getValue(FILE_ATTR);
        String urlAttribute = attributes.getValue(URL_ATTR);
        String resourceAttribute = attributes.getValue(RESOURCE_ATTR);
        int count = 0;
        if (!OptionHelper.isNullOrEmpty((String)var2_2)) {
            ++count;
        }
        if (!OptionHelper.isNullOrEmpty((String)var3_3)) {
            ++count;
        }
        if (!OptionHelper.isNullOrEmpty((String)var1_1)) {
            ++count;
        }
        if (count == 0) {
            this.addError("One of \"path\", \"resource\" or \"url\" attributes must be set.");
            return false;
        }
        if (count > 1) {
            this.addError("Only one of \"file\", \"url\" or \"resource\" attributes should be set.");
            return false;
        }
        if (count == 1) {
            return true;
        }
        throw new IllegalStateException("Count value [" + count + "] is not expected");
    }

    /*
     * WARNING - void declaration
     */
    URL attributeToURL(String urlAttribute) {
        try {
            return new URL(urlAttribute);
        }
        catch (MalformedURLException mue) {
            void var2_2;
            void var1_1;
            String errMsg = "URL [" + urlAttribute + "] is not well formed.";
            this.addError((String)var1_1, (Throwable)var2_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    InputStream openURL(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            void var1_1;
            this.optionalWarning("Failed to open [" + var1_1.toString() + "]");
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    URL resourceAsURL(String resourceAttribute) {
        void var2_2;
        URL url = Loader.getResourceBySelfClassLoader(resourceAttribute);
        if (url == null) {
            void var1_1;
            this.optionalWarning("Could not find resource corresponding to [" + (String)var1_1 + "]");
            return null;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void optionalWarning(String msg) {
        if (!this.optional) {
            void var1_1;
            this.addWarn((String)var1_1);
        }
    }

    URL filePathAsURL(String path) {
        MalformedURLException malformedURLException;
        URI uri = new File(path).toURI();
        try {
            return ((URI)((Object)malformedURLException)).toURL();
        }
        catch (MalformedURLException malformedURLException2) {
            malformedURLException = malformedURLException2;
            malformedURLException2.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    URL getInputURL(SaxEventInterpretationContext ec, Attributes attributes) {
        String fileAttribute = attributes.getValue(FILE_ATTR);
        String urlAttribute = attributes.getValue(URL_ATTR);
        String resourceAttribute = attributes.getValue(RESOURCE_ATTR);
        if (!OptionHelper.isNullOrEmpty(fileAttribute)) {
            void var3_3;
            this.attributeInUse = ec.subst((String)var3_3);
            IncludeAction includeAction = this;
            return includeAction.filePathAsURL(includeAction.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmpty(urlAttribute)) {
            this.attributeInUse = ec.subst(urlAttribute);
            IncludeAction includeAction = this;
            return includeAction.attributeToURL(includeAction.attributeInUse);
        }
        if (!OptionHelper.isNullOrEmpty(resourceAttribute)) {
            void var2_2;
            void var1_1;
            this.attributeInUse = var1_1.subst((String)var2_2);
            IncludeAction includeAction = this;
            return includeAction.resourceAsURL(includeAction.attributeInUse);
        }
        throw new IllegalStateException("A URL stream should have been returned");
    }

    /*
     * WARNING - void declaration
     */
    InputStream getInputStream(SaxEventInterpretationContext ec, Attributes attributes) {
        void var1_1;
        void var2_2;
        URL inputURL = this.getInputURL(ec, (Attributes)var2_2);
        if (inputURL == null) {
            return null;
        }
        ConfigurationWatchListUtil.addToWatchList(this.context, inputURL);
        return this.openURL((URL)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void trimHeadAndTail(SaxEventRecorder recorder) {
        void var2_2;
        List<SaxEvent> saxEventList = recorder.getSaxEventList();
        if (saxEventList.size() == 0) {
            return;
        }
        SaxEvent first = saxEventList.get(0);
        if (first != null && first.qName.equalsIgnoreCase("included")) {
            saxEventList.remove(0);
        }
        List<SaxEvent> list = saxEventList;
        SaxEvent last = list.get(list.size() - 1);
        if (last != null && var2_2.qName.equalsIgnoreCase("included")) {
            void var1_1;
            void v1 = var1_1;
            v1.remove(v1.size() - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseAndRecord(InputStream inputSource, SaxEventRecorder recorder) throws JoranException {
        void var1_1;
        void var2_2;
        recorder.setContext(this.context);
        var2_2.recordEvents((InputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void end(SaxEventInterpretationContext seic, String name) throws ActionException {
        if (this.inError) {
            return;
        }
        Model model = seic.peekModel();
        if (model != this.includeModel) {
            this.addWarn("The object at the of the stack is not the model [" + this.includeModel.idString() + "] pushed earlier.");
            this.addWarn("This is wholly unexpected.");
        }
        if (this.parentModel != null) {
            void var1_1;
            this.parentModel.addSubModel(this.includeModel);
            var1_1.popModel();
        }
    }
}

